/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.dropdown;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.view.ViewItem;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DropDownIcon
implements Icon {
    public static final String ICON_KEY = "dock.dropdown.icon";
    private Icon icon;
    private Icon disabledIcon;
    private boolean disabledIconInvalid = true;
    private Dockable dockable;
    private DropDownAction action;
    private ViewItem<? extends JComponent> parent;
    private IconColor color;
    private IconValue replacingIcon;
    private PropertyValue<Dimension> minimumSize = new PropertyValue<Dimension>(IconManager.MINIMUM_ICON_SIZE){

        @Override
        protected void valueChanged(Dimension oldValue, Dimension newValue) {
            DropDownIcon.this.resetIcon();
        }
    };

    public DropDownIcon() {
        this.resetIcon();
    }

    public void init(Dockable dockable, DropDownAction action, ViewItem<? extends JComponent> parent) {
        if (this.isInitialized()) {
            throw new IllegalStateException("this icon is already initialized");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        this.dockable = dockable;
        this.action = action;
        this.parent = parent;
        this.color = new IconColor();
        this.replacingIcon = new IconValue();
        this.resetIcon();
    }

    public boolean isInitialized() {
        return this.dockable != null;
    }

    public DropDownAction getAction() {
        return this.action;
    }

    public JComponent getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getItem();
    }

    public void setController(DockController controller) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("this icon must be initialized first");
        }
        this.color.connect(controller);
        this.minimumSize.setProperties(controller);
        this.replacingIcon.setController(controller);
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null) {
            this.disabledIcon = new DisabledIcon();
        }
        return this.disabledIcon;
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.icon.paintIcon(c, g, x, y);
    }

    protected void resetIcon() {
        this.disabledIconInvalid = true;
        int oldWidth = -1;
        int oldHeight = -1;
        if (this.icon != null) {
            oldWidth = this.icon.getIconWidth();
            oldHeight = this.icon.getIconHeight();
        }
        Icon newIcon = null;
        if (this.replacingIcon != null) {
            newIcon = (Icon)this.replacingIcon.value();
        }
        if (newIcon == null) {
            Dimension size = this.minimumSize.getValue();
            int width = size.width / 2 - size.width / 16;
            int height = size.height / 2 - size.height / 16;
            width = Math.max(1, width);
            height = Math.max(1, height);
            Color iconColor = null;
            if (this.color != null) {
                iconColor = (Color)this.color.value();
            }
            newIcon = new DefaultIcon(width, height, iconColor);
        }
        this.icon = newIcon;
        JComponent parent = this.getParent();
        if (parent != null) {
            if (oldWidth != this.icon.getIconHeight() || oldHeight != this.icon.getIconHeight()) {
                parent.invalidate();
            }
            parent.repaint();
        }
    }

    private class DisabledIcon
    implements Icon {
        private Icon disabled;
        private Color lastForeground;

        private DisabledIcon() {
        }

        @Override
        public int getIconWidth() {
            return DropDownIcon.this.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return DropDownIcon.this.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color currentForeground = c.getForeground();
            if (DropDownIcon.this.disabledIconInvalid || this.disabled == null || this.lastForeground == null || !this.lastForeground.equals(currentForeground)) {
                DropDownIcon.this.disabledIconInvalid = false;
                this.lastForeground = currentForeground;
                this.disabled = DockUtilities.disabledIcon(DropDownIcon.this.getParent(), DropDownIcon.this.icon);
            }
            this.disabled.paintIcon(c, g, x, y);
        }
    }

    private class DefaultIcon
    implements Icon {
        private Color color;
        private int width;
        private int height;

        public DefaultIcon(int width, int height, Color color) {
            this.width = width;
            this.height = height;
            this.color = color;
        }

        @Override
        public int getIconHeight() {
            return this.width;
        }

        @Override
        public int getIconWidth() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.color == null) {
                g.setColor(c.getForeground());
            } else {
                g.setColor(this.color);
            }
            int factor = Math.min(this.width, this.height);
            if (factor == 7) {
                g.drawLine(++x, y + 1, x + 4, y + 1);
                g.drawLine(x + 1, y + 2, x + 3, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 3);
            } else {
                float unit = Math.max(1.0f, (float)factor / 7.0f);
                float xu = (float)x + unit;
                int[] xs = new int[3];
                int[] ys = new int[3];
                xs[0] = (int)(xu + unit);
                ys[0] = (int)((float)y + 1.0f * unit);
                xs[1] = (int)(xu + 4.0f * unit);
                ys[1] = (int)((float)y + 1.0f * unit);
                xs[2] = (int)(xu + 2.5f * unit);
                ys[2] = (int)((float)y + 3.0f * unit);
                g.fillPolygon(xs, ys, 3);
            }
        }
    }

    private class IconValue
    extends DockActionIcon {
        public IconValue() {
            super(DropDownIcon.ICON_KEY, DropDownIcon.this.getAction());
        }

        @Override
        protected void changed(Icon oldValue, Icon newValue) {
            DropDownIcon.this.resetIcon();
        }
    }

    private class IconColor
    extends ActionColor {
        public IconColor() {
            super("action.dropdown.arrow", DropDownIcon.this.dockable, DropDownIcon.this.action, null);
        }

        @Override
        protected void changed(Color oldValue, Color newValue) {
            DropDownIcon.this.resetIcon();
        }
    }
}

