/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

final class BoostErf {
    private static final double MULTIPLIER = 1.34217729E8;
    private static final double ONE_OVER_ROOT_PI = 0.5641895835477563;
    private static final double ERFCX_APPROX = 6.71E7;
    private static final double COMPUTE_ERF = 0.5;
    private static final double ERFCX_NEG_X_MAX = Math.sqrt(Math.log(8.988465674311579E307));
    private static final double EXP_XX_1 = 9.778887033462524E-9;

    private BoostErf() {
    }

    static double erfc(double x) {
        return BoostErf.erfImp(x, true, false);
    }

    static double erf(double x) {
        return BoostErf.erfImp(x, false, false);
    }

    private static double erfImp(double z, boolean invert, boolean scaled) {
        double result;
        if (Double.isNaN(z)) {
            return Double.NaN;
        }
        if (z < 0.0) {
            if (!invert) {
                return -BoostErf.erfImp(-z, invert, false);
            }
            if (z < -0.5) {
                return 2.0 - BoostErf.erfImp(-z, invert, false);
            }
            return 1.0 + BoostErf.erfImp(-z, false, false);
        }
        if (z < 0.5) {
            if (z < 1.0E-10) {
                if (z == 0.0) {
                    result = z;
                } else {
                    double c = 0.0033791670955125737;
                    result = z * 1.125 + z * 0.0033791670955125737;
                }
            } else {
                double Y = 1.0449485778808594;
                double zz = z * z;
                double P2 = -3.227801209646057E-4;
                P2 = -0.007727583458021333 + P2 * zz;
                P2 = -0.050999073514677744 + P2 * zz;
                P2 = -0.3381651344593609 + P2 * zz;
                P2 = 0.08343058921465318 + P2 * zz;
                double Q2 = 3.70900071787748E-4;
                Q2 = 0.008585719250744061 + Q2 * zz;
                Q2 = 0.08752226001422525 + Q2 * zz;
                Q2 = 0.455004033050794 + Q2 * zz;
                Q2 = 1.0 + Q2 * zz;
                result = z * (1.0449485778808594 + P2 / Q2);
            }
        } else if (scaled || (invert ? z < 27.30078125 : z < 5.9306640625)) {
            boolean bl = invert = !invert;
            if (z < 1.5) {
                double Y = 0.40593576431274414;
                double zm = z - 0.5;
                double P3 = 0.0018042453829701423;
                P3 = 0.01950490012512188 + P3 * zm;
                P3 = 0.08889003689678844 + P3 * zm;
                P3 = 0.19100369579677542 + P3 * zm;
                P3 = 0.17811466584112035 + P3 * zm;
                P3 = -0.09809059221628125 + P3 * zm;
                double Q3 = 3.3751147248309467E-6;
                Q3 = 0.011338523357700142 + Q3 * zm;
                Q3 = 0.12385097467900864 + Q3 * zm;
                Q3 = 0.5780528048899024 + Q3 * zm;
                Q3 = 1.4262800484551132 + Q3 * zm;
                Q3 = 1.8475907098300222 + Q3 * zm;
                Q3 = 1.0 + Q3 * zm;
                result = 0.40593576431274414 + P3 / Q3;
                result = scaled ? (result /= z) : (result *= BoostErf.expmxx(z) / z);
            } else if (z < 2.5) {
                double Y = 0.5067281723022461;
                double zm = z - 1.5;
                double P4 = 2.3583911559688073E-4;
                P4 = 0.0032396240629084215 + P4 * zm;
                P4 = 0.017567943631180208 + P4 * zm;
                P4 = 0.04394818964209516 + P4 * zm;
                P4 = 0.03865403750357072 + P4 * zm;
                P4 = -0.024350047620769845 + P4 * zm;
                double Q4 = 0.004103697239789046;
                Q4 = 0.05639218374204782 + Q4 * zm;
                Q4 = 0.3257329247824444 + Q4 * zm;
                Q4 = 0.9824037091579202 + Q4 * zm;
                Q4 = 1.5399149494855244 + Q4 * zm;
                Q4 = 1.0 + Q4 * zm;
                result = 0.5067281723022461 + P4 / Q4;
                result = scaled ? (result /= z) : (result *= BoostErf.expmxx(z) / z);
            } else if (z < 4.0) {
                double Y = 0.540575f;
                double zm = z - 3.5;
                double P5 = 1.1321240664884757E-5;
                P5 = 2.5026996154479465E-4 + P5 * zm;
                P5 = 0.0021282562091461863 + P5 * zm;
                P5 = 0.008408076155555853 + P5 * zm;
                P5 = 0.013738442589635533 + P5 * zm;
                P5 = 0.0029527671653097167 + P5 * zm;
                double Q5 = 4.7941126952171447E-4;
                Q5 = 0.010598290648487654 + Q5 * zm;
                Q5 = 0.09584927263010615 + Q5 * zm;
                Q5 = 0.4425976594815631 + Q5 * zm;
                Q5 = 1.0421781416693843 + Q5 * zm;
                Q5 = 1.0 + Q5 * zm;
                result = (double)0.540575f + P5 / Q5;
                result = scaled ? (result /= z) : (result *= BoostErf.expmxx(z) / z);
            } else {
                double izz = 1.0 / (z * z);
                double p = 0.016315387137302097;
                p = 0.30532663496123236 + p * izz;
                p = 0.36034489994980445 + p * izz;
                p = 0.12578172611122926 + p * izz;
                p = 0.016083785148742275 + p * izz;
                p = 6.587491615298378E-4 + p * izz;
                double q = 1.0;
                q = 2.568520192289822 + q * izz;
                q = 1.8729528499234604 + q * izz;
                q = 0.5279051029514285 + q * izz;
                q = 0.06051834131244132 + q * izz;
                q = 0.0023352049762686918 + q * izz;
                result = izz * p / q;
                result = (0.5641895835477563 - result) / z;
                if (!scaled) {
                    result *= BoostErf.expmxx(z);
                }
            }
        } else {
            result = 0.0;
            boolean bl = invert = !invert;
        }
        if (invert) {
            result = 1.0 - result;
        }
        return result;
    }

    static double erfcx(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double ax = Math.abs(x);
        if (ax < 0.5) {
            double erfx = BoostErf.erf(x);
            if (ax < 9.778887033462524E-9) {
                return 1.0 - erfx;
            }
            double em1 = Math.expm1(x * x);
            return -erfx * em1 + em1 - erfx + 1.0;
        }
        if (x < 0.0) {
            if (x < -ERFCX_NEG_X_MAX) {
                return Double.POSITIVE_INFINITY;
            }
            double e = BoostErf.expxx(x);
            return e - BoostErf.erfImp(-x, true, true) + e;
        }
        if (x > 6.71E7) {
            return 0.5641895835477563 / x;
        }
        return BoostErf.erfImp(x, true, true);
    }

    static double erfcInv(double z) {
        double s;
        double p;
        double q;
        if (z < 0.0 || z > 2.0 || Double.isNaN(z)) {
            return Double.NaN;
        }
        if (z == (double)((int)z)) {
            return z == 1.0 ? 0.0 : (1.0 - z) * Double.POSITIVE_INFINITY;
        }
        if (z > 1.0) {
            q = 2.0 - z;
            p = 1.0 - q;
            s = -1.0;
        } else {
            p = 1.0 - z;
            q = z;
            s = 1.0;
        }
        return s * BoostErf.erfInvImp(p, q);
    }

    static double erfInv(double z) {
        double s;
        double q;
        double p;
        if (z < -1.0 || z > 1.0 || Double.isNaN(z)) {
            return Double.NaN;
        }
        if (z == (double)((int)z)) {
            return z == 0.0 ? z : z * Double.POSITIVE_INFINITY;
        }
        if (z < 0.0) {
            p = -z;
            q = 1.0 - p;
            s = -1.0;
        } else {
            p = z;
            q = 1.0 - z;
            s = 1.0;
        }
        return s * BoostErf.erfInvImp(p, q);
    }

    private static double erfInvImp(double p, double q) {
        double result = 0.0;
        if (p <= 0.5) {
            float Y = 0.089131474f;
            double P2 = -0.005387729650712429;
            P2 = 0.008226878746769157 + P2 * p;
            P2 = 0.02198786811111689 + P2 * p;
            P2 = -0.03656379714117627 + P2 * p;
            P2 = -0.012692614766297404 + P2 * p;
            P2 = 0.03348066254097446 + P2 * p;
            P2 = -0.008368748197417368 + P2 * p;
            P2 = -5.087819496582806E-4 + P2 * p;
            double Q2 = 8.862163904564247E-4;
            Q2 = -0.0023339375937419 + Q2 * p;
            Q2 = 0.07952836873415717 + Q2 * p;
            Q2 = -0.05273963823400997 + Q2 * p;
            Q2 = -0.7122890234154284 + Q2 * p;
            Q2 = 0.662328840472003 + Q2 * p;
            Q2 = 1.5622155839842302 + Q2 * p;
            Q2 = -1.5657455823417585 + Q2 * p;
            Q2 = -0.9700050433032906 + Q2 * p;
            Q2 = 1.0 + Q2 * p;
            double g = p * (p + 10.0);
            double r = P2 / Q2;
            result = g * 0.08913147449493408 + g * r;
        } else if (q >= 0.25) {
            float Y = 2.2494812f;
            double xs = q - 0.25;
            double P3 = -3.6719225470772936;
            P3 = 21.12946554483405 + P3 * xs;
            P3 = 17.445385985570866 + P3 * xs;
            P3 = -44.6382324441787 + P3 * xs;
            P3 = -18.851064805871424 + P3 * xs;
            P3 = 17.644729840837403 + P3 * xs;
            P3 = 8.3705032834312 + P3 * xs;
            P3 = 0.10526468069939171 + P3 * xs;
            P3 = -0.20243350835593876 + P3 * xs;
            double Q3 = 1.7211476576120028;
            Q3 = -22.643693341313973 + Q3 * xs;
            Q3 = 10.826866735546016 + Q3 * xs;
            Q3 = 48.560921310873994 + Q3 * xs;
            Q3 = -20.14326346804852 + Q3 * xs;
            Q3 = -28.66081804998 + Q3 * xs;
            Q3 = 3.971343795334387 + Q3 * xs;
            Q3 = 6.242641248542475 + Q3 * xs;
            Q3 = 1.0 + Q3 * xs;
            double g = Math.sqrt(-2.0 * Math.log(q));
            double r = P3 / Q3;
            result = g / (2.249481201171875 + r);
        } else {
            double x = Math.sqrt(-Math.log(q));
            if (x < 3.0) {
                float Y = 0.80722046f;
                double xs = x - 1.125;
                double P4 = -6.81149956853777E-10;
                P4 = 2.8522533178221704E-8 + P4 * xs;
                P4 = -6.794655751811263E-7 + P4 * xs;
                P4 = 0.0021455899538880526 + P4 * xs;
                P4 = 0.029015791000532906 + P4 * xs;
                P4 = 0.14286953440815717 + P4 * xs;
                P4 = 0.3377855389120359 + P4 * xs;
                P4 = 0.38707973897260434 + P4 * xs;
                P4 = 0.11703015634199525 + P4 * xs;
                P4 = -0.16379404719331705 + P4 * xs;
                P4 = -0.1311027816799519 + P4 * xs;
                double Q4 = 0.011059242293464892;
                Q4 = 0.15226433829533179 + Q4 * xs;
                Q4 = 0.848854343457902 + Q4 * xs;
                Q4 = 2.5930192162362027 + Q4 * xs;
                Q4 = 4.778465929458438 + Q4 * xs;
                Q4 = 5.381683457070069 + Q4 * xs;
                Q4 = 3.4662540724256723 + Q4 * xs;
                Q4 = 1.0 + Q4 * xs;
                double R = P4 / Q4;
                result = 0.807220458984375 * x + R * x;
            } else if (x < 6.0) {
                float Y = 0.9399557f;
                double xs = x - 3.0;
                double P5 = 2.6633922742578204E-12;
                P5 = -2.304047769118826E-10 + P5 * xs;
                P5 = 4.60469890584318E-6 + P5 * xs;
                P5 = 1.5754461742496055E-4 + P5 * xs;
                P5 = 0.0018712349281955923 + P5 * xs;
                P5 = 0.009508047013259196 + P5 * xs;
                P5 = 0.018557330651423107 + P5 * xs;
                P5 = -0.0022242652921344794 + P5 * xs;
                P5 = -0.0350353787183178 + P5 * xs;
                double Q5 = 7.646752923027944E-5;
                Q5 = 0.00263861676657016 + Q5 * xs;
                Q5 = 0.03415891436709477 + Q5 * xs;
                Q5 = 0.22009110576413124 + Q5 * xs;
                Q5 = 0.7620591645536234 + Q5 * xs;
                Q5 = 1.3653349817554064 + Q5 * xs;
                Q5 = 1.0 + Q5 * xs;
                double R = P5 / Q5;
                result = 0.9399557113647461 * x + R * x;
            } else if (x < 18.0) {
                float Y = 0.9836283f;
                double xs = x - 6.0;
                double P6 = 9.905570997331033E-17;
                P6 = -2.811287356288318E-14 + P6 * xs;
                P6 = 4.625961635228786E-9 + P6 * xs;
                P6 = 4.4969678992770644E-7 + P6 * xs;
                P6 = 1.4962478375834237E-5 + P6 * xs;
                P6 = 2.0938631748758808E-4 + P6 * xs;
                P6 = 0.001056288621524929 + P6 * xs;
                P6 = -0.0011295143874558028 + P6 * xs;
                P6 = -0.016743100507663373 + P6 * xs;
                double Q6 = 2.82243172016108E-7;
                Q6 = 2.7533547476472603E-5 + Q6 * xs;
                Q6 = 9.640118070051656E-4 + Q6 * xs;
                Q6 = 0.016074608709367652 + Q6 * xs;
                Q6 = 0.1381518657490833 + Q6 * xs;
                Q6 = 0.5914293448864175 + Q6 * xs;
                Q6 = 1.0 + Q6 * xs;
                double R = P6 / Q6;
                result = 0.9836282730102539 * x + R * x;
            } else {
                float Y = 0.99714565f;
                double xs = x - 18.0;
                double P7 = -1.1676501239718427E-18;
                P7 = 1.4559628671867504E-12 + P7 * xs;
                P7 = 4.116328311909442E-10 + P7 * xs;
                P7 = 3.963410113048012E-8 + P7 * xs;
                P7 = 1.6239777734251093E-6 + P7 * xs;
                P7 = 2.5472303741302746E-5 + P7 * xs;
                P7 = -7.79190719229054E-6 + P7 * xs;
                P7 = -0.002497821279189813 + P7 * xs;
                double Q7 = 5.097612765997785E-10;
                Q7 = 1.4443775662814415E-7 + Q7 * xs;
                Q7 = 1.4500735981823264E-5 + Q7 * xs;
                Q7 = 6.905382656226846E-4 + Q7 * xs;
                Q7 = 0.01694108381209759 + Q7 * xs;
                Q7 = 0.2071231122144225 + Q7 * xs;
                Q7 = 1.0 + Q7 * xs;
                double R = P7 / Q7;
                result = 0.9971456527709961 * x + R * x;
            }
        }
        return result;
    }

    static double expxx(double x) {
        double a = x * x;
        double b = BoostErf.squareLowUnscaled(x, a);
        return BoostErf.expxx(a, b);
    }

    static double expmxx(double x) {
        double a = x * x;
        double b = BoostErf.squareLowUnscaled(x, a);
        return BoostErf.expxx(-a, -b);
    }

    private static double expxx(double a, double b) {
        double ea = Math.exp(a);
        return ea * b + ea;
    }

    private static double squareLowUnscaled(double x, double xx) {
        double hx = BoostErf.highPartUnscaled(x);
        double lx = x - hx;
        return BoostErf.squareLow(hx, lx, xx);
    }

    private static double highPartUnscaled(double value) {
        double c = 1.34217729E8 * value;
        return c - (c - value);
    }

    private static double squareLow(double hx, double lx, double xx) {
        return lx * lx - (xx - hx * hx - 2.0 * lx * hx);
    }
}

