/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.StationData;
import org.meteothink.imep.verification.DichotomousMethod;
import org.meteothink.imep.verification.MethodType;
import org.meteothink.imep.verification.VerifyMethod;
import org.meteothink.imep.verification.VerifyStat;
import org.meteothink.imep.verification.VerifyTable;

public class ContingencyTable
extends VerifyTable {
    public int hit = 0;
    public int miss = 0;
    public int falseAlarm = 0;
    public int correctNegative = 0;

    public ContingencyTable() {
    }

    public ContingencyTable(List<Number> obsData, List<Number> fcstData, Double min, Double max) {
        DichotomousMethod method = new DichotomousMethod(min, max);
        ContingencyTable table = (ContingencyTable)VerifyStat.getVerifyTable(obsData, fcstData, (VerifyMethod)method);
        this.hit = table.hit;
        this.miss = table.miss;
        this.falseAlarm = table.falseAlarm;
        this.correctNegative = table.correctNegative;
    }

    public int getTotal() {
        return this.hit + this.miss + this.falseAlarm + this.correctNegative;
    }

    public int getObsYes() {
        return this.hit + this.miss;
    }

    public int getObsNo() {
        return this.falseAlarm + this.correctNegative;
    }

    public int getForecastYes() {
        return this.hit + this.falseAlarm;
    }

    public int getForecastNo() {
        return this.miss + this.correctNegative;
    }

    public float getAccuracy() {
        return (float)(this.hit + this.correctNegative) / (float)this.getTotal();
    }

    public float getBias() {
        return (float)(this.hit + this.falseAlarm) / (float)(this.hit + this.miss);
    }

    public float getPOD() {
        return (float)this.hit / (float)(this.hit + this.miss);
    }

    public float getFAR() {
        return (float)this.falseAlarm / (float)(this.hit + this.falseAlarm);
    }

    public float getPOFD() {
        return (float)this.falseAlarm / (float)(this.correctNegative + this.falseAlarm);
    }

    public float getSuccessRatio() {
        return (float)this.hit / (float)(this.hit + this.falseAlarm);
    }

    public float getThreatScore() {
        return (float)this.hit / (float)(this.hit + this.miss + this.falseAlarm);
    }

    public float getETS() {
        float hitRandom = (float)((this.hit + this.miss) * (this.hit + this.falseAlarm)) / (float)this.getTotal();
        return ((float)this.hit - hitRandom) / ((float)(this.hit + this.miss + this.falseAlarm) - hitRandom);
    }

    public float getHK() {
        return (float)this.hit / (float)(this.hit + this.miss) - (float)this.falseAlarm / (float)(this.falseAlarm + this.correctNegative);
    }

    public float getHSS() {
        float ecRandom = (float)((this.hit + this.miss) * (this.hit + this.falseAlarm) + (this.correctNegative + this.miss) * (this.correctNegative + this.falseAlarm)) / (float)this.getTotal();
        return ((float)(this.hit + this.correctNegative) - ecRandom) / ((float)this.getTotal() - ecRandom);
    }

    public float getOddsRatio() {
        return (float)(this.hit * this.correctNegative) / (float)(this.miss * this.falseAlarm);
    }

    public float getORSS() {
        return (float)(this.hit * this.correctNegative - this.miss * this.falseAlarm) / (float)(this.hit * this.correctNegative + this.miss * this.falseAlarm);
    }

    @Override
    public Map getVerifyResult() {
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("Accuracy", Float.valueOf(this.getAccuracy()));
        map.put("Bias", Float.valueOf(this.getBias()));
        map.put("ETS", Float.valueOf(this.getETS()));
        map.put("FAR", Float.valueOf(this.getFAR()));
        map.put("HK", Float.valueOf(this.getHK()));
        map.put("HSS", Float.valueOf(this.getHSS()));
        map.put("ORSS", Float.valueOf(this.getORSS()));
        map.put("OR", Float.valueOf(this.getOddsRatio()));
        map.put("POD", Float.valueOf(this.getPOD()));
        map.put("POFD", Float.valueOf(this.getPOFD()));
        map.put("SR", Float.valueOf(this.getSuccessRatio()));
        map.put("TS", Float.valueOf(this.getThreatScore()));
        return map;
    }

    @Override
    public String getScoreNames() {
        return "Accuracy,Bias,ETS,FAR,HK,HSS,ORSS,OR,POD,POFD,SR,TS";
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.DICHOTOMOUS;
    }

    public String getVerifyValues() {
        String vstr = String.valueOf(this.getAccuracy());
        vstr = vstr + ',' + String.valueOf(this.getBias());
        vstr = vstr + ',' + String.valueOf(this.getETS());
        vstr = vstr + ',' + String.valueOf(this.getFAR());
        vstr = vstr + ',' + String.valueOf(this.getHK());
        vstr = vstr + ',' + String.valueOf(this.getHSS());
        vstr = vstr + ',' + String.valueOf(this.getORSS());
        vstr = vstr + ',' + String.valueOf(this.getOddsRatio());
        vstr = vstr + ',' + String.valueOf(this.getPOD());
        vstr = vstr + ',' + String.valueOf(this.getPOFD());
        vstr = vstr + ',' + String.valueOf(this.getSuccessRatio());
        vstr = vstr + ',' + String.valueOf(this.getThreatScore());
        return vstr;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String line = "Hit: " + String.valueOf(this.hit) + "\n";
        sb.append(line);
        line = "Miss: " + String.valueOf(this.miss) + "\n";
        sb.append(line);
        line = "False alarm: " + String.valueOf(this.falseAlarm) + "\n";
        sb.append(line);
        line = "Correct negative: " + String.valueOf(this.correctNegative) + "\n";
        sb.append(line);
        sb.append("---------------------------\n");
        sb.append("Score\tValue\n");
        Map map = this.getVerifyResult();
        Set key = map.keySet();
        for (String s : key) {
            line = s + "\t" + String.format("%.2f", map.get(s)) + "\n";
            sb.append(line);
        }
        return sb.toString();
    }

    public void save(String fileName) {
        BufferedWriter sw = null;
        try {
            sw = new BufferedWriter(new FileWriter(new File(fileName)));
            String aStr = "Statistics,Score";
            sw.write(aStr);
            Map map = this.getVerifyResult();
            Set key = map.keySet();
            for (String s : key) {
                aStr = s + "," + map.get(s).toString();
                sw.newLine();
                sw.write(aStr);
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(StationData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

