/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class PointZShape
extends PointShape {
    public PointZShape() {
        this(new PointZ());
    }

    public PointZShape(PointD point) {
        this.setPoint(point);
    }

    public PointZShape(Geometry geometry) {
        CoordinateXYZM c = (CoordinateXYZM)geometry.getCoordinate();
        this.setPoint(new PointZ(c.x, c.y, c.getZ(), c.getM()));
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.POINT_Z;
    }

    @Override
    public void setPoint(PointD point) {
        PointZ p;
        if (this.points == null) {
            p = new PointZ();
            this.points = new ArrayList();
            this.points.add(p);
        } else {
            p = (PointZ)this.getPoint();
        }
        p.X = point.X;
        p.Y = point.Y;
        if (point instanceof PointZ) {
            p.Z = ((PointZ)point).Z;
        }
        this.updateExtent();
    }

    public double getM() {
        return ((PointZ)this.getPoint()).M;
    }

    public double getZ() {
        return ((PointZ)this.getPoint()).Z;
    }

    @Override
    public Object clone() {
        PointZShape aPS = new PointZShape();
        aPS.setPoint((PointZ)this.getPoint().clone());
        aPS.setValue(this.getValue());
        aPS.setVisible(this.isVisible());
        aPS.setSelected(this.isSelected());
        aPS.setLegendIndex(this.getLegendIndex());
        return aPS;
    }
}

