/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.colors;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.math.ArrayMath;

public class Normalize {
    protected Double minValue;
    protected Double maxValue;
    protected boolean clip;

    public Normalize() {
        this.minValue = null;
        this.maxValue = null;
        this.clip = false;
    }

    public Normalize(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.clip = false;
    }

    public Normalize(double minValue, double maxValue, boolean clip) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.clip = clip;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double value) {
        this.minValue = value;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double value) {
        this.maxValue = value;
    }

    public boolean isClip() {
        return this.clip;
    }

    public void setClip(boolean value) {
        this.clip = value;
    }

    public void autoScale(Array a) {
        this.minValue = ArrayMath.min((Array)a).doubleValue();
        this.maxValue = ArrayMath.max((Array)a).doubleValue();
    }

    public void autoScaleNull(Array a) {
        if (this.minValue == null) {
            this.minValue = ArrayMath.min((Array)a).doubleValue();
        }
        if (this.maxValue == null) {
            this.maxValue = ArrayMath.max((Array)a).doubleValue();
        }
    }

    public boolean isScaled() {
        return this.minValue != null && this.maxValue != null;
    }

    public Number apply(Number value) {
        double range = this.maxValue - this.minValue;
        double v = value.doubleValue();
        v = (v - this.minValue) / range;
        if (this.clip) {
            if (v < 0.0) {
                v = 0.0;
            } else if (v > 1.0) {
                v = 1.0;
            }
        }
        return v;
    }

    public Array apply(Array a) {
        this.autoScaleNull(a);
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        double range = this.maxValue - this.minValue;
        if (this.clip) {
            while (iterA.hasNext()) {
                double v = iterA.getDoubleNext();
                if ((v = (v - this.minValue) / range) < 0.0) {
                    v = 0.0;
                } else if (v > 1.0) {
                    v = 1.0;
                }
                iterR.setDoubleNext(v);
            }
        } else {
            while (iterA.hasNext()) {
                double v = iterA.getDoubleNext();
                v = (v - this.minValue) / range;
                iterR.setDoubleNext(v);
            }
        }
        return r;
    }

    public double inverse(double v) {
        return this.minValue + v * (this.maxValue - this.minValue);
    }

    public Array inverse(Array a) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        double range = this.maxValue - this.minValue;
        while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            v = this.minValue + v * range;
            iterR.setDoubleNext(v);
        }
        return r;
    }
}

