/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar.gradient;

import org.apache.commons.math4.legacy.exception.MathInternalError;
import org.apache.commons.math4.legacy.exception.MathUnsupportedOperationException;
import org.apache.commons.math4.legacy.exception.TooManyEvaluationsException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.optim.ConvergenceChecker;
import org.apache.commons.math4.legacy.optim.OptimizationData;
import org.apache.commons.math4.legacy.optim.PointValuePair;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.GradientMultivariateOptimizer;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.LineSearch;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.gradient.Preconditioner;

public class NonLinearConjugateGradientOptimizer
extends GradientMultivariateOptimizer {
    private final Formula updateFormula;
    private final Preconditioner preconditioner;
    private final LineSearch line;

    public NonLinearConjugateGradientOptimizer(Formula updateFormula, ConvergenceChecker<PointValuePair> checker) {
        this(updateFormula, checker, 1.0E-8, 1.0E-8, 1.0E-8, new IdentityPreconditioner());
    }

    public NonLinearConjugateGradientOptimizer(Formula updateFormula, ConvergenceChecker<PointValuePair> checker, double relativeTolerance, double absoluteTolerance, double initialBracketingRange) {
        this(updateFormula, checker, relativeTolerance, absoluteTolerance, initialBracketingRange, new IdentityPreconditioner());
    }

    public NonLinearConjugateGradientOptimizer(Formula updateFormula, ConvergenceChecker<PointValuePair> checker, double relativeTolerance, double absoluteTolerance, double initialBracketingRange, Preconditioner preconditioner) {
        super(checker);
        this.updateFormula = updateFormula;
        this.preconditioner = preconditioner;
        this.line = new LineSearch(this, relativeTolerance, absoluteTolerance, initialBracketingRange);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        return super.optimize(optData);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected PointValuePair doOptimize() {
        checker = this.getConvergenceChecker();
        point = this.getStartPoint();
        goal = this.getGoalType();
        n = point.length;
        r = this.computeObjectiveGradient(point);
        if (goal == GoalType.MINIMIZE) {
            for (i = 0; i < n; ++i) {
                r[i] = -r[i];
            }
        }
        steepestDescent = this.preconditioner.precondition(point, r);
        searchDirection = (double[])steepestDescent.clone();
        delta = 0.0;
        for (i = 0; i < n; ++i) {
            delta += r[i] * searchDirection[i];
        }
        current = null;
        block6: while (true) {
            this.incrementIterationCount();
            objective = this.computeObjectiveValue(point);
            previous = current;
            current = new PointValuePair(point, objective);
            if (previous != null && checker.converged(this.getIterations(), previous, current)) {
                return current;
            }
            step = this.line.search(point, searchDirection).getPoint();
            for (i = 0; i < point.length; ++i) {
                v0 = i;
                point[v0] = point[v0] + step * searchDirection[i];
            }
            r = this.computeObjectiveGradient(point);
            if (goal == GoalType.MINIMIZE) {
                for (i = 0; i < n; ++i) {
                    r[i] = -r[i];
                }
            }
            deltaOld = delta;
            newSteepestDescent = this.preconditioner.precondition(point, r);
            delta = 0.0;
            for (i = 0; i < n; ++i) {
                delta += r[i] * newSteepestDescent[i];
            }
            switch (1.$SwitchMap$org$apache$commons$math4$legacy$optim$nonlinear$scalar$gradient$NonLinearConjugateGradientOptimizer$Formula[this.updateFormula.ordinal()]) {
                case 1: {
                    beta = delta / deltaOld;
                    break;
                }
                case 2: {
                    deltaMid = 0.0;
                    for (i = 0; i < r.length; ++i) {
                        deltaMid += r[i] * steepestDescent[i];
                    }
                    beta = (delta - deltaMid) / deltaOld;
                    break;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            steepestDescent = newSteepestDescent;
            if (this.getIterations() % n == 0 || beta < 0.0) {
                searchDirection = (double[])steepestDescent.clone();
                continue;
            }
            i = 0;
            while (true) {
                if (i < n) ** break;
                continue block6;
                searchDirection[i] = steepestDescent[i] + beta * searchDirection[i];
                ++i;
            }
            break;
        }
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        this.checkParameters();
    }

    private void checkParameters() {
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException((Localizable)LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }

    public static class IdentityPreconditioner
    implements Preconditioner {
        @Override
        public double[] precondition(double[] variables, double[] r) {
            return (double[])r.clone();
        }
    }

    public static enum Formula {
        FLETCHER_REEVES,
        POLAK_RIBIERE;

    }
}

