/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.table.ColumnData;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataColumnCollection;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataRowCollection;
import org.meteoinfo.table.Field;
import org.meteoinfo.table.SQLExpression;
import org.meteoinfo.table.util.TableUtil;

public class DataTable {
    protected DataRowCollection rows;
    protected DataColumnCollection columns = new DataColumnCollection();
    protected String tableName;
    protected boolean readOnly = false;
    protected int nextRowIndex = 0;
    protected Object tag;

    public DataTable() {
        this.rows = new DataRowCollection();
        this.rows.setColumns(this.columns);
    }

    public DataTable(String dataTableName) {
        this();
        this.tableName = dataTableName;
    }

    public int getTotalCount() {
        return this.rows.size();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DataRowCollection getRows() {
        return this.rows;
    }

    public DataRowCollection getRows(List<Integer> idx) {
        DataRowCollection r = new DataRowCollection();
        for (int i : idx) {
            r.add((DataRow)this.rows.get(i));
        }
        return r;
    }

    public DataRowCollection getRows(Range range) {
        DataRowCollection r = new DataRowCollection();
        for (int i = range.first(); i < range.last(); ++i) {
            r.add((DataRow)this.rows.get(i));
        }
        return r;
    }

    public DataColumnCollection getColumns() {
        return this.columns;
    }

    public List<String> getColumnNames() {
        return this.columns.getColumnNames();
    }

    public Object getValue(int row, String colName) {
        return ((DataRow)this.rows.get(row)).getValue(colName);
    }

    public Object getValue(int row, int col) {
        return ((DataRow)this.rows.get(row)).getValue(col);
    }

    public DataRow newRow() throws Exception {
        DataRow tempRow = new DataRow(this);
        this.nextRowIndex = this.nextRowIndex < this.rows.size() ? this.rows.size() : this.nextRowIndex;
        tempRow.setColumns(this.columns);
        tempRow.setRowIndex(this.nextRowIndex++);
        block5: for (DataColumn col : this.columns) {
            switch (col.getDataType()) {
                case STRING: {
                    tempRow.setValue(col.getColumnName(), (Object)"");
                    continue block5;
                }
                case DATE: {
                    tempRow.setValue(col.getColumnName(), (Object)LocalDateTime.now());
                    continue block5;
                }
                case BOOLEAN: {
                    tempRow.setValue(col.getColumnName(), (Object)Boolean.TRUE);
                    continue block5;
                }
            }
            tempRow.setValue(col.getColumnName(), (Object)0);
        }
        return tempRow;
    }

    public void setValue(int row, int col, Object value) {
        ((DataRow)this.rows.get(row)).setValue(col, value);
    }

    public void setValue(int row, String colName, Object value) {
        ((DataRow)this.rows.get(row)).setValue(colName, value);
    }

    public void setValues(String colName, List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            ((DataRow)this.rows.get(i)).setValue(colName, values.get(i));
        }
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public Object getTag() {
        return this.tag;
    }

    public DataColumn findColumn(String colName) {
        if (colName == null) {
            return null;
        }
        for (DataColumn col : this.columns) {
            if (!col.getColumnName().equals(colName)) continue;
            return col;
        }
        return null;
    }

    public List<DataColumn> findColumns(List<String> colNames) {
        ArrayList<DataColumn> cols = new ArrayList<DataColumn>();
        block0: for (DataColumn col : this.getColumns()) {
            for (String colName : colNames) {
                if (!col.getColumnName().equals(colName)) continue;
                cols.add(col);
                continue block0;
            }
        }
        return cols;
    }

    public List<DataColumn> findColumns_Index(List<Integer> colIndex) {
        ArrayList<DataColumn> cols = new ArrayList<DataColumn>();
        int n = this.getColumnCount();
        for (int i : colIndex) {
            if (i < 0) {
                i = n + i;
            }
            if (i >= n) continue;
            cols.add((DataColumn)this.columns.get(i));
        }
        return cols;
    }

    public boolean hasTimeColumn() {
        for (DataColumn col : this.columns) {
            if (col.getDataType() != DataType.DATE) continue;
            return true;
        }
        return false;
    }

    public DataColumn addColumn(String columnName, DataType dataType) throws Exception {
        DataColumn col = new DataColumn(columnName, dataType);
        this.addColumn(col);
        return col;
    }

    public DataColumn addColumn(int index, String columnName, DataType dataType) throws Exception {
        DataColumn col = new DataColumn(columnName, dataType);
        this.addColumn(index, col);
        return col;
    }

    public void addColumn(int index, DataColumn column) {
        this.columns.add(index, column);
        for (DataRow row : this.rows) {
            row.setColumns(this.columns);
            row.addColumn(column);
        }
    }

    public void addColumn(DataColumn column) {
        this.columns.add(column);
        for (DataRow row : this.rows) {
            row.setColumns(this.columns);
            row.addColumn(column);
        }
    }

    public void removeColumn(DataColumn column) {
        this.columns.remove(column);
        for (DataRow row : this.rows) {
            row.setColumns(this.columns);
            row.removeColumn(column);
        }
    }

    public void renameColumn(DataColumn column, String fieldName) {
        String oldName = column.getColumnName();
        this.columns.renameColumn(column, fieldName);
        for (DataRow row : this.rows) {
            row.setColumns(this.columns);
            row.renameColumn(oldName, fieldName);
        }
    }

    public void renameColumn(String oldName, String newName) {
        DataColumn column = this.findColumn(oldName);
        this.columns.renameColumn(column, newName);
        for (DataRow row : this.rows) {
            row.setColumns(this.columns);
            row.renameColumn(oldName, newName);
        }
    }

    public void renameColumn(int colIdx, String fieldName) {
        DataColumn column = (DataColumn)this.columns.get(colIdx);
        this.renameColumn(column, fieldName);
    }

    public boolean addRow(DataRow row) throws Exception {
        this.nextRowIndex = this.nextRowIndex < this.rows.size() ? this.rows.size() : this.nextRowIndex;
        row.setColumns(this.columns);
        row.setRowIndex(this.nextRowIndex++);
        row.setTable(this);
        return this.rows.add(row);
    }

    public DataRow addRow() throws Exception {
        DataRow row = new DataRow();
        this.addRow(row);
        return row;
    }

    public void addRows(List<DataRow> rows) throws Exception {
        for (DataRow row : rows) {
            this.addRow(row);
        }
    }

    public boolean appendRow(DataRow row) {
        List<String> colNames = row.getColumns().getColumnNames();
        this.nextRowIndex = this.nextRowIndex < this.rows.size() ? this.rows.size() : this.nextRowIndex;
        row.setColumns(this.columns);
        row.setRowIndex(this.nextRowIndex++);
        row.setTable(this);
        for (DataColumn col : this.columns) {
            if (colNames.contains(col.getColumnName())) continue;
            row.setValue(col, null);
        }
        return this.rows.add(row);
    }

    public void removeRow(int rowIdx) {
        this.rows.remove(rowIdx);
    }

    public void removeRow(DataRow row) {
        this.rows.remove(row);
    }

    public void removeRows(List<DataRow> rows) {
        this.rows.removeAll(rows);
    }

    public void setRows(List<DataRow> rows) {
        this.rows.clear();
        for (DataRow row : rows) {
            this.rows.add(row);
        }
    }

    public void setColumnData(DataColumn col, List<Object> colData) throws Exception {
        if (this.getRowCount() == 0) {
            for (int i = 0; i < colData.size(); ++i) {
                DataRow row = this.addRow();
                row.setValue(col, colData.get(i));
            }
        } else {
            int i = 0;
            for (DataRow row : this.rows) {
                if (i < colData.size()) {
                    row.setValue(col, colData.get(i));
                }
                ++i;
            }
        }
    }

    public void setColumnData(String colName, List<Object> colData) throws Exception {
        DataColumn col = this.findColumn(colName);
        if (col == null) {
            System.out.println("The column not exists: " + colName + "!");
            return;
        }
        this.setColumnData(col, colData);
    }

    public void setColumnData(DataColumn col, Array colData) throws Exception {
        colData = colData.copyIfView();
        if (this.getRowCount() == 0) {
            int i = 0;
            while ((long)i < colData.getSize()) {
                DataRow row = this.addRow();
                row.setValue(col, colData.getObject(i));
                ++i;
            }
        } else {
            int i = 0;
            for (DataRow row : this.rows) {
                if ((long)i < colData.getSize()) {
                    row.setValue(col, colData.getObject(i));
                }
                ++i;
            }
        }
    }

    public void setColumnData(String colName, Array colData) throws Exception {
        DataColumn col = this.findColumn(colName);
        if (col == null) {
            System.out.println("The column not exists: " + colName + "!");
            return;
        }
        this.setColumnData(col, colData);
    }

    public void setColumnData(DataColumn col, Array colData, Array index) throws Exception {
        colData = colData.copyIfView();
        index = index.copyIfView();
        int i = 0;
        while ((long)i < index.getSize()) {
            int idx = index.getInt(i);
            if (idx >= 0 && idx < this.getRowCount()) {
                ((DataRow)this.rows.get(idx)).setValue(col, colData.getObject(i));
            }
            ++i;
        }
    }

    public void setColumnData(String colName, Array colData, Array index) throws Exception {
        DataColumn col = this.findColumn(colName);
        if (col == null) {
            System.out.println("The column not exists: " + colName + "!");
            return;
        }
        this.setColumnData(col, colData, index);
    }

    public void addColumnData(ColumnData colData) throws Exception {
        DataColumn col = this.addColumn(colData.getDataColumn().getColumnName(), colData.getDataType());
        int i = 0;
        for (DataRow row : this.rows) {
            if (i < colData.size()) {
                row.setValue(col, colData.getValue(i));
            }
            ++i;
        }
    }

    public void addColumnData(String colName, DataType dataType, List<Object> colData) throws Exception {
        DataColumn col = this.addColumn(colName, dataType);
        this.setColumnData(col, colData);
    }

    public void addColumnData(int index, String colName, DataType dataType, List<Object> colData) throws Exception {
        DataColumn col = this.addColumn(index, colName, dataType);
        this.setColumnData(col, colData);
    }

    public void addColumnData(String colName, String dt, List<Object> colData) throws Exception {
        DataType dataType = TableUtil.toDataTypes(dt);
        this.addColumnData(colName, dataType, colData);
    }

    public ColumnData getColumnData(String colName) {
        return this.getColumnData(this.getRows(), colName);
    }

    public ColumnData getColumnData(DataColumn col) {
        return this.getColumnData(col.getColumnName());
    }

    public ColumnData getColumnData(List<DataRow> rows, String colName) {
        ColumnData colData = new ColumnData(this.findColumn(colName));
        for (DataRow row : rows) {
            colData.addData(row.getValue(colName));
        }
        return colData;
    }

    public List<DataRow> select(String expression) {
        SQLExpression e = new SQLExpression(expression);
        ArrayList<DataRow> dataRows = new ArrayList<DataRow>();
        for (int i = 0; i < this.rows.size(); ++i) {
            DataRow row = (DataRow)this.rows.get(i);
            row.setRowIndex(i);
            if (!e.eval(row.getItemMap())) continue;
            dataRows.add(row);
        }
        return dataRows;
    }

    public DataTable select(String expression, DataColumn[] dataColumns) {
        DataTable result = new DataTable();
        List<DataRow> dataRows = this.select(expression);
        for (DataColumn dc : dataColumns) {
            DataColumn newDc = (DataColumn)dc.clone();
            result.columns.add(newDc);
        }
        for (DataRow r : dataRows) {
            try {
                DataRow newRow = result.newRow();
                newRow.copyFrom(r);
                result.addRow(newRow);
            }
            catch (Exception ex) {
                Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public DataTable select(Range rowRange) throws Exception {
        return this.select(rowRange.first(), rowRange.last(), rowRange.stride());
    }

    public DataTable select(int r_start, int r_stop, int r_step) throws Exception {
        DataTable r = new DataTable();
        for (DataColumn dc : this.columns) {
            DataColumn newDc = (DataColumn)dc.clone();
            r.columns.add(newDc);
        }
        for (int i = r_start; i < r_stop && i < this.getRowCount(); i += r_step) {
            DataRow newRow = r.newRow();
            newRow.copyFrom((DataRow)this.rows.get(i));
            r.addRow(newRow);
        }
        return r;
    }

    public DataTable select(List<Integer> rowIndex) throws Exception {
        int i;
        DataTable r = new DataTable();
        for (DataColumn dc : this.columns) {
            DataColumn newDc = (DataColumn)dc.clone();
            r.columns.add(newDc);
        }
        Iterator<Object> iterator = rowIndex.iterator();
        while (iterator.hasNext() && (i = ((Integer)iterator.next()).intValue()) < this.getRowCount()) {
            DataRow newRow = r.newRow();
            newRow.copyFrom((DataRow)this.rows.get(i));
            r.addRow(newRow);
        }
        return r;
    }

    public DataTable select(Range rowRange, Range colRange) throws Exception {
        return this.select(rowRange.first(), rowRange.last(), rowRange.stride(), colRange.first(), colRange.last(), colRange.stride());
    }

    public DataTable select(int r_start, int r_stop, int r_step, int c_start, int c_stop, int c_step) throws Exception {
        ArrayList<DataColumn> cols = new ArrayList<DataColumn>();
        for (int i = c_start; i < c_stop && i < this.getColumnCount(); i += c_step) {
            cols.add((DataColumn)this.columns.get(i));
        }
        return this.select(r_start, r_stop, r_step, cols);
    }

    public DataTable select(List<Integer> rowIndex, Range colRange) throws Exception {
        return this.select(rowIndex, colRange.first(), colRange.last(), colRange.stride());
    }

    public DataTable select(List<Integer> rowIndex, int c_start, int c_stop, int c_step) throws Exception {
        ArrayList<DataColumn> cols = new ArrayList<DataColumn>();
        for (int i = c_start; i < c_stop && i < this.getColumnCount(); i += c_step) {
            cols.add((DataColumn)this.columns.get(i));
        }
        return this.select(rowIndex, cols);
    }

    public DataTable select(Range rowRange, List<DataColumn> cols) throws Exception {
        return this.select(rowRange.first(), rowRange.last(), rowRange.stride(), cols);
    }

    public DataTable select(int r_start, int r_stop, int r_step, List<DataColumn> cols) throws Exception {
        DataTable r = new DataTable();
        for (DataColumn dc : cols) {
            DataColumn newDc = (DataColumn)dc.clone();
            r.columns.add(newDc);
        }
        DataColumnCollection dcc = new DataColumnCollection(cols);
        for (int i = r_start; i < r_stop && i < this.getRowCount(); i += r_step) {
            DataRow newRow = ((DataRow)this.rows.get(i)).colSelect(dcc);
            r.addRow(newRow);
        }
        return r;
    }

    public DataTable select(List<Integer> rowIndex, List<DataColumn> cols) throws Exception {
        int i;
        DataTable r = new DataTable();
        for (DataColumn dc : cols) {
            DataColumn newDc = (DataColumn)dc.clone();
            r.columns.add(newDc);
        }
        DataColumnCollection dcc = new DataColumnCollection(cols);
        Iterator<Integer> iterator = rowIndex.iterator();
        while (iterator.hasNext() && (i = iterator.next().intValue()) < this.getRowCount()) {
            DataRow newRow = ((DataRow)this.rows.get(i)).colSelect(dcc);
            r.addRow(newRow);
        }
        return r;
    }

    public DataTable colSelect(List<DataColumn> cols) throws Exception {
        DataTable r = new DataTable();
        for (DataColumn dc : cols) {
            DataColumn newDc = (DataColumn)dc.clone();
            r.columns.add(dc);
        }
        DataColumnCollection dcc = new DataColumnCollection(cols);
        for (DataRow dr : this.rows) {
            DataRow ndr = dr.colSelect(dcc);
            r.addRow(ndr);
        }
        return r;
    }

    public DataTable sqlSelect(String expression) {
        DataTable result = new DataTable();
        List<DataRow> dataRows = this.select(expression);
        for (DataColumn dc : this.columns) {
            DataColumn newDc = (DataColumn)dc.clone();
            result.columns.add(newDc);
        }
        for (DataRow r : dataRows) {
            try {
                DataRow newRow = result.newRow();
                newRow.copyFrom(r);
                result.addRow(newRow);
            }
            catch (Exception ex) {
                Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public Object max(String columns, String filter) {
        return null;
    }

    public Object min(String columns, String filter) {
        return null;
    }

    public Object avg(String columns, String filter) {
        return null;
    }

    public Object max(String columns, String filter, String groupBy) {
        return null;
    }

    public Object min(String columns, String filter, String groupBy) {
        return null;
    }

    public Object avg(String columns, String filter, String groupBy) {
        return null;
    }

    public Object clone() {
        DataTable table = new DataTable();
        table.tableName = this.tableName;
        table.tag = this.tag;
        table.readOnly = this.readOnly;
        for (DataColumn col : this.columns) {
            DataColumn newcol = (DataColumn)col.clone();
            table.addColumn(new Field(newcol));
        }
        for (DataRow row : this.rows) {
            try {
                DataRow newrow = this.newRow();
                newrow.copyFrom(row);
                table.addRow(newrow);
            }
            catch (Exception ex) {
                Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return table;
    }

    public DataTable cloneTable_Field() {
        DataTable table = new DataTable();
        table.tableName = this.tableName;
        table.tag = this.tag;
        table.readOnly = this.readOnly;
        for (DataColumn col : this.columns) {
            Field newcol = new Field(col.getColumnName(), col.getDataType());
            newcol.setCaptionName(col.getCaptionName());
            newcol.setColumnIndex(col.getColumnIndex());
            newcol.setReadOnly(col.isReadOnly());
            table.addColumn(newcol);
        }
        for (DataRow row : this.rows) {
            try {
                DataRow newrow = this.newRow();
                newrow.copyFrom(row);
                table.addRow(newrow);
            }
            catch (Exception ex) {
                Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return table;
    }

    public String head(int n) {
        StringBuilder sb = new StringBuilder();
        for (DataColumn col : this.columns) {
            if (sb.length() == 0) {
                sb.append(col.getColumnName());
                continue;
            }
            sb.append("\t");
            sb.append(col.getColumnName());
        }
        sb.append("\n");
        int rn = this.getRowCount();
        if (n > rn) {
            n = rn;
        }
        for (int r = 0; r < n; ++r) {
            DataRow row = (DataRow)this.rows.get(r);
            int i = 0;
            for (DataColumn col : this.columns) {
                if (i > 0) {
                    sb.append("\t");
                }
                switch (col.getDataType()) {
                    case DATE: {
                        DateTimeFormatter format = DateTimeFormatter.ofPattern(col.getFormat());
                        sb.append(format.format((LocalDateTime)row.getValue(col.getColumnName())));
                        break;
                    }
                    case STRING: {
                        sb.append("'").append(row.getValue(col.getColumnName()).toString()).append("'");
                        break;
                    }
                    default: {
                        Object v = row.getValue(col.getColumnName());
                        if (v == null) {
                            sb.append("null");
                            break;
                        }
                        sb.append(v.toString());
                    }
                }
                ++i;
            }
            sb.append("\n");
        }
        if (n < rn) {
            sb.append("...");
        }
        return sb.toString();
    }

    public String tail(int n) {
        StringBuilder sb = new StringBuilder();
        for (DataColumn col : this.columns) {
            if (sb.length() == 0) {
                sb.append(col.getColumnName());
                continue;
            }
            sb.append("\t");
            sb.append(col.getColumnName());
        }
        sb.append("\n");
        int rn = this.getRowCount();
        if (n > rn) {
            n = rn;
        }
        for (int r = rn - n; r < rn; ++r) {
            DataRow row = (DataRow)this.rows.get(r);
            int i = 0;
            for (DataColumn col : this.columns) {
                if (i > 0) {
                    sb.append("\t");
                }
                switch (col.getDataType()) {
                    case DATE: {
                        DateTimeFormatter format = DateTimeFormatter.ofPattern(col.getFormat());
                        sb.append(format.format((LocalDateTime)row.getValue(col.getColumnName())));
                        break;
                    }
                    case STRING: {
                        sb.append("'").append(row.getValue(col.getColumnName()).toString()).append("'");
                        break;
                    }
                    default: {
                        Object v = row.getValue(col.getColumnName());
                        if (v == null) {
                            sb.append("null");
                            break;
                        }
                        sb.append(v.toString());
                    }
                }
                ++i;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.head(100);
    }

    public String toString(String dateFormat) {
        String str = "";
        for (DataColumn col : this.columns) {
            str = str + "," + col.getColumnName();
        }
        str = str.substring(1);
        DateTimeFormatter format = DateTimeFormatter.ofPattern(dateFormat);
        for (DataRow row : this.rows) {
            String line = "";
            for (DataColumn col : this.columns) {
                if (col.getDataType() == DataType.DATE) {
                    line = line + "," + format.format((LocalDateTime)row.getValue(col.getColumnName()));
                    continue;
                }
                line = line + "," + row.getValue(col.getColumnName()).toString();
            }
            line = line.substring(1);
            str = str + System.getProperty("line.separator") + line;
        }
        return str;
    }

    public String toString(int decimalNum) {
        return this.toString("yyyyMMddHH", decimalNum);
    }

    public String toString(String dateFormat, int decimalNum) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern(dateFormat);
        String dFormat = "%1$." + String.valueOf(decimalNum) + "f";
        String str = "";
        for (DataColumn col : this.columns) {
            str = str + "," + col.getColumnName();
        }
        str = str.substring(1);
        for (DataRow row : this.rows) {
            String line = "";
            block6: for (DataColumn col : this.columns) {
                String vstr = row.getValue(col.getColumnName()).toString();
                switch (col.getDataType()) {
                    case FLOAT: 
                    case DOUBLE: {
                        if (MIMath.isNumeric((String)vstr)) {
                            line = line + "," + String.format(dFormat, Double.parseDouble(vstr));
                            continue block6;
                        }
                        line = line + ",";
                        continue block6;
                    }
                    case DATE: {
                        line = line + "," + format.format((LocalDateTime)row.getValue(col.getColumnName()));
                        continue block6;
                    }
                }
                line = line + "," + vstr;
            }
            line = line.substring(1);
            str = str + System.getProperty("line.separator") + line;
        }
        return str;
    }

    public void saveAsCSVFile(String fileName) throws IOException {
        this.saveAsCSVFile(fileName, null);
    }

    public void saveAsCSVFile(String fileName, String format) throws IOException {
        List<String> formats = TableUtil.getFormats(format);
        int n = this.getColumnCount();
        if (formats != null && formats.size() < n) {
            while (formats.size() < n) {
                formats.add(null);
            }
        }
        if (!fileName.endsWith(".csv")) {
            fileName = fileName + ".csv";
        }
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fileName)));
        String str = "";
        for (DataColumn col : this.columns) {
            str = str + "," + col.getColumnName();
        }
        str = str.substring(1);
        sw.write(str);
        for (DataRow row : this.rows) {
            String line = "";
            for (int i = 0; i < n; ++i) {
                String vstr;
                DataColumn col = (DataColumn)this.columns.get(i);
                if (formats == null) {
                    vstr = row.getValueStr(col.getColumnName());
                } else {
                    String formatStr = formats.get(i);
                    vstr = row.getValueStr(col.getColumnName(), formatStr);
                }
                if (vstr.equalsIgnoreCase("NaN") || vstr.equalsIgnoreCase("null")) {
                    vstr = "";
                }
                line = line + "," + vstr;
            }
            line = line.substring(1);
            sw.newLine();
            sw.write(line);
        }
        sw.flush();
        sw.close();
    }

    public void saveAsASCIIFile(String fileName) throws IOException {
        this.saveAsASCIIFile(fileName, ",", null, null);
    }

    public void saveAsASCIIFile(String fileName, String delimiter, String dateFormat, String floatFormat) throws IOException {
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fileName)));
        int n = this.getColumnCount();
        String str = "";
        for (int i = 0; i < n; ++i) {
            str = i == 0 ? ((DataColumn)this.columns.get(i)).getColumnName() : str + delimiter + ((DataColumn)this.columns.get(i)).getColumnName();
        }
        sw.write(str);
        for (DataRow row : this.rows) {
            String line = "";
            for (int i = 0; i < n; ++i) {
                String vstr;
                DataColumn col = (DataColumn)this.columns.get(i);
                switch (col.getDataType()) {
                    case DATE: {
                        vstr = row.getValueStr(col.getColumnName(), dateFormat);
                        break;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        vstr = row.getValueStr(col.getColumnName(), floatFormat);
                        break;
                    }
                    default: {
                        vstr = row.getValueStr(col.getColumnName());
                    }
                }
                line = line + delimiter + vstr;
            }
            line = line.substring(1);
            sw.newLine();
            sw.write(line);
        }
        sw.flush();
        sw.close();
    }

    public void saveAsASCIIFile_format(String fileName, String format) throws IOException {
        List<String> formats = TableUtil.getFormats(format);
        int n = this.getColumnCount();
        if (formats != null && formats.size() < n) {
            while (formats.size() < n) {
                formats.add(null);
            }
        }
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fileName)));
        String str = "";
        for (DataColumn col : this.columns) {
            str = str + " " + col.getColumnName();
        }
        str = str.substring(1);
        sw.write(str);
        for (DataRow row : this.rows) {
            String line = "";
            for (int i = 0; i < n; ++i) {
                String vstr;
                DataColumn col = (DataColumn)this.columns.get(i);
                if (formats == null) {
                    vstr = row.getValueStr(col.getColumnName());
                } else {
                    String formatStr = formats.get(i);
                    vstr = row.getValueStr(col.getColumnName(), formatStr);
                }
                line = line + " " + vstr;
            }
            line = line.substring(1);
            sw.newLine();
            sw.write(line);
        }
        sw.flush();
        sw.close();
    }

    public void join(DataTable dataTable, String colName) {
        this.join(dataTable, colName, colName, false);
    }

    public void join(DataTable dataTable, String colName, boolean isUpdate) {
        this.join(dataTable, colName, colName, isUpdate);
    }

    public void join(DataTable dataTable, String colName_this, String colName_in, boolean isUpdate) {
        DataColumn col_this = this.findColumn(colName_this);
        if (col_this == null) {
            System.out.println("There is no column of " + colName_this + " in this table");
            return;
        }
        DataColumn col_in = dataTable.findColumn(colName_in);
        if (col_in == null) {
            System.out.println("There is no column of " + colName_in + " in this table");
            return;
        }
        List<String> values_this = this.getColumnData(colName_this).getDataStrings();
        List<String> values_in = dataTable.getColumnData(colName_in).getDataStrings();
        List<String> colNames = this.getColumnNames();
        ArrayList<String> newColNames = new ArrayList<String>();
        for (DataColumn col : dataTable.columns) {
            if (col.getColumnName().equals(colName_in) || colNames.contains(col.getColumnName())) continue;
            Field newCol = new Field(col.getColumnName(), col.getDataType());
            newCol.setJoined(true);
            this.addColumn(newCol);
            newColNames.add(col.getColumnName());
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            String value = values_this.get(i);
            int idx = values_in.indexOf(value);
            if (idx < 0) continue;
            if (isUpdate) {
                for (String cn : dataTable.getColumnNames()) {
                    if (cn.equals(colName_in)) continue;
                    this.setValue(i, cn, dataTable.getValue(idx, cn));
                }
                continue;
            }
            for (String cn : newColNames) {
                this.setValue(i, cn, dataTable.getValue(idx, cn));
            }
        }
    }

    public void removeJoin() {
        for (DataColumn col : this.columns) {
            if (!col.isJoined()) continue;
            this.removeColumn(col);
        }
    }
}

