/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.formats.bmp.BmpImageParser;
import org.apache.commons.imaging.formats.bmp.BmpImagingParameters;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.meteoinfo.image.AnimatedGifEncoder;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index1D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.w3c.dom.Element;

public class ImageUtil {
    private static final double INCH_2_CM = 2.54;

    public static Array imageRead(String fileName) throws IOException {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        BufferedImage image = extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") ? ImageIO.read(new File(fileName)) : Imaging.getBufferedImage((File)new File(fileName));
        return ImageUtil.imageRead(image);
    }

    public static Array imageRead(BufferedImage image) {
        int xn = image.getWidth();
        int yn = image.getHeight();
        Array r = Array.factory((DataType)DataType.INT, (int[])new int[]{yn, xn, 3});
        Index index = r.getIndex();
        for (int i = 0; i < yn; ++i) {
            for (int j = 0; j < xn; ++j) {
                int rgb = image.getRGB(j, yn - i - 1);
                Color color = new Color(rgb);
                r.setInt(index.set(i, j, 0), color.getRed());
                r.setInt(index.set(i, j, 1), color.getGreen());
                r.setInt(index.set(i, j, 2), color.getBlue());
            }
        }
        return r;
    }

    public static BufferedImage imageLoad(String fileName) throws IOException {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        BufferedImage image = extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") ? ImageIO.read(new File(fileName)) : Imaging.getBufferedImage((File)new File(fileName));
        return image;
    }

    public static BufferedImage createImage(Array data) {
        boolean isAlpha;
        int width = data.getShape()[1];
        int height = data.getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = data.getIndex();
        boolean bl = isAlpha = data.getShape()[2] == 4;
        if (data.getDataType() == DataType.FLOAT || data.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        float r = data.getFloat(index.set(i, j, 0));
                        float g = data.getFloat(index.set(i, j, 1));
                        float b = data.getFloat(index.set(i, j, 2));
                        float a = data.getFloat(index.set(i, j, 3));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        float r = data.getFloat(index.set(i, j, 0));
                        float g = data.getFloat(index.set(i, j, 1));
                        float b = data.getFloat(index.set(i, j, 2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int r = data.getInt(index.set(i, j, 0));
                    int g = data.getInt(index.set(i, j, 1));
                    int b = data.getInt(index.set(i, j, 2));
                    int a = data.getInt(index.set(i, j, 3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int r = data.getInt(index.set(i, j, 0));
                    int g = data.getInt(index.set(i, j, 1));
                    int b = data.getInt(index.set(i, j, 2));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        }
        return aImage;
    }

    public static BufferedImage createImage(Array data, float alpha) {
        int width = data.getShape()[1];
        int height = data.getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = data.getIndex();
        if (data.getDataType() == DataType.FLOAT || data.getDataType() == DataType.DOUBLE) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    float r = data.getFloat(index.set(i, j, 0));
                    float g = data.getFloat(index.set(i, j, 1));
                    float b = data.getFloat(index.set(i, j, 2));
                    Color color = Float.isNaN(r) || Float.isNaN(g) || Float.isNaN(b) ? undefColor : new Color(r, g, b, alpha);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            int a = (int)(alpha * 255.0f);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int r = data.getInt(index.set(i, j, 0));
                    int g = data.getInt(index.set(i, j, 1));
                    int b = data.getInt(index.set(i, j, 2));
                    Color color = new Color(r, g, b, a);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        }
        return aImage;
    }

    public static void imageSave(Array data, String fileName) throws IOException {
        BufferedImage image = ImageUtil.createImage(data);
        ImageUtil.imageSave(image, fileName);
    }

    public static void imageSave(BufferedImage image, String fileName) throws IOException {
        ImageFormats format = ImageUtil.getImageFormat(fileName);
        switch (format) {
            case JPEG: {
                ImageIO.write((RenderedImage)image, "jpg", new File(fileName));
                break;
            }
            default: {
                Imaging.writeImage((BufferedImage)image, (File)new File(fileName), (ImageFormat)format);
            }
        }
    }

    public static void imageSave(BufferedImage image, String fileName, int dpi) throws IOException {
        ImageFormats format = ImageUtil.getImageFormat(fileName);
        switch (format) {
            case JPEG: {
                try {
                    ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
                    ImageOutputStream ios = ImageIO.createImageOutputStream(new File(fileName));
                    imageWriter.setOutput(ios);
                    JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
                    jpegParams.setCompressionMode(2);
                    jpegParams.setCompressionQuality(0.85f);
                    IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(image), jpegParams);
                    Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
                    Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
                    jfif.setAttribute("Xdensity", Integer.toString(dpi));
                    jfif.setAttribute("Ydensity", Integer.toString(dpi));
                    jfif.setAttribute("resUnits", "1");
                    data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
                    imageWriter.write(null, new IIOImage(image, null, data), jpegParams);
                    ios.close();
                    imageWriter.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case BMP: {
                BmpImagingParameters bmpImagingParameters = new BmpImagingParameters();
                bmpImagingParameters.setPixelDensity(PixelDensity.createFromPixelsPerInch((double)dpi, (double)dpi));
                new BmpImageParser().writeImage(image, (OutputStream)new FileOutputStream(fileName), bmpImagingParameters);
                break;
            }
            case PNG: {
                PngImagingParameters pngImagingParameters = new PngImagingParameters();
                pngImagingParameters.setPixelDensity(PixelDensity.createFromPixelsPerInch((double)dpi, (double)dpi));
                new PngImageParser().writeImage(image, (OutputStream)new FileOutputStream(fileName), pngImagingParameters);
                break;
            }
            case TIFF: {
                TiffImagingParameters tiffImagingParameters = new TiffImagingParameters();
                tiffImagingParameters.setPixelDensity(PixelDensity.createFromPixelsPerInch((double)dpi, (double)dpi));
                new TiffImageParser().writeImage(image, (OutputStream)new FileOutputStream(fileName), tiffImagingParameters);
                break;
            }
            default: {
                Imaging.writeImage((BufferedImage)image, (File)new File(fileName), (ImageFormat)format);
            }
        }
    }

    public static ImageFormats getImageFormat(String fileName) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        ImageFormats format = ImageFormats.PNG;
        switch (ext.toLowerCase()) {
            case "gif": {
                format = ImageFormats.GIF;
                break;
            }
            case "jpeg": 
            case "jpg": {
                format = ImageFormats.JPEG;
                break;
            }
            case "bmp": {
                format = ImageFormats.BMP;
                break;
            }
            case "tif": 
            case "tiff": {
                format = ImageFormats.TIFF;
            }
        }
        return format;
    }

    public static Array count(Array data, int size) {
        int ny = data.getShape()[0];
        int nx = data.getShape()[1];
        int skip = size / 2;
        Array r = Array.factory((DataType)DataType.INT, (int[])data.getShape());
        for (int i = 0; i < ny; ++i) {
            int j;
            if (i < skip || i >= ny - skip) {
                for (j = 0; j < nx; ++j) {
                    r.setInt(i * nx + j, 0);
                }
                continue;
            }
            for (j = 0; j < nx; ++j) {
                if (j < skip || j >= nx - skip) {
                    r.setInt(i * nx + j, 0);
                    continue;
                }
                int n = 0;
                for (int ii = i - skip; ii <= i + skip; ++ii) {
                    for (int jj = j - skip; jj <= j + skip; ++jj) {
                        if (!(data.getDouble(ii * nx + jj) > 0.0)) continue;
                        ++n;
                    }
                }
                r.setInt(i * nx + j, n);
            }
        }
        return r;
    }

    public static Array mean(Array data, int size, boolean positive) {
        int ny = data.getShape()[0];
        int nx = data.getShape()[1];
        int skip = size / 2;
        Array r = Array.factory((DataType)data.getDataType(), (int[])data.getShape());
        for (int i = 0; i < ny; ++i) {
            int j;
            if (i < skip || i >= ny - skip) {
                for (j = 0; j < nx; ++j) {
                    r.setObject(i * nx + j, (Object)0);
                }
                continue;
            }
            for (j = 0; j < nx; ++j) {
                int jj;
                int ii;
                if (j < skip || j >= nx - skip) {
                    r.setObject(i * nx + j, (Object)0);
                    continue;
                }
                int n = 0;
                double sum = 0.0;
                if (positive) {
                    for (ii = i - skip; ii <= i + skip; ++ii) {
                        for (jj = j - skip; jj <= j + skip; ++jj) {
                            if (!(data.getDouble(ii * nx + jj) > 0.0)) continue;
                            sum += data.getDouble(ii * nx + jj);
                            ++n;
                        }
                    }
                } else {
                    for (ii = i - skip; ii <= i + skip; ++ii) {
                        for (jj = j - skip; jj <= j + skip; ++jj) {
                            if (Double.isNaN(data.getDouble(ii * nx + jj))) continue;
                            sum += data.getDouble(ii * nx + jj);
                            ++n;
                        }
                    }
                }
                if (n > 0) {
                    r.setObject(i * nx + j, (Object)(sum / (double)n));
                    continue;
                }
                r.setObject(i * nx + j, (Object)0);
            }
        }
        return r;
    }

    public static Array minimumFilter(Array data, int size) throws InvalidRangeException {
        int[] shape = data.getShape();
        int half = size / 2;
        int n = data.getRank();
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        IndexIterator iter = data.getIndexIterator();
        IndexIterator riter = r.getIndexIterator();
        while (iter.hasNext()) {
            iter.next();
            int[] counter = iter.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < n; ++i) {
                int si = counter[i] - half >= 0 ? counter[i] - half : 0;
                int ei = counter[i] + half < shape[i] ? counter[i] + half : shape[i] - 1;
                ranges.add(new Range(si, ei));
            }
            Array temp = data.section(ranges);
            double min = ArrayMath.min((Array)temp).doubleValue();
            riter.setDoubleNext(min);
        }
        return r;
    }

    public static Array maximumFilter(Array data, int size) throws InvalidRangeException {
        int[] shape = data.getShape();
        int half = size / 2;
        int n = data.getRank();
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        IndexIterator iter = data.getIndexIterator();
        IndexIterator riter = r.getIndexIterator();
        while (iter.hasNext()) {
            iter.next();
            int[] counter = iter.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < n; ++i) {
                int si = counter[i] - half >= 0 ? counter[i] - half : 0;
                int ei = counter[i] + half < shape[i] ? counter[i] + half : shape[i] - 1;
                ranges.add(new Range(si, ei));
            }
            Array temp = data.section(ranges);
            double max = ArrayMath.max((Array)temp).doubleValue();
            riter.setDoubleNext(max);
        }
        return r;
    }

    private static Array correlate1D(Array a, double[] weights) {
        int size = weights.length;
        int origin = size / 2;
        int n = (int)a.getSize();
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        Index1D index = (Index1D)a.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            double v = 0.0;
            for (int j = 0; j < size; ++j) {
                int idx = i - origin + j;
                if (idx < 0) {
                    idx = -idx;
                } else if (idx > n - 1) {
                    idx = n - 1 - (idx - (n - 1));
                }
                index.set(idx);
                v += a.getDouble((Index)index) * weights[j];
            }
            r.setDouble(i, v);
            ++i;
        }
        return r;
    }

    public static Array gaussianFilter(Array data, int size, double sigma) throws InvalidRangeException {
        int i;
        double[] weights = new double[size];
        double sum = 0.0;
        int origin = size / 2;
        for (i = 0; i < size; ++i) {
            double g = Math.exp((double)(-(i - origin) * (i - origin)) / (2.0 * sigma * sigma));
            sum += g;
            weights[i] = g;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            weights[n] = weights[n] / sum;
        }
        int ndim = data.getRank();
        int[] shape = data.getShape();
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        Index rindex = r.getIndex();
        int[] rcurrent = new int[ndim];
        for (int axis = 0; axis < ndim; ++axis) {
            int[] nshape = new int[ndim - 1];
            for (int i2 = 0; i2 < ndim; ++i2) {
                if (i2 < axis) {
                    nshape[i2] = shape[i2];
                    continue;
                }
                if (i2 <= axis) continue;
                nshape[i2 - 1] = shape[i2];
            }
            Index index = Index.factory((int[])nshape);
            int i3 = 0;
            while ((long)i3 < index.getSize()) {
                int[] current = index.getCurrentCounter();
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int j = 0; j < ndim; ++j) {
                    if (j == axis) {
                        ranges.add(new Range(0, shape[j] - 1, 1));
                        rcurrent[j] = 0;
                        continue;
                    }
                    int idx = j;
                    if (idx > axis) {
                        --idx;
                    }
                    ranges.add(new Range(current[idx], current[idx], 1));
                    rcurrent[j] = current[idx];
                }
                Array temp = data.section(ranges);
                temp = ImageUtil.correlate1D(temp, weights);
                for (int j = 0; j < shape[axis]; ++j) {
                    rcurrent[axis] = j;
                    rindex.set(rcurrent);
                    r.setDouble(rindex, temp.getDouble(j));
                }
                index.incr();
                ++i3;
            }
        }
        return r;
    }

    public static void createGifAnimator(List<String> inImageFiles, String outGifFile, int delay, int repeat) {
        try {
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.setDelay(delay);
            e.start(outGifFile);
            for (String infn : inImageFiles) {
                e.addFrame(ImageIO.read(new File(infn)));
            }
            e.finish();
        }
        catch (Exception e) {
            System.out.println("Create gif animator failed:");
            e.printStackTrace();
        }
    }

    public static void createGifAnimator(List<String> inImageFiles, String outGifFile, int delay) {
        ImageUtil.createGifAnimator(inImageFiles, outGifFile, delay, 0);
    }

    public static void createGifAnimator(File[] infiles, File outfile, int delay) {
        try {
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.setDelay(delay);
            e.start(outfile.getCanonicalPath());
            for (File inf : infiles) {
                e.addFrame(ImageIO.read(inf));
            }
            e.finish();
        }
        catch (Exception e) {
            System.out.println("Create gif animator failed:");
            e.printStackTrace();
        }
    }

    public static void setDPI(IIOMetadata metadata, float dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (image.getColorModel().equals(gfxConfig.getColorModel())) {
            return image;
        }
        BufferedImage newImage = gfxConfig.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics2D g2d = newImage.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return newImage;
    }
}

