/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LimitedCache<K, V> {
    private final int CLOCK_THRESHOLD = 10000;
    private final int limit;
    private final int upperLimit;
    private int clock = 0;
    private final HashMap<K, Holder<? extends V>> map;

    public LimitedCache(int capacity) {
        this.limit = capacity;
        this.upperLimit = capacity + capacity / 3 + 1;
        this.map = new HashMap(this.upperLimit);
    }

    public synchronized V get(K key) {
        Holder<? extends V> h = this.map.get(key);
        if (h != null) {
            h.used = this.clock++;
            if (this.clock >= 10000) {
                this.scaleClock();
            }
            return (V)h.value;
        }
        return null;
    }

    public synchronized void add(K key, V value) {
        this.map.computeIfAbsent(key, k -> new Holder<Object>(value, this.clock++));
        if (this.map.size() >= this.upperLimit) {
            this.evictLowest();
        }
    }

    private void evictLowest() {
        Holder<V> h;
        int N = Math.max(0, this.map.size() - this.limit);
        int[] worst = new int[N];
        Arrays.fill(worst, Integer.MAX_VALUE);
        int disqualifyingScore = Integer.MIN_VALUE;
        if (N > 0) {
            for (Map.Entry<K, Holder<Object>> e : this.map.entrySet()) {
                int i;
                h = e.getValue();
                int s = h.score();
                if (s >= worst[N - 1]) continue;
                for (i = 0; i < N && s > worst[i]; ++i) {
                }
                while (i < N) {
                    int t = worst[i];
                    worst[i++] = s;
                    s = t;
                }
            }
            disqualifyingScore = worst[N - 1];
        }
        Iterator<Map.Entry<K, Holder<V>>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, Holder<Object>> e;
            e = iter.next();
            h = e.getValue();
            if (h.score() > disqualifyingScore) continue;
            iter.remove();
        }
    }

    private void scaleClock() {
        for (Holder<? extends V> holder : this.map.values()) {
            holder.used >>>= 1;
        }
        this.clock >>>= 1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LimitedCache [clock=").append(this.clock);
        b.append(", size=").append(this.map.size());
        b.append(" (").append(this.limit);
        b.append(", ").append(this.upperLimit);
        b.append(")]\n");
        for (Holder<V> h : this.map.values()) {
            b.append(h.toString()).append("\n");
        }
        return b.toString();
    }

    private static class Holder<T> {
        final T value;
        int used;

        Holder(T value, int time) {
            this.value = value;
            this.used = time;
        }

        int score() {
            return this.used;
        }

        public String toString() {
            return String.format("(%6d %.60s)", this.used, this.value);
        }
    }
}

