/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.event;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.intern.CDockable;

public class CDockableLocationEvent {
    private CDockable dockable;
    private boolean oldShowing;
    private boolean newShowing;
    private boolean locationChanged;
    private CLocation oldLocation;
    private CLocation newLocation;

    public CDockableLocationEvent(CDockable dockable, boolean oldShowing, boolean newShowing, CLocation oldLocation, CLocation newLocation) {
        this.dockable = dockable;
        this.oldShowing = oldShowing;
        this.newShowing = newShowing;
        this.oldLocation = oldLocation;
        this.newLocation = newLocation;
        if (oldLocation == null && newLocation != null) {
            this.locationChanged = true;
        } else if (oldLocation != null && !oldLocation.equals(newLocation)) {
            this.locationChanged = true;
        }
    }

    public CDockable getDockable() {
        return this.dockable;
    }

    public boolean isLocationChanged() {
        return this.locationChanged;
    }

    public CLocation getOldLocation() {
        return this.oldLocation;
    }

    public CLocation getNewLocation() {
        return this.newLocation;
    }

    @Deprecated
    public boolean isVisibleChanged() {
        return this.oldShowing != this.newShowing;
    }

    public boolean isShowingChanged() {
        return this.oldShowing != this.newShowing;
    }

    @Deprecated
    public boolean getOldVisible() {
        return this.oldShowing;
    }

    public boolean getOldShowing() {
        return this.oldShowing;
    }

    @Deprecated
    public boolean getNewVisible() {
        return this.newShowing;
    }

    public boolean getNewShowing() {
        return this.newShowing;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        if (this.isVisibleChanged()) {
            builder.append("SHOWING: ").append(this.oldShowing).append(" -> ").append(this.newShowing);
        }
        if (this.isLocationChanged()) {
            if (this.isVisibleChanged()) {
                builder.append(", ");
            }
            builder.append("LOCATION: ").append(this.oldLocation).append(" -> ").append(this.newLocation);
        }
        builder.append("]");
        return builder.toString();
    }
}

