/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;

public class LambertConformalConic
extends ProjectionInfo {
    public LambertConformalConic(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.cutoff = -80.0f;
        this.updateBoundary();
    }

    public LambertConformalConic(CoordinateReferenceSystem crs, float cutoff) {
        this.crs = crs;
        this.cutoff = cutoff;
        this.updateBoundary();
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Lambert_Conformal_Conic;
    }

    @Override
    public void setCutoff(float value) {
        this.cutoff = value;
        this.updateBoundary();
    }

    @Override
    public void updateBoundary() {
        double lon;
        double epsilon = 1.0E-10;
        double cenLon = this.getCenterLon();
        ArrayList<PointD> points = new ArrayList<PointD>();
        double lat = this.cutoff;
        for (lon = cenLon - 180.0 + epsilon; lon < cenLon + 180.0 - epsilon; lon += 1.0) {
            points.add(new PointD(lon, lat));
        }
        lon = cenLon + 180.0 - epsilon;
        points.add(new PointD(lon, lat));
        lat += 1.0;
        while (lat < 90.0) {
            points.add(new PointD(lon, lat));
            lat += 1.0;
        }
        points.add(new PointD(lon, 90.0));
        lon = cenLon - 180.0 + epsilon;
        while (lat > (double)this.cutoff) {
            points.add(new PointD(lon, lat));
            lat -= 1.0;
        }
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ProjectionUtil.projectPolygonShape(ps, KnownCoordinateSystems.geographic.world.WGS1984, this);
    }
}

