/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiDockActionSource
extends AbstractDockActionSource {
    private List<DockActionSource> sources = new ArrayList<DockActionSource>();
    private List<SeparatorSource> separators = new ArrayList<SeparatorSource>();
    private Listener listener = new Listener();
    private boolean separateSources = false;
    private LocationHint hint;

    public MultiDockActionSource(DockActionSource ... sources) {
        this(LocationHint.UNKNOWN, sources);
    }

    public MultiDockActionSource(LocationHint hint, DockActionSource ... sources) {
        for (DockActionSource source : sources) {
            this.sources.add(source);
        }
        this.setHint(hint);
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private Iterator<DockActionSource> sourceIterator;
            private Iterator<DockAction> actionIterator;
            {
                this.sourceIterator = MultiDockActionSource.this.sources.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.actionIterator == null) {
                    if (this.sourceIterator.hasNext()) {
                        this.actionIterator = this.sourceIterator.next().iterator();
                    } else {
                        return false;
                    }
                }
                while (true) {
                    if (this.actionIterator.hasNext()) {
                        return true;
                    }
                    if (!this.sourceIterator.hasNext()) break;
                    this.actionIterator = this.sourceIterator.next().iterator();
                }
                return false;
            }

            @Override
            public DockAction next() {
                this.hasNext();
                return this.actionIterator.next();
            }

            @Override
            public void remove() {
                this.hasNext();
                this.actionIterator.remove();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener listener) {
        boolean empty = this.listeners.isEmpty();
        super.addDockActionSourceListener(listener);
        if (empty && !this.listeners.isEmpty()) {
            for (DockActionSource source : this.sources) {
                source.addDockActionSourceListener(this.listener);
            }
            this.updateSeparators();
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        boolean empty = this.listeners.isEmpty();
        super.removeDockActionSourceListener(listener);
        if (!empty && this.listeners.isEmpty()) {
            for (DockActionSource source : this.sources) {
                source.removeDockActionSourceListener(this.listener);
            }
        }
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    public void setHint(LocationHint hint) {
        if (hint == null) {
            throw new IllegalArgumentException("Hint must not be null");
        }
        this.hint = hint;
    }

    public void addSeparator() {
        this.add(SeparatorAction.SEPARATOR);
    }

    public boolean isSeparateSources() {
        return this.separateSources;
    }

    public void setSeparateSources(boolean separateSources) {
        if (this.separateSources != separateSources) {
            this.separateSources = separateSources;
            this.updateSeparators();
        }
    }

    public void add(DockActionSource source) {
        SeparatorSource separator = new SeparatorSource(source);
        this.sources.add(source);
        this.sources.add(separator);
        this.separators.add(separator);
        if (!this.listeners.isEmpty()) {
            source.addDockActionSourceListener(this.listener);
            separator.addDockActionSourceListener(this.listener);
        }
        int index = this.getDockActionCountUntil(this.sources.size() - 2, false);
        int length = source.getDockActionCount();
        if (length > 0) {
            this.fireAdded(index, index + length - 1);
        }
        this.updateSeparators();
    }

    public void remove(DockActionSource source) {
        int index = this.sources.indexOf(source);
        if (index < 0) {
            return;
        }
        SeparatorSource separator = (SeparatorSource)this.sources.get(index + 1);
        int actionIndex = this.getDockActionCountUntil(index, false);
        int length = source.getDockActionCount();
        this.sources.remove(index + 1);
        this.sources.remove(index);
        this.separators.remove(separator);
        if (!this.listeners.isEmpty()) {
            source.removeDockActionSourceListener(this.listener);
            separator.removeDockActionSourceListener(this.listener);
        }
        if (length > 0) {
            this.fireRemoved(actionIndex, index + length - 1);
        }
        this.updateSeparators();
    }

    public void removeAll() {
        int length = this.getDockActionCount();
        if (!this.listeners.isEmpty()) {
            for (SeparatorSource separatorSource : this.separators) {
                separatorSource.removeDockActionSourceListener(this.listener);
            }
            for (DockActionSource dockActionSource : this.sources) {
                dockActionSource.removeDockActionSourceListener(this.listener);
            }
        }
        this.separators.clear();
        this.sources.clear();
        if (length > 0) {
            this.fireRemoved(0, length - 1);
        }
    }

    public void add(DockAction ... actions) {
        this.add(new DefaultDockActionSource(actions));
    }

    @Override
    public int getDockActionCount() {
        return this.getDockActionCountUntil(this.sources.size(), true);
    }

    protected int getSource(DockAction action) {
        int n = this.sources.size();
        for (int i = 0; i < n; ++i) {
            DockActionSource source = this.sources.get(i);
            int m = source.getDockActionCount();
            for (int j = 0; j < m; ++j) {
                if (source.getDockAction(j) != action) continue;
                return i;
            }
        }
        return -1;
    }

    protected int getDockActionCountUntil(int index, boolean allowUpdate) {
        if (allowUpdate && this.listeners.isEmpty()) {
            this.updateSeparators();
        }
        int sum = 0;
        for (int i = 0; i < index; ++i) {
            sum += this.sources.get(i).getDockActionCount();
        }
        return sum;
    }

    @Override
    public DockAction getDockAction(int index) {
        if (this.listeners.isEmpty()) {
            this.updateSeparators();
        }
        int sum = 0;
        int n = this.sources.size();
        for (int i = 0; i < n; ++i) {
            int length = this.sources.get(i).getDockActionCount();
            if (sum <= index && index < sum + length) {
                return this.sources.get(i).getDockAction(index - sum);
            }
            sum += length;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private void updateSeparators() {
        int size = this.separators.size();
        int index = 0;
        for (SeparatorSource source : this.separators) {
            source.update(++index == size);
        }
    }

    private class SeparatorSource
    extends DefaultDockActionSource {
        private DockActionSource predecessor;

        public SeparatorSource(DockActionSource predecessor) {
            super(new DockAction[0]);
            this.predecessor = predecessor;
        }

        public void update(boolean last) {
            if (!MultiDockActionSource.this.separateSources || last) {
                this.remove(SeparatorAction.SEPARATOR);
            } else if (this.predecessor.getDockActionCount() > 0 && this.getDockActionCount() == 0) {
                this.add(SeparatorAction.SEPARATOR);
            }
        }
    }

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            int index = MultiDockActionSource.this.getDockActionCountUntil(MultiDockActionSource.this.sources.indexOf(source), false);
            MultiDockActionSource.this.fireAdded(firstIndex + index, lastIndex + index);
            MultiDockActionSource.this.updateSeparators();
        }

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            int index = MultiDockActionSource.this.getDockActionCountUntil(MultiDockActionSource.this.sources.indexOf(source), false);
            MultiDockActionSource.this.fireRemoved(firstIndex + index, lastIndex + index);
            MultiDockActionSource.this.updateSeparators();
        }
    }
}

