/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.operation;

import java.lang.reflect.Array;
import java.util.function.IntSupplier;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.operation.DOT;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.concurrent.ProcessingService;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.operation.MatrixOperation;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure2D;

public class MultiplyBoth
implements MatrixOperation {
    public static IntSupplier PARALLELISM = Parallelism.THREADS;
    public static int THRESHOLD = 8;
    private static final DivideAndConquer.Divider DIVIDER = ProcessingService.INSTANCE.divider();

    public static <N extends Scalar<N>> Generic<N> newGeneric(int rows, int columns) {
        if (rows > THRESHOLD && columns > THRESHOLD) {
            return MultiplyBoth::fillMxN_MT_G;
        }
        if (columns == 1) {
            return MultiplyBoth::fillMx1_G;
        }
        if (rows == 1) {
            return MultiplyBoth::fill1xN_G;
        }
        return MultiplyBoth::fillMxN_G;
    }

    public static Primitive newPrimitive32(int rows, int columns) {
        return MultiplyBoth.newPrimitive64(rows, columns);
    }

    public static Primitive newPrimitive64(int rows, int columns) {
        if (rows > THRESHOLD && columns > THRESHOLD) {
            return MultiplyBoth::fillMxN_MT_P64;
        }
        if (rows == 5 && columns == 5) {
            return MultiplyBoth::fill5x5_P64;
        }
        if (rows == 4 && columns == 4) {
            return MultiplyBoth::fill4x4_P64;
        }
        if (rows == 3 && columns == 3) {
            return MultiplyBoth::fill3x3_P64;
        }
        if (rows == 2 && columns == 2) {
            return MultiplyBoth::fill2x2_P64;
        }
        if (rows == 1 && columns == 1) {
            return MultiplyBoth::fill1x1_P64;
        }
        if (columns == 1) {
            return MultiplyBoth::fillMx1_P64;
        }
        if (rows == 10) {
            return MultiplyBoth::fill0xN_P64;
        }
        if (rows == 9) {
            return MultiplyBoth::fill9xN_P64;
        }
        if (rows == 8) {
            return MultiplyBoth::fill8xN_P64;
        }
        if (rows == 7) {
            return MultiplyBoth::fill7xN_P64;
        }
        if (rows == 6) {
            return MultiplyBoth::fill6xN_P64;
        }
        if (rows == 1) {
            return MultiplyBoth::fill1xN_P64;
        }
        return MultiplyBoth::fillMxN_P64;
    }

    private static void base(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int nbRows = product.getRowDim();
        int nbCols = product.getColDim();
        for (int i = 0; i < nbRows; ++i) {
            for (int c = 0; c < complexity; ++c) {
                for (int j = 0; j < nbCols; ++j) {
                    product.add(Structure2D.index(nbRows, i, j), left.doubleValue(Structure2D.index(nbRows, i, c)) * right.doubleValue(Structure2D.index(complexity, c, j)));
                }
            }
        }
    }

    static void divide(int first, int limit, DivideAndConquer.Conquerer conquerer) {
        DIVIDER.parallelism(PARALLELISM).threshold(THRESHOLD).divide(first, limit, conquerer);
    }

    static void fill0xN_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpColDim = product.getColDim();
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            double tmp9J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp8J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp9J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
            product.set(7L, (long)j, tmp7J);
            product.set(8L, (long)j, tmp8J);
            product.set(9L, (long)j, tmp9J);
        }
    }

    static void fill1x1_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        double tmp00 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            tmp00 += left.doubleValue(c) * right.doubleValue(c);
        }
        product.set(0L, 0L, tmp00);
    }

    static <N extends Scalar<N>> void fill1xN_G(TransformableRegion<N> product, Access1D<N> left, int complexity, Access1D<N> right) {
        Scalar zero;
        Class<?> componenetType = ((Scalar)left.get(0L)).getClass();
        try {
            zero = (Scalar)componenetType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException exception) {
            exception.printStackTrace();
            throw new ProgrammingError(exception);
        }
        int tmpColDim = product.getColDim();
        Scalar[] tmpLeftRow = (Scalar[])Array.newInstance(componenetType, complexity);
        int tmpFirst = 0;
        int tmpLimit = complexity;
        for (int c = 0; c < complexity; ++c) {
            tmpLeftRow[c] = (Scalar)left.get(c);
        }
        for (int j = 0; j < tmpColDim; ++j) {
            long tmpColBase = Structure2D.index(complexity, 0L, j);
            tmpFirst = Structure2D.firstInColumn(right, j, 0);
            tmpLimit = Structure2D.limitOfColumn(right, j, complexity);
            Scalar tmpVal = zero;
            for (int c = tmpFirst; c < tmpLimit; ++c) {
                tmpVal = (Scalar)tmpVal.add(tmpLeftRow[c].multiply((Scalar)right.get((long)c + tmpColBase))).get();
            }
            product.set(0L, (long)j, tmpVal);
        }
    }

    static void fill1xN_P64(TransformableRegion<Double> product, Access1D<?> left, int complexity, Access1D<?> right) {
        int nbCols = product.getColDim();
        int firstInRow = Structure2D.firstInRow(right, 0, 0);
        int limitOfRow = Structure2D.firstInRow(right, 0, complexity);
        for (int j = 0; j < nbCols; ++j) {
            int firstInCol = Structure2D.firstInColumn(right, j, firstInRow);
            int limitOfCol = Structure2D.firstInColumn(right, j, limitOfRow);
            product.set((long)j, DOT.invokeP64(left, 0, right, j * complexity, firstInCol, limitOfCol));
        }
    }

    static void fill2x2_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 2L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
    }

    static void fill3x3_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 3L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(2L, 0L, tmp20);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
        product.set(2L, 1L, tmp21);
        product.set(0L, 2L, tmp02);
        product.set(1L, 2L, tmp12);
        product.set(2L, 2L, tmp22);
    }

    static void fill4x4_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 4L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            double tmpLeft3 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(2L, 0L, tmp20);
        product.set(3L, 0L, tmp30);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
        product.set(2L, 1L, tmp21);
        product.set(3L, 1L, tmp31);
        product.set(0L, 2L, tmp02);
        product.set(1L, 2L, tmp12);
        product.set(2L, 2L, tmp22);
        product.set(3L, 2L, tmp32);
        product.set(0L, 3L, tmp03);
        product.set(1L, 3L, tmp13);
        product.set(2L, 3L, tmp23);
        product.set(3L, 3L, tmp33);
    }

    static void fill5x5_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp40 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp41 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp42 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        double tmp43 = PrimitiveMath.ZERO;
        double tmp04 = PrimitiveMath.ZERO;
        double tmp14 = PrimitiveMath.ZERO;
        double tmp24 = PrimitiveMath.ZERO;
        double tmp34 = PrimitiveMath.ZERO;
        double tmp44 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 5L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            double tmpLeft3 = left.doubleValue(++tmpIndex);
            double tmpLeft4 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight4 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp40 += tmpLeft4 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp41 += tmpLeft4 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp42 += tmpLeft4 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
            tmp43 += tmpLeft4 * tmpRight3;
            tmp04 += tmpLeft0 * tmpRight4;
            tmp14 += tmpLeft1 * tmpRight4;
            tmp24 += tmpLeft2 * tmpRight4;
            tmp34 += tmpLeft3 * tmpRight4;
            tmp44 += tmpLeft4 * tmpRight4;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(2L, 0L, tmp20);
        product.set(3L, 0L, tmp30);
        product.set(4L, 0L, tmp40);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
        product.set(2L, 1L, tmp21);
        product.set(3L, 1L, tmp31);
        product.set(4L, 1L, tmp41);
        product.set(0L, 2L, tmp02);
        product.set(1L, 2L, tmp12);
        product.set(2L, 2L, tmp22);
        product.set(3L, 2L, tmp32);
        product.set(4L, 2L, tmp42);
        product.set(0L, 3L, tmp03);
        product.set(1L, 3L, tmp13);
        product.set(2L, 3L, tmp23);
        product.set(3L, 3L, tmp33);
        product.set(4L, 3L, tmp43);
        product.set(0L, 4L, tmp04);
        product.set(1L, 4L, tmp14);
        product.set(2L, 4L, tmp24);
        product.set(3L, 4L, tmp34);
        product.set(4L, 4L, tmp44);
    }

    static void fill6xN_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpColDim = product.getColDim();
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
        }
    }

    static void fill7xN_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpColDim = product.getColDim();
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
        }
    }

    static void fill8xN_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpColDim = product.getColDim();
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
            product.set(7L, (long)j, tmp7J);
        }
    }

    static void fill9xN_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpColDim = product.getColDim();
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp8J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
            product.set(7L, (long)j, tmp7J);
            product.set(8L, (long)j, tmp8J);
        }
    }

    static <N extends Scalar<N>> void fillMx1_G(TransformableRegion<N> product, Access1D<N> left, int complexity, Access1D<N> right) {
        Scalar zero;
        Class<?> componenetType = ((Scalar)left.get(0L)).getClass();
        try {
            zero = (Scalar)componenetType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException exception) {
            exception.printStackTrace();
            throw new ProgrammingError(exception);
        }
        int tmpRowDim = product.getRowDim();
        Scalar[] tmpLeftRow = (Scalar[])Array.newInstance(componenetType, complexity);
        int tmpFirst = 0;
        int tmpLimit = complexity;
        for (int i = 0; i < tmpRowDim; ++i) {
            int c;
            int tmpFirstInRow = Structure2D.firstInRow(left, i, 0);
            int tmpLimitOfRow = Structure2D.limitOfRow(left, i, complexity);
            for (c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = (Scalar)left.get(Structure2D.index(tmpRowDim, i, c));
            }
            tmpFirst = Structure2D.firstInColumn(right, 0, tmpFirstInRow);
            tmpLimit = Structure2D.limitOfColumn(right, 0, tmpLimitOfRow);
            Scalar tmpVal = zero;
            for (c = tmpFirst; c < tmpLimit; ++c) {
                tmpVal = (Scalar)tmpVal.add(tmpLeftRow[c].multiply((Scalar)right.get(c))).get();
            }
            product.set((long)i, 0L, tmpVal);
        }
    }

    static void fillMx1_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpRowDim = product.getRowDim();
        double[] tmpLeftRow = new double[complexity];
        for (int i = 0; i < tmpRowDim; ++i) {
            int tmpFirstInRow = Structure2D.firstInRow(left, i, 0);
            int tmpLimitOfRow = Structure2D.limitOfRow(left, i, complexity);
            for (int c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = left.doubleValue(Structure2D.index(tmpRowDim, i, c));
            }
            product.set((long)i, 0L, DOT.invoke(tmpLeftRow, 0, right, 0, tmpFirstInRow, tmpLimitOfRow));
        }
    }

    static <N extends Scalar<N>> void fillMxN_G(TransformableRegion<N> product, Access1D<N> left, int complexity, Access1D<N> right) {
        MultiplyBoth.fillRxN_G(product, 0, product.getRowDim(), left, complexity, right);
    }

    static <N extends Scalar<N>> void fillMxN_MT_G(TransformableRegion<N> product, Access1D<N> left, int complexity, Access1D<N> right) {
        MultiplyBoth.divide(0, product.getRowDim(), (f, l) -> MultiplyBoth.fillRxN_G(product, f, l, left, complexity, right));
    }

    static void fillMxN_MT_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        MultiplyBoth.divide(0, product.getRowDim(), (f, l) -> MultiplyBoth.fillRxN_P64(product, f, l, left, complexity, right));
    }

    static void fillMxN_P64(TransformableRegion<Double> product, Access1D<Double> left, int complexity, Access1D<Double> right) {
        MultiplyBoth.fillRxN_P64(product, 0, product.getRowDim(), left, complexity, right);
    }

    static <N extends Scalar<N>> void fillRxN_G(TransformableRegion<N> product, int firstRow, int rowLimit, Access1D<N> left, int complexity, Access1D<N> right) {
        Scalar zero;
        Class<?> componenetType = ((Scalar)left.get(0L)).getClass();
        try {
            zero = (Scalar)componenetType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException exception) {
            exception.printStackTrace();
            throw new ProgrammingError(exception);
        }
        int tmpRowDim = product.getRowDim();
        int tmpColDim = product.getColDim();
        Scalar[] tmpLeftRow = (Scalar[])Array.newInstance(componenetType, complexity);
        int tmpFirst = 0;
        int tmpLimit = complexity;
        for (int i = firstRow; i < rowLimit; ++i) {
            int tmpFirstInRow = Structure2D.firstInRow(left, i, 0);
            int tmpLimitOfRow = Structure2D.limitOfRow(left, i, complexity);
            for (int c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = (Scalar)left.get(Structure2D.index(tmpRowDim, i, c));
            }
            for (int j = 0; j < tmpColDim; ++j) {
                long tmpColBase = Structure2D.index(complexity, 0L, j);
                tmpFirst = Structure2D.firstInColumn(right, j, tmpFirstInRow);
                tmpLimit = Structure2D.limitOfColumn(right, j, tmpLimitOfRow);
                Scalar tmpVal = zero;
                for (int c = tmpFirst; c < tmpLimit; ++c) {
                    tmpVal = (Scalar)tmpVal.add(tmpLeftRow[c].multiply((Scalar)right.get((long)c + tmpColBase))).get();
                }
                product.set((long)i, (long)j, tmpVal);
            }
        }
    }

    static void fillRxN_P32(TransformableRegion<Double> product, int firstRow, int rowLimit, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpRowDim = product.getRowDim();
        int tmpColDim = product.getColDim();
        float[] tmpLeftRow = new float[complexity];
        int tmpFirst = 0;
        int tmpLimit = complexity;
        for (int i = firstRow; i < rowLimit; ++i) {
            int tmpFirstInRow = Structure2D.firstInRow(left, i, 0);
            int tmpLimitOfRow = Structure2D.limitOfRow(left, i, complexity);
            for (int c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = left.floatValue(Structure2D.index(tmpRowDim, i, c));
            }
            for (int j = 0; j < tmpColDim; ++j) {
                long tmpColBase = Structure2D.index(complexity, 0L, j);
                tmpFirst = Structure2D.firstInColumn(right, j, tmpFirstInRow);
                tmpLimit = Structure2D.limitOfColumn(right, j, tmpLimitOfRow);
                float tmpVal = 0.0f;
                for (int c = tmpFirst; c < tmpLimit; ++c) {
                    tmpVal += tmpLeftRow[c] * right.floatValue((long)c + tmpColBase);
                }
                product.set((long)i, (long)j, tmpVal);
            }
        }
    }

    static void fillRxN_P64(TransformableRegion<Double> product, int firstRow, int rowLimit, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpRowDim = product.getRowDim();
        int tmpColDim = product.getColDim();
        int tmpPlxDim = complexity;
        double[] tmpLeftRow = new double[tmpPlxDim];
        int tmpFirst = 0;
        int tmpLimit = tmpPlxDim;
        for (int i = firstRow; i < rowLimit; ++i) {
            int tmpFirstInRow = Structure2D.firstInRow(left, i, 0);
            int tmpLimitOfRow = Structure2D.limitOfRow(left, i, tmpPlxDim);
            for (int c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = left.doubleValue(Structure2D.index(tmpRowDim, i, c));
            }
            for (int j = 0; j < tmpColDim; ++j) {
                long tmpColBase = Structure2D.index(complexity, 0L, j);
                tmpFirst = Structure2D.firstInColumn(right, j, tmpFirstInRow);
                tmpLimit = Structure2D.limitOfColumn(right, j, tmpLimitOfRow);
                double tmpVal = PrimitiveMath.ZERO;
                for (int c = tmpFirst; c < tmpLimit; ++c) {
                    tmpVal += tmpLeftRow[c] * right.doubleValue((long)c + tmpColBase);
                }
                product.set((long)i, (long)j, tmpVal);
            }
        }
    }

    @FunctionalInterface
    public static interface Primitive
    extends TransformableRegion.FillByMultiplying<Double> {
    }

    @FunctionalInterface
    public static interface Generic<N extends Scalar<N>>
    extends TransformableRegion.FillByMultiplying<N> {
    }
}

