/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.types.Array;

class McosObject {
    private final String packageName;
    private final String className;
    private final List<String> fieldNames = new ArrayList<String>(8);
    private final Map<String, Array> properties = new HashMap<String, Array>(16);
    static final McosObject EMPTY = new McosObject("", ""){

        @Override
        public void set(String name, Array value) {
            throw new IllegalStateException("Can't set empty reference.");
        }
    };

    McosObject(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    String getPackageName() {
        return this.packageName;
    }

    String getClassName() {
        return this.className;
    }

    List<String> getFieldNames() {
        return this.fieldNames;
    }

    void set(String name, Array value) {
        if (this.properties.put(name, value) == null) {
            this.fieldNames.add(name);
        }
    }

    Array get(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        return "'" + this.getClassName() + "' class";
    }

    public int hashCode() {
        return Compat.hash(this.packageName, this.className, this.fieldNames, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof McosObject) {
            McosObject other = (McosObject)obj;
            return other.packageName.equals(this.packageName) && other.className.equals(this.className) && other.fieldNames.equals(this.fieldNames) && other.properties.equals(this.properties);
        }
        return false;
    }
}

