/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.icon;

import bibliothek.gui.dock.util.font.GenericFontModifier;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class TabMenuOverflowIcon
implements Icon {
    private int size;

    public TabMenuOverflowIcon(int size) {
        this.size = size;
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(c.getForeground());
        this.drawArrow(g, x + 1, y + 1);
        this.drawArrow(g, x + 4, y + 1);
        String text = this.size > 100 ? "+" : String.valueOf(this.size);
        Font font = g.getFont();
        GenericFontModifier modifier = new GenericFontModifier();
        modifier.setSizeDelta(false);
        modifier.setSize(8);
        g.setFont(modifier.modify(font));
        TextLayout layout = new TextLayout(text, g.getFont(), ((Graphics2D)g).getFontRenderContext());
        Rectangle2D bounds = layout.getBounds();
        layout.draw((Graphics2D)g, (float)((double)(x + this.getIconWidth()) - bounds.getWidth() - bounds.getX() - 1.0), (float)((double)(y + this.getIconHeight()) - bounds.getHeight() - bounds.getY() - 1.0));
        g.setFont(font);
    }

    private void drawArrow(Graphics g, int x, int y) {
        g.drawLine(x, y, x + 1, y);
        g.drawLine(x + 1, y + 1, x + 2, y + 1);
        g.drawLine(x + 2, y + 2, x + 3, y + 2);
        g.drawLine(x + 1, y + 3, x + 2, y + 3);
        g.drawLine(x, y + 4, x + 1, y + 4);
    }
}

