/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.List;
import java.util.Map;
import oshi.hardware.common.AbstractBaseboard;
import oshi.util.platform.windows.WmiUtil;

public class WindowsBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;

    WindowsBaseboard() {
        this.init();
    }

    private void init() {
        List<String> baseboardSerials;
        List<String> baseboardVersions;
        List<String> baseboardModels;
        Map<String, List<String>> win32BaseBoard = WmiUtil.selectStringsFrom(null, "Win32_BaseBoard", "Manufacturer,Model,Version,SerialNumber", null);
        List<String> baseboardManufacturers = win32BaseBoard.get("Manufacturer");
        if (baseboardManufacturers != null && !baseboardManufacturers.isEmpty()) {
            this.setManufacturer(baseboardManufacturers.get(0));
        }
        if ((baseboardModels = win32BaseBoard.get("Model")) != null && !baseboardModels.isEmpty()) {
            this.setModel(baseboardModels.get(0));
        }
        if ((baseboardVersions = win32BaseBoard.get("Version")) != null && !baseboardVersions.isEmpty()) {
            this.setVersion(baseboardVersions.get(0));
        }
        if ((baseboardSerials = win32BaseBoard.get("SerialNumber")) != null && !baseboardSerials.isEmpty()) {
            this.setSerialNumber(baseboardSerials.get(0));
        }
    }
}

