/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.List;
import javax.swing.RowSorter;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;

public class RowSorterWrapper<M>
extends RowSorter<M> {
    private RowSorter<M> delegate;
    private RowSorterListener rowSorterListener;

    public RowSorterWrapper(RowSorter<M> delegate) {
        this.delegate = delegate;
        delegate.addRowSorterListener(this.getRowSorterListener());
    }

    protected RowSorterListener getRowSorterListener() {
        if (this.rowSorterListener == null) {
            RowSorterListener listener;
            this.rowSorterListener = listener = new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    if (RowSorterEvent.Type.SORT_ORDER_CHANGED == e.getType()) {
                        RowSorterWrapper.this.fireSortOrderChanged();
                    } else if (RowSorterEvent.Type.SORTED == e.getType()) {
                        RowSorterWrapper.this.fireRowSorterChanged(null);
                    }
                }
            };
        }
        return this.rowSorterListener;
    }

    @Override
    public M getModel() {
        return this.delegate.getModel();
    }

    @Override
    public void toggleSortOrder(int column) {
        this.delegate.toggleSortOrder(column);
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return this.delegate.convertRowIndexToModel(index);
    }

    @Override
    public int convertRowIndexToView(int index) {
        return this.delegate.convertRowIndexToModel(index);
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        this.delegate.setSortKeys(keys);
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.delegate.getSortKeys();
    }

    @Override
    public int getViewRowCount() {
        return this.delegate.getViewRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.delegate.getModelRowCount();
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }
}

