/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.QNode;
import com.cburch.logisim.util.QNodeQueue;
import java.util.Map;
import java.util.TreeMap;

public class QueueOfQueues<T extends QNode>
implements QNodeQueue<T> {
    private TimeNode firstTimeNode = null;
    private int size = 0;
    private final TimeNodeMap timeNodeMap;
    private TimeNode unusedTimeNodes = null;

    public QueueOfQueues(String queueType) {
        this.timeNodeMap = "listOfQueues".equals(queueType) ? new LinkedNodeMap() : new TreeNodeMap();
    }

    @Override
    public boolean add(T node) {
        this.findTimeNode(((QNode)node).timeKey).add(node);
        ++this.size;
        return true;
    }

    @Override
    public void clear() {
        this.firstTimeNode = null;
        this.timeNodeMap.clear();
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public T peek() {
        return this.firstTimeNode == null ? null : (T)this.firstTimeNode.peek();
    }

    @Override
    public T remove() {
        if (this.firstTimeNode == null) {
            return null;
        }
        Object ret = this.firstTimeNode.remove();
        --this.size;
        if (this.firstTimeNode.isEmpty()) {
            TimeNode oldFirst = this.firstTimeNode;
            this.firstTimeNode = this.timeNodeMap.removeFirst();
            this.recycleTimeNode(oldFirst);
        }
        return ret;
    }

    @Override
    public int size() {
        return this.size;
    }

    TimeNode findTimeNode(int timeKey) {
        if (this.firstTimeNode == null) {
            this.firstTimeNode = this.getNewTimeNode(timeKey);
            return this.firstTimeNode;
        }
        if (this.firstTimeNode.timeKey == timeKey) {
            return this.firstTimeNode;
        }
        if (timeKey - this.firstTimeNode.timeKey < 0) {
            TimeNode oldFirst = this.firstTimeNode;
            this.firstTimeNode = this.getNewTimeNode(timeKey);
            this.timeNodeMap.addFirst(oldFirst);
            return this.firstTimeNode;
        }
        return this.timeNodeMap.addIfNeeded(timeKey);
    }

    private TimeNode getNewTimeNode(int timeKey) {
        if (this.unusedTimeNodes == null) {
            return new TimeNode(this, timeKey);
        }
        TimeNode node = this.unusedTimeNodes;
        this.unusedTimeNodes = this.unusedTimeNodes.next;
        node.timeKey = timeKey;
        node.next = null;
        return node;
    }

    private void recycleTimeNode(TimeNode node) {
        node.tail = null;
        node.head = null;
        node.next = this.unusedTimeNodes;
        this.unusedTimeNodes = node;
    }

    private class TimeNode {
        public int timeKey;
        public TimeNode next;
        private T head;
        private T tail;

        TimeNode(QueueOfQueues queueOfQueues, int timeKey) {
            this.timeKey = timeKey;
        }

        void add(T node) {
            if (this.head == null) {
                this.tail = node;
                this.head = this.tail;
            } else {
                ((QNode)this.tail).right = node;
                this.tail = node;
            }
        }

        T peek() {
            return this.head == null ? null : (Object)this.head;
        }

        T remove() {
            if (this.head == null) {
                return null;
            }
            Object ret = this.head;
            QNode next = ((QNode)this.head).right;
            this.head = next;
            return ret;
        }

        boolean isEmpty() {
            return this.head == null;
        }
    }

    private class LinkedNodeMap
    extends TimeNodeMap {
        TimeNode head;

        private LinkedNodeMap() {
            super(QueueOfQueues.this);
            this.head = null;
        }

        @Override
        public void addFirst(TimeNode node) {
            node.next = this.head;
            this.head = node;
        }

        @Override
        public TimeNode addIfNeeded(int timeKey) {
            if (this.head == null) {
                this.head = QueueOfQueues.this.getNewTimeNode(timeKey);
                return this.head;
            }
            TimeNode node = this.head;
            TimeNode previous = null;
            while (node != null && node.timeKey - timeKey < 0) {
                previous = node;
                node = node.next;
            }
            if (node != null && node.timeKey == timeKey) {
                return node;
            }
            TimeNode newNode = QueueOfQueues.this.getNewTimeNode(timeKey);
            newNode.next = node;
            if (previous == null) {
                this.head = newNode;
            } else {
                previous.next = newNode;
            }
            return newNode;
        }

        @Override
        public void clear() {
            this.head = null;
        }

        @Override
        public TimeNode removeFirst() {
            if (this.head == null) {
                return null;
            }
            TimeNode oldHead = this.head;
            this.head = this.head.next;
            oldHead.next = null;
            return oldHead;
        }
    }

    private class TreeNodeMap
    extends TimeNodeMap {
        private final TreeMap<Integer, TimeNode> treeMap;

        private TreeNodeMap() {
            super(QueueOfQueues.this);
            this.treeMap = new TreeMap((ls, rs) -> ls - rs);
        }

        @Override
        public void addFirst(TimeNode node) {
            this.treeMap.put(node.timeKey, node);
        }

        @Override
        public TimeNode addIfNeeded(int timeKey) {
            return this.treeMap.computeIfAbsent(timeKey, QueueOfQueues.this::getNewTimeNode);
        }

        @Override
        public void clear() {
            this.treeMap.clear();
        }

        @Override
        public TimeNode removeFirst() {
            if (this.treeMap.isEmpty()) {
                return null;
            }
            Map.Entry<Integer, TimeNode> entry = this.treeMap.firstEntry();
            this.treeMap.remove(entry.getKey());
            return entry.getValue();
        }
    }

    private abstract class TimeNodeMap {
        private TimeNodeMap(QueueOfQueues queueOfQueues) {
        }

        public abstract void addFirst(TimeNode var1);

        public abstract TimeNode addIfNeeded(int var1);

        public abstract void clear();

        public abstract TimeNode removeFirst();
    }
}

