/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.move;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.tools.move.ConnectionData;

class SearchNode
implements Comparable<SearchNode> {
    private static final int CROSSING_PENALTY = 20;
    private static final int TURN_PENALTY = 50;
    private final Location loc;
    private final Direction dir;
    private final ConnectionData conn;
    private final Location dest;
    private final int dist;
    private final int heur;
    private final boolean extendsWire;
    private final SearchNode prev;

    public SearchNode(ConnectionData conn, Location src, Direction srcDir, Location dst) {
        this(src, srcDir, conn, dst, 0, srcDir != null, null);
    }

    private SearchNode(Location loc, Direction dir, ConnectionData conn, Location dest, int dist, boolean extendsWire, SearchNode prev) {
        this.loc = loc;
        this.dir = dir;
        this.conn = conn;
        this.dest = dest;
        this.dist = dist;
        this.heur = dist + this.getHeuristic();
        this.extendsWire = extendsWire;
        this.prev = prev;
    }

    @Override
    public int compareTo(SearchNode o) {
        int ret = this.heur - o.heur;
        if (ret == 0) {
            return this.hashCode() - o.hashCode();
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (other instanceof SearchNode) {
            SearchNode o = (SearchNode)other;
            return this.loc.equals(o.loc) && (this.dir == null ? o.dir == null : o.dir != null && this.dir.equals(o.dir)) && this.dest.equals(o.dest);
        }
        return false;
    }

    public ConnectionData getConnection() {
        return this.conn;
    }

    public Location getDestination() {
        return this.dest;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public int getDistance() {
        return this.dist;
    }

    private int getHeuristic() {
        Location cur = this.loc;
        Location dst = this.dest;
        Direction curDir = this.dir;
        int dx = dst.getX() - cur.getX();
        int dy = dst.getY() - cur.getY();
        int ret = -1;
        if (this.extendsWire) {
            ret = -1;
            if (curDir == Direction.EAST) {
                if (dx > 0) {
                    ret = dx / 10 * 9 + Math.abs(dy);
                }
            } else if (curDir == Direction.WEST) {
                if (dx < 0) {
                    ret = -dx / 10 * 9 + Math.abs(dy);
                }
            } else if (curDir == Direction.SOUTH) {
                if (dy > 0) {
                    ret = Math.abs(dx) + dy / 10 * 9;
                }
            } else if (curDir == Direction.NORTH && dy < 0) {
                ret = Math.abs(dx) - dy / 10 * 9;
            }
        }
        if (ret < 0) {
            ret = Math.abs(dx) + Math.abs(dy);
        }
        boolean penalizeDoubleTurn = false;
        if (curDir == Direction.EAST) {
            penalizeDoubleTurn = dx < 0;
        } else if (curDir == Direction.WEST) {
            penalizeDoubleTurn = dx > 0;
        } else if (curDir == Direction.NORTH) {
            penalizeDoubleTurn = dy > 0;
        } else if (curDir == Direction.SOUTH) {
            penalizeDoubleTurn = dy < 0;
        } else if (curDir == null && (dx != 0 || dy != 0)) {
            ret += 50;
        }
        if (penalizeDoubleTurn) {
            ret += 100;
        } else if (dx != 0 && dy != 0) {
            ret += 50;
        }
        return ret;
    }

    public int getHeuristicValue() {
        return this.heur;
    }

    public Location getLocation() {
        return this.loc;
    }

    public SearchNode getPrevious() {
        return this.prev;
    }

    public int hashCode() {
        int dirHash = this.dir == null ? 0 : this.dir.hashCode();
        return (this.loc.hashCode() * 31 + dirHash) * 31 + this.dest.hashCode();
    }

    public boolean isDestination() {
        return this.dest.equals(this.loc);
    }

    public boolean isExtendingWire() {
        return this.extendsWire;
    }

    public boolean isStart() {
        return this.prev == null;
    }

    public SearchNode next(Direction moveDir, boolean crossing) {
        int newDist = this.dist;
        Direction connDir = this.conn.getDirection();
        Location nextLoc = this.loc.translate(moveDir, 10);
        boolean exWire = this.extendsWire && moveDir == connDir;
        newDist += exWire ? 9 : 10;
        if (crossing) {
            newDist += 20;
        }
        if (moveDir != this.dir) {
            newDist += 50;
        }
        return nextLoc.getX() < 0 || nextLoc.getY() < 0 ? null : new SearchNode(nextLoc, moveDir, this.conn, this.dest, newDist, exWire, this);
    }

    public String toString() {
        return String.valueOf(this.loc) + "/" + (this.dir == null ? "null" : this.dir.toString()) + (this.extendsWire ? "+" : "-") + "/" + String.valueOf(this.dest) + ":" + this.dist + "+" + (this.heur - this.dist);
    }
}

