/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.key;

import com.cburch.logisim.tools.key.KeyConfigurationEvent;
import com.cburch.logisim.tools.key.KeyConfigurationResult;
import com.cburch.logisim.tools.key.KeyConfigurator;
import java.util.HashMap;

public final class ParallelConfigurator
implements KeyConfigurator,
Cloneable {
    private KeyConfigurator[] handlers;

    private ParallelConfigurator(KeyConfigurator[] handlers) {
        this.handlers = handlers;
    }

    public static ParallelConfigurator create(KeyConfigurator a, KeyConfigurator b) {
        return new ParallelConfigurator(new KeyConfigurator[]{a, b});
    }

    public static ParallelConfigurator create(KeyConfigurator[] configs) {
        return new ParallelConfigurator(configs);
    }

    @Override
    public ParallelConfigurator clone() {
        ParallelConfigurator ret;
        try {
            ret = (ParallelConfigurator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        int len = this.handlers.length;
        ret.handlers = new KeyConfigurator[len];
        for (int i = 0; i < len; ++i) {
            ret.handlers[i] = this.handlers[i].clone();
        }
        return ret;
    }

    @Override
    public KeyConfigurationResult keyEventReceived(KeyConfigurationEvent event) {
        if (event.isConsumed()) {
            return null;
        }
        KeyConfigurationResult first = null;
        HashMap map = null;
        for (KeyConfigurator handler : this.handlers) {
            KeyConfigurationResult result = handler.keyEventReceived(event);
            if (result == null) continue;
            if (first == null) {
                first = result;
                continue;
            }
            if (map == null) {
                map = new HashMap(first.getAttributeValues());
                map.putAll(result.getAttributeValues());
                continue;
            }
            map.putAll(result.getAttributeValues());
        }
        return map != null ? new KeyConfigurationResult(event, map) : first;
    }
}

