/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.TransmissionGateIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.WireRepair;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;

public class TransmissionGate
extends InstanceFactory {
    public static final String _ID = "Transmission Gate";
    static final int OUTPUT = 0;
    static final int INPUT = 1;
    static final int GATE0 = 2;
    static final int GATE1 = 3;

    public TransmissionGate() {
        super(_ID, Strings.S.getter("transmissionGateComponent"));
        this.setIcon(new TransmissionGateIcon());
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.SELECT_LOC, StdAttr.WIDTH}, new Object[]{Direction.EAST, StdAttr.SELECT_TOP_RIGHT, BitWidth.ONE});
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
    }

    private Value computeOutput(InstanceState state) {
        BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
        Value input = state.getPortValue(1);
        Value gate0 = state.getPortValue(2);
        Value gate1 = state.getPortValue(3);
        if (gate0.isFullyDefined() && gate1.isFullyDefined() && gate0 != gate1) {
            if (gate0 == Value.TRUE) {
                return Value.createUnknown(width);
            }
            return input;
        }
        if (input.isFullyDefined()) {
            return Value.createError(width);
        }
        Value[] v = input.getAll();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == Value.UNKNOWN) continue;
            v[i] = Value.ERROR;
        }
        return Value.create(v);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public boolean contains(Location loc, AttributeSet attrs) {
        if (super.contains(loc, attrs)) {
            Direction facing = attrs.getValue(StdAttr.FACING);
            Location center = Location.create(0, 0, true).translate(facing, -20);
            return center.manhattanDistanceTo(loc) < 24;
        }
        return false;
    }

    private void drawInstance(InstancePainter painter, boolean isGhost) {
        Color gate0;
        Bounds bds = painter.getBounds();
        AttributeOption powerLoc = painter.getAttributeValue(StdAttr.SELECT_LOC);
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        boolean flip = (facing == Direction.NORTH || facing == Direction.WEST) == (powerLoc == StdAttr.SELECT_TOP_RIGHT);
        int degrees = Direction.WEST.toDegrees() - facing.toDegrees();
        if (flip) {
            degrees += 180;
        }
        double radians = Math.toRadians((degrees + 360) % 360);
        Graphics2D g = (Graphics2D)painter.getGraphics().create();
        g.rotate(radians, bds.getX() + 20, bds.getY() + 20);
        g.translate(bds.getX(), bds.getY());
        GraphicsUtil.switchToWidth(g, 3);
        Color gate1 = gate0 = g.getColor();
        Color input = gate0;
        Color output = gate0;
        Color platform = gate0;
        if (!isGhost && painter.getShowState()) {
            gate0 = painter.getPortValue(2).getColor();
            gate1 = painter.getPortValue(2).getColor();
            input = painter.getPortValue(1).getColor();
            output = painter.getPortValue(0).getColor();
            platform = this.computeOutput(painter).getColor();
        }
        g.setColor(flip ? input : output);
        g.drawLine(0, 20, 13, 20);
        g.drawLine(13, 14, 13, 26);
        g.setColor(flip ? output : input);
        g.drawLine(27, 20, 40, 20);
        g.drawLine(27, 14, 27, 26);
        g.setColor(gate0);
        g.drawLine(20, 38, 20, 40);
        GraphicsUtil.switchToWidth(g, 2);
        g.drawOval(17, 32, 6, 6);
        g.drawLine(11, 31, 29, 31);
        GraphicsUtil.switchToWidth(g, 3);
        g.setColor(gate1);
        g.drawLine(20, 7, 20, 0);
        GraphicsUtil.switchToWidth(g, 2);
        g.drawLine(11, 9, 29, 9);
        g.setColor(platform);
        g.drawLine(9, 13, 31, 13);
        g.drawLine(9, 27, 31, 27);
        GraphicsUtil.switchToWidth(g, 1);
        if (flip) {
            g.drawLine(19, 18, 21, 20);
            g.drawLine(19, 22, 21, 20);
        } else {
            g.drawLine(21, 18, 19, 20);
            g.drawLine(21, 22, 19, 20);
        }
        g.dispose();
    }

    @Override
    public Object getInstanceFeature(Instance instance, Object key) {
        if (key == WireRepair.class) {
            return data -> true;
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        return Bounds.create(0, -20, 40, 40).rotate(Direction.WEST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == StdAttr.SELECT_LOC) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == StdAttr.WIDTH) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.drawInstance(painter, true);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        this.drawInstance(painter, false);
    }

    @Override
    public void propagate(InstanceState state) {
        state.setPort(0, this.computeOutput(state), 1);
    }

    private void updatePorts(Instance instance) {
        int dx = 0;
        int dy = 0;
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        if (facing == Direction.NORTH) {
            dy = 1;
        } else if (facing == Direction.EAST) {
            dx = -1;
        } else if (facing == Direction.SOUTH) {
            dy = -1;
        } else if (facing == Direction.WEST) {
            dx = 1;
        }
        AttributeOption powerLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        boolean flip = (facing == Direction.NORTH || facing == Direction.WEST) == (powerLoc == StdAttr.SELECT_TOP_RIGHT);
        Port[] ports = new Port[4];
        ports[0] = new Port(0, 0, "output", StdAttr.WIDTH);
        ports[1] = new Port(40 * dx, 40 * dy, "input", StdAttr.WIDTH);
        if (flip) {
            ports[3] = new Port(20 * (dx - dy), 20 * (dx + dy), "input", 1);
            ports[2] = new Port(20 * (dx + dy), 20 * (-dx + dy), "input", 1);
        } else {
            ports[2] = new Port(20 * (dx - dy), 20 * (dx + dy), "input", 1);
            ports[3] = new Port(20 * (dx + dy), 20 * (-dx + dy), "input", 1);
        }
        ports[1].setToolTip(Strings.S.getter("transmissionGateSource"));
        ports[0].setToolTip(Strings.S.getter("transmissionGateDrain"));
        ports[2].setToolTip(Strings.S.getter("transmissionGatePGate"));
        ports[3].setToolTip(Strings.S.getter("transmissionGateNGate"));
        instance.setPorts(ports);
    }
}

