/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;

public class AbstractConstantHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    public long getConstant(AttributeSet attrs) {
        return 0L;
    }

    @Override
    public LineBuffer getInlinedCode(Netlist nets, Long componentId, netlistComponent componentInfo, String circuitName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        int nrOfBits = componentInfo.getComponent().getEnd(0).getWidth().getWidth();
        if (componentInfo.isEndConnected(0)) {
            long constantValue = this.getConstant(componentInfo.getComponent().getAttributeSet());
            if (componentInfo.getComponent().getEnd(0).getWidth().getWidth() == 1) {
                contents.add("{{assign}} {{1}} {{=}} {{2}};", Hdl.getNetName(componentInfo, 0, true, nets), Hdl.getConstantVector(constantValue, 1)).add("");
            } else if (nets.isContinuesBus(componentInfo, 0)) {
                contents.add("{{assign}} {{1}} {{=}} {{2}};", Hdl.getBusNameContinues(componentInfo, 0, nets), Hdl.getConstantVector(constantValue, nrOfBits));
                contents.add("");
            } else {
                long mask = 1L;
                String constValue = Hdl.zeroBit();
                for (int bit = 0; bit < nrOfBits; ++bit) {
                    constValue = (mask & constantValue) != 0L ? Hdl.oneBit() : Hdl.zeroBit();
                    mask <<= 1;
                    contents.add("{{assign}} {{1}} {{=}} {{2}};", Hdl.getBusEntryName(componentInfo, 0, true, bit, nets), constValue);
                }
                contents.add("");
            }
        }
        return contents;
    }
}

