/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.ShiftRegisterData;

public class Ttl74194
extends AbstractTtlGate {
    public static final String _ID = "74194";
    public static final int DELAY = 1;
    public static final byte S0 = 9;
    public static final byte S1 = 10;
    public static final byte SR = 2;
    public static final byte SL = 7;
    public static final byte CLK = 11;
    public static final byte nCLR = 1;
    public static final byte A = 3;
    public static final byte B = 4;
    public static final byte C = 5;
    public static final byte D = 6;
    public static final byte QA = 15;
    public static final byte QB = 14;
    public static final byte QC = 13;
    public static final byte QD = 12;
    public static final byte GND = 8;
    public static final byte VCC = 16;
    private static final byte[] DATA = new byte[]{6, 5, 4, 3};
    private InstanceState _state;

    public Ttl74194() {
        super(_ID, (byte)16, new byte[]{15, 14, 13, 12}, new String[]{"nCLR", "SR", "A", "B", "C", "D", "SL", "S0", "S1", "CLK", "QD", "QC", "QB", "QA"}, null);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, this.portNames);
    }

    private byte pinNrToPortNr(byte dsPinNr) {
        return (byte)(dsPinNr <= 8 ? dsPinNr - 1 : dsPinNr - 2);
    }

    private Value getPort(byte dsPinNr) {
        return this._state.getPortValue(this.pinNrToPortNr(dsPinNr));
    }

    private void setPort(byte dsPinNr, Value v) {
        this._state.setPort(this.pinNrToPortNr(dsPinNr), v, 1);
    }

    private ShiftRegisterData getData() {
        ShiftRegisterData data = (ShiftRegisterData)this._state.getData();
        if (data == null) {
            data = new ShiftRegisterData(BitWidth.ONE, 4);
            this._state.setData(data);
        }
        return data;
    }

    private boolean isTriggered() {
        return this.getData().updateClock(this.getPort((byte)11), StdAttr.TRIG_RISING);
    }

    private Mode getMode() {
        int mode = (this.getPort((byte)10) == Value.TRUE ? 2 : 0) + (this.getPort((byte)9) == Value.TRUE ? 1 : 0);
        return Mode.values()[mode];
    }

    private void propagateRegister() {
        if (this.getPort((byte)1) == Value.FALSE) {
            this.getData().clear();
        } else if (this.isTriggered()) {
            switch (this.getMode().ordinal()) {
                case 3: {
                    for (int i = 0; i < 4; ++i) {
                        this.getData().set(i, this.getPort(DATA[i]));
                    }
                    break;
                }
                case 2: {
                    this.getData().pushUp(this.getPort((byte)7));
                    break;
                }
                case 1: {
                    this.getData().pushDown(this.getPort((byte)2));
                    break;
                }
            }
        }
    }

    private void propagateOutputs() {
        this.setPort((byte)15, this.getData().get(3));
        this.setPort((byte)14, this.getData().get(2));
        this.setPort((byte)13, this.getData().get(1));
        this.setPort((byte)12, this.getData().get(0));
    }

    @Override
    public void propagateTtl(InstanceState state) {
        this._state = state;
        this.propagateRegister();
        this.propagateOutputs();
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{this.pinNrToPortNr((byte)11)};
    }

    static enum Mode {
        HOLD,
        SHIFT_RIGHT,
        SHIFT_LEFT,
        LOAD;

    }
}

