/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import java.util.ArrayList;

public class Ttl74138
extends AbstractTtlGate {
    public static final String _ID = "74138";
    public static final byte A = 1;
    public static final byte B = 2;
    public static final byte C = 3;
    public static final byte nEN2A = 4;
    public static final byte nEN2B = 5;
    public static final byte EN1 = 6;
    public static final byte nY7 = 7;
    public static final byte GND = 8;
    public static final byte nY6 = 9;
    public static final byte nY5 = 10;
    public static final byte nY4 = 11;
    public static final byte nY3 = 12;
    public static final byte nY2 = 13;
    public static final byte nY1 = 14;
    public static final byte nY0 = 15;
    public static final byte VCC = 16;
    public static final int DELAY = 1;

    public Ttl74138() {
        super(_ID, (byte)16, new byte[]{15, 14, 13, 12, 11, 10, 9, 7}, new String[]{"A", "B", "C", "nG2A Enable (active LOW)", "nG2B Enable (active LOW)", "G1 Enable (active HIGH)", "nY7", "nY6", "nY5", "nY4", "nY3", "nY2", "nY1", "nY0"}, null);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        int label_len_max = 4;
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.portNames) {
            String[] tmp = name.split("\\s+");
            names.add(tmp[0].length() <= 4 ? tmp[0] : tmp[0].substring(0, 4));
        }
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, names.toArray(new String[0]));
    }

    protected byte mapPort(byte dsIdx) {
        return (byte)(dsIdx <= 8 ? dsIdx - 1 : dsIdx - 2);
    }

    protected void computeState(InstanceState state, byte inEn1, byte inEn2a, byte inEn2b, byte inA, byte inB, byte inC, byte[] outPorts) {
        boolean enabled = state.getPortValue(this.mapPort(inEn1)) == Value.TRUE && state.getPortValue(this.mapPort(inEn2a)) == Value.FALSE && state.getPortValue(this.mapPort(inEn2b)) == Value.FALSE;
        int A = state.getPortValue(this.mapPort(inA)) == Value.TRUE ? 1 : 0;
        int B = state.getPortValue(this.mapPort(inB)) == Value.TRUE ? 2 : 0;
        int C = state.getPortValue(this.mapPort(inC)) == Value.TRUE ? 4 : 0;
        int[][] outputPortStates = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 1}};
        for (int i = 0; i < 8; ++i) {
            Value val = enabled ? (outputPortStates[A + B + C][i] == 0 ? Value.TRUE : Value.FALSE) : Value.TRUE;
            state.setPort(this.mapPort(outPorts[i]), val, 1);
        }
    }

    @Override
    public void propagateTtl(InstanceState state) {
        byte[] out = new byte[]{15, 14, 13, 12, 11, 10, 9, 7};
        this.computeState(state, (byte)6, (byte)4, (byte)5, (byte)1, (byte)2, (byte)3, out);
    }
}

