/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.ClockState;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

abstract class AbstractFlipFlop
extends InstanceFactory {
    private static final int STD_PORTS = 5;
    private final int numInputs;
    private final Attribute<AttributeOption> triggerAttribute;

    protected AbstractFlipFlop(String name, String iconName, StringGetter desc, int numInputs, boolean allowLevelTriggers, HdlGeneratorFactory generator) {
        super(name, desc, generator);
        this.numInputs = numInputs;
        this.setIconName(iconName);
        this.triggerAttribute = allowLevelTriggers ? StdAttr.TRIGGER : StdAttr.EDGE_TRIGGER;
        this.setAttributes(new Attribute[]{this.triggerAttribute, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.APPEARANCE}, new Object[]{StdAttr.TRIG_RISING, "", StdAttr.DEFAULT_LABEL_FONT, AppPreferences.getDefaultAppearance()});
        this.setInstancePoker(Poker.class);
        this.setInstanceLogger(Logger.class);
    }

    protected AbstractFlipFlop(String name, Icon icon, StringGetter desc, int numInputs, boolean allowLevelTriggers, HdlGeneratorFactory generator) {
        super(name, desc, generator);
        this.numInputs = numInputs;
        this.setIcon(icon);
        this.triggerAttribute = allowLevelTriggers ? StdAttr.TRIGGER : StdAttr.EDGE_TRIGGER;
        this.setAttributes(new Attribute[]{this.triggerAttribute, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.APPEARANCE}, new Object[]{StdAttr.TRIG_RISING, "", StdAttr.DEFAULT_LABEL_FONT, AppPreferences.getDefaultAppearance()});
        this.setInstancePoker(Poker.class);
        this.setInstanceLogger(Logger.class);
    }

    private void updatePorts(Instance instance) {
        Port[] ps = new Port[this.numInputs + 5];
        if (instance.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            if (this.numInputs == 1) {
                ps[0] = new Port(-40, 20, "input", 1);
                ps[1] = new Port(-40, 0, "input", 1);
            } else if (this.numInputs == 2) {
                ps[0] = new Port(-40, 0, "input", 1);
                ps[1] = new Port(-40, 20, "input", 1);
                ps[2] = new Port(-40, 10, "input", 1);
            } else {
                throw new RuntimeException("flip-flop input > 2");
            }
            ps[this.numInputs + 1] = new Port(0, 0, "output", 1);
            ps[this.numInputs + 2] = new Port(0, 20, "output", 1);
            ps[this.numInputs + 3] = new Port(-10, 30, "input", 1);
            ps[this.numInputs + 4] = new Port(-30, 30, "input", 1);
        } else {
            if (this.numInputs == 1) {
                ps[0] = new Port(-10, 10, "input", 1);
                ps[1] = new Port(-10, 50, "input", 1);
            } else if (this.numInputs == 2) {
                ps[0] = new Port(-10, 10, "input", 1);
                ps[1] = new Port(-10, 30, "input", 1);
                ps[2] = new Port(-10, 50, "input", 1);
            } else {
                throw new RuntimeException("flip-flop input > 2");
            }
            ps[this.numInputs + 1] = new Port(50, 10, "output", 1);
            ps[this.numInputs + 2] = new Port(50, 50, "output", 1);
            ps[this.numInputs + 3] = new Port(20, 60, "input", 1);
            ps[this.numInputs + 4] = new Port(20, 0, "input", 1);
        }
        ps[this.numInputs].setToolTip(Strings.S.getter("flipFlopClockTip"));
        ps[this.numInputs + 1].setToolTip(Strings.S.getter("flipFlopQTip"));
        ps[this.numInputs + 2].setToolTip(Strings.S.getter("flipFlopNotQTip"));
        ps[this.numInputs + 3].setToolTip(Strings.S.getter("flipFlopResetTip"));
        ps[this.numInputs + 4].setToolTip(Strings.S.getter("flipFlopPresetTip"));
        instance.setPorts(ps);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        return attrs.getValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC ? Bounds.create(-40, -10, 40, 40) : Bounds.create(-10, 0, 60, 60);
    }

    protected abstract Value computeValue(Value[] var1, Value var2);

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        Bounds bds = instance.getBounds();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() / 2, bds.getY() - 3, 0, 1);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder completeName = new StringBuilder();
        String[] parts = this.getName().split(" ");
        completeName.append(parts[0].replace("-", "_").toUpperCase());
        completeName.append("_");
        if (attrs.containsAttribute(StdAttr.EDGE_TRIGGER)) {
            completeName.append("FlipFlop".toUpperCase());
        } else if (attrs.containsAttribute(StdAttr.TRIGGER)) {
            if (attrs.getValue(StdAttr.TRIGGER) == StdAttr.TRIG_FALLING || attrs.getValue(StdAttr.TRIGGER) == StdAttr.TRIG_RISING) {
                completeName.append("FlipFlop".toUpperCase());
            } else {
                completeName.append("Latch".toUpperCase());
            }
        } else {
            completeName.append("FlipFlop".toUpperCase());
        }
        return completeName.toString();
    }

    protected abstract String getInputName(int var1);

    @Override
    public void paintInstance(InstancePainter painter) {
        if (painter.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            this.paintInstanceClassic(painter);
        } else {
            this.paintInstanceEvolution(painter);
        }
    }

    private void paintInstanceClassic(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Color baseColor = new Color(AppPreferences.COMPONENT_COLOR.get());
        g.setColor(baseColor);
        painter.drawBounds();
        painter.drawLabel();
        if (painter.getShowState()) {
            Location loc = painter.getLocation();
            StateData myState = (StateData)painter.getData();
            if (myState != null) {
                int x = loc.getX();
                int y = loc.getY();
                g.setColor(myState.curValue.getColor());
                g.fillOval(x - 26, y + 4, 13, 13);
                g.setColor(Color.WHITE);
                GraphicsUtil.drawCenteredText(g, myState.curValue.toDisplayString(), x - 20, y + 9);
                g.setColor(baseColor);
            }
        }
        int n = this.numInputs;
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        painter.drawPort(n + 3, "0", Direction.SOUTH);
        painter.drawPort(n + 4, "1", Direction.SOUTH);
        g.setColor(baseColor);
        for (int i = 0; i < n; ++i) {
            painter.drawPort(i, this.getInputName(i), Direction.EAST);
        }
        painter.drawClock(n, Direction.EAST);
        painter.drawPort(n + 1, "Q", Direction.WEST);
        painter.drawPort(n + 2);
    }

    private void paintInstanceEvolution(InstancePainter painter) {
        StateData myState;
        Graphics g = painter.getGraphics();
        painter.drawLabel();
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        Color baseColor = new Color(AppPreferences.COMPONENT_COLOR.get());
        g.setColor(baseColor);
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRect(x, y, 40, 60);
        if (painter.getShowState() && (myState = (StateData)painter.getData()) != null) {
            g.setColor(myState.curValue.getColor());
            g.fillOval(x + 13, y + 23, 14, 14);
            g.setColor(Color.WHITE);
            GraphicsUtil.drawCenteredText(g, myState.curValue.toDisplayString(), x + 20, y + 28);
            g.setColor(baseColor);
        }
        int n = this.numInputs;
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        painter.drawPort(n + 3, "R", Direction.SOUTH);
        painter.drawPort(n + 4, "S", Direction.NORTH);
        g.setColor(baseColor);
        for (int i = 0; i < n; ++i) {
            GraphicsUtil.switchToWidth(g, 3);
            g.drawLine(x - 10, y + 10 + i * 20, x - 1, y + 10 + i * 20);
            painter.drawPort(i);
            GraphicsUtil.drawCenteredText(g, this.getInputName(i), x + 8, y + 8 + i * 20);
        }
        AttributeOption trigger = painter.getAttributeValue(this.triggerAttribute);
        if (trigger.equals(StdAttr.TRIG_RISING) || trigger.equals(StdAttr.TRIG_FALLING)) {
            painter.drawClockSymbol(x, y + 50);
        } else {
            GraphicsUtil.drawCenteredText(g, "E", x + 8, y + 48);
        }
        if (trigger.equals(StdAttr.TRIG_RISING) || trigger.equals(StdAttr.TRIG_HIGH)) {
            GraphicsUtil.switchToWidth(g, 2);
            g.drawLine(x - 10, y + 50, x - 1, y + 50);
        } else {
            GraphicsUtil.switchToWidth(g, 2);
            g.drawOval(x - 10, y + 45, 10, 10);
        }
        painter.drawPort(n);
        GraphicsUtil.switchToWidth(g, 3);
        g.drawLine(x + 41, y + 10, x + 50, y + 10);
        GraphicsUtil.drawCenteredText(g, "Q", x + 31, y + 8);
        painter.drawPort(n + 1);
        GraphicsUtil.switchToWidth(g, 2);
        g.drawOval(x + 40, y + 45, 10, 10);
        painter.drawPort(n + 2);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        StateData data = (StateData)state.getData();
        if (data == null) {
            data = new StateData();
            state.setData(data);
        }
        int n = this.numInputs;
        AttributeOption triggerType = state.getAttributeValue(this.triggerAttribute);
        boolean triggered = data.updateClock(state.getPortValue(n), triggerType);
        if (state.getPortValue(n + 3) == Value.TRUE) {
            data.curValue = Value.FALSE;
        } else if (state.getPortValue(n + 4) == Value.TRUE) {
            data.curValue = Value.TRUE;
        } else if (triggered) {
            Value[] inputs = new Value[n];
            for (int i = 0; i < n; ++i) {
                inputs[i] = state.getPortValue(i);
            }
            Value newVal = this.computeValue(inputs, data.curValue);
            if (newVal == Value.TRUE || newVal == Value.FALSE) {
                data.curValue = newVal;
            }
        }
        state.setPort(n + 1, data.curValue, 5);
        state.setPort(n + 2, data.curValue.not(), 5);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return Netlist.isFlipFlop(comp.getComponent().getAttributeSet());
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{this.numInputs};
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.APPEARANCE) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        }
    }

    public static class Poker
    extends InstancePoker {
        boolean isPressed = true;

        private boolean isInside(InstanceState state, MouseEvent e) {
            int dy;
            int dx;
            Location loc = state.getInstance().getLocation();
            if (state.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
                dx = e.getX() - (loc.getX() - 20);
                dy = e.getY() - (loc.getY() + 10);
            } else {
                dx = e.getX() - (loc.getX() + 20);
                dy = e.getY() - (loc.getY() + 30);
            }
            int d2 = dx * dx + dy * dy;
            return d2 < 64;
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.isPressed = this.isInside(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            if (this.isPressed && this.isInside(state, e)) {
                StateData myState = (StateData)state.getData();
                if (myState == null) {
                    return;
                }
                myState.curValue = myState.curValue.not();
                state.fireInvalidated();
            }
            this.isPressed = false;
        }

        @Override
        public void keyTyped(InstanceState state, KeyEvent e) {
            int val = Character.digit(e.getKeyChar(), 16);
            if (val < 0) {
                return;
            }
            StateData myState = (StateData)state.getData();
            if (myState == null) {
                return;
            }
            if (val == 0 && myState.curValue != Value.FALSE) {
                myState.curValue = Value.FALSE;
                state.fireInvalidated();
            } else if (val == 1 && myState.curValue != Value.TRUE) {
                myState.curValue = Value.TRUE;
                state.fireInvalidated();
            }
        }

        @Override
        public void keyPressed(InstanceState state, KeyEvent e) {
            StateData myState = (StateData)state.getData();
            if (myState == null) {
                return;
            }
            if (e.getKeyCode() == 40 && myState.curValue != Value.FALSE) {
                myState.curValue = Value.FALSE;
                state.fireInvalidated();
            } else if (e.getKeyCode() == 38 && myState.curValue != Value.TRUE) {
                myState.curValue = Value.TRUE;
                state.fireInvalidated();
            }
        }
    }

    public static class Logger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            String ret = state.getAttributeValue(StdAttr.LABEL);
            return ret != null && !ret.equals("") ? ret : null;
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return BitWidth.ONE;
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            StateData s = (StateData)state.getData();
            return s == null ? Value.FALSE : s.curValue;
        }
    }

    private static class StateData
    extends ClockState
    implements InstanceData {
        Value curValue = AppPreferences.Memory_Startup_Unknown.get() != false ? Value.UNKNOWN : Value.FALSE;

        private StateData() {
        }
    }
}

