/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.TtyIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.io.TtyShape;
import com.cburch.logisim.std.io.TtyState;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Tty
extends InstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "TTY";
    private static final int CLR = 0;
    private static final int CK = 1;
    private static final int WE = 2;
    private static final int IN = 3;
    public static final int BORDER = 6;
    public static final int ROW_HEIGHT = 15;
    public static final int COL_WIDTH = 7;
    private static final Color DEFAULT_BACKGROUND = new Color(0, 0, 0, 64);
    public static final Font DEFAULT_FONT = new Font("monospaced", 0, 11);
    private static final Attribute<Integer> ATTR_COLUMNS = Attributes.forIntegerRange("cols", Strings.S.getter("ttyColsAttr"), 1, 120);
    private static final Attribute<Integer> ATTR_ROWS = Attributes.forIntegerRange("rows", Strings.S.getter("ttyRowsAttr"), 1, 48);

    private static int getColumnCount(Object val) {
        return val instanceof Integer ? (Integer)val : 16;
    }

    private static int getRowCount(Object val) {
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return 4;
    }

    public Tty() {
        super(_ID, Strings.S.getter("ttyComponent"));
        this.setAttributes(new Attribute[]{ATTR_ROWS, ATTR_COLUMNS, StdAttr.EDGE_TRIGGER, IoLibrary.ATTR_COLOR, IoLibrary.ATTR_BACKGROUND}, new Object[]{8, 32, StdAttr.TRIG_RISING, Color.BLACK, DEFAULT_BACKGROUND});
        this.setIcon(new TtyIcon());
        Port[] ps = new Port[]{new Port(20, 10, "input", 1), new Port(0, 0, "input", 1), new Port(10, 10, "input", 1), new Port(0, -10, "input", 7)};
        ps[0].setToolTip(Strings.S.getter("ttyClearTip"));
        ps[1].setToolTip(Strings.S.getter("ttyClockTip"));
        ps[2].setToolTip(Strings.S.getter("ttyEnableTip"));
        ps[3].setToolTip(Strings.S.getter("ttyInputTip"));
        this.setPorts(ps);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        int height;
        int rows = Tty.getRowCount(attrs.getValue(ATTR_ROWS));
        int cols = Tty.getColumnCount(attrs.getValue(ATTR_COLUMNS));
        BufferedImage tempImage = new BufferedImage(1, 1, 2);
        Graphics tempGraphics = tempImage.getGraphics();
        tempGraphics.setFont(DEFAULT_FONT);
        int dynamicColWidth = tempGraphics.getFontMetrics().charWidth('W');
        tempGraphics.dispose();
        int width = 12 + cols * dynamicColWidth;
        if (width < 30) {
            width = 30;
        }
        if ((height = 12 + rows * 15) < 30) {
            height = 30;
        }
        return Bounds.create(0, 10 - height, width, height);
    }

    private TtyState getTtyState(InstanceState state) {
        int rows = Tty.getRowCount(state.getAttributeValue(ATTR_ROWS));
        int cols = Tty.getColumnCount(state.getAttributeValue(ATTR_COLUMNS));
        TtyState ret = (TtyState)state.getData();
        if (ret == null) {
            ret = new TtyState(rows, cols);
            state.setData(ret);
        } else {
            ret.updateSize(rows, cols);
        }
        return ret;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == ATTR_ROWS || attr == ATTR_COLUMNS) {
            instance.recomputeBounds();
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        Bounds bds = painter.getBounds();
        g.drawRoundRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), 10, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintInstance(InstancePainter painter) {
        boolean showState = painter.getShowState();
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        if (painter.shouldDrawColor()) {
            g.setColor(painter.getAttributeValue(IoLibrary.ATTR_BACKGROUND));
            g.fillRoundRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), 10, 10);
        }
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawClock(1, Direction.EAST);
        g.drawRoundRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), 12, 12);
        GraphicsUtil.switchToWidth(g, 1);
        painter.drawPort(0);
        painter.drawPort(2);
        painter.drawPort(3);
        int rows = Tty.getRowCount(painter.getAttributeValue(ATTR_ROWS));
        int cols = Tty.getColumnCount(painter.getAttributeValue(ATTR_COLUMNS));
        if (showState) {
            int curCol;
            int curRow;
            TtyState state;
            String[] rowData = new String[rows];
            TtyState ttyState = state = this.getTtyState(painter);
            synchronized (ttyState) {
                for (int i = 0; i < rows; ++i) {
                    rowData[i] = state.getRowString(i);
                }
                curRow = state.getCursorRow();
                curCol = state.getCursorColumn();
            }
            g.setFont(DEFAULT_FONT);
            g.setColor(painter.getAttributeValue(IoLibrary.ATTR_COLOR));
            FontMetrics fm = g.getFontMetrics();
            int x = bds.getX() + 6;
            int y = bds.getY() + 6 + (15 + fm.getAscent()) / 2;
            for (int i = 0; i < rows; ++i) {
                g.drawString(rowData[i], x, y);
                if (i == curRow) {
                    int x0 = x + fm.stringWidth(rowData[i].substring(0, curCol));
                    g.drawLine(x0, y - fm.getAscent(), x0, y);
                }
                y += 15;
            }
        } else {
            String str = Strings.S.get("ttyDesc", "" + rows, "" + cols);
            FontMetrics fm = g.getFontMetrics();
            int strWidth = fm.stringWidth(str);
            if (strWidth + 6 > bds.getWidth()) {
                str = Strings.S.get("ttyDescShort");
                strWidth = fm.stringWidth(str);
            }
            int x = bds.getX() + (bds.getWidth() - strWidth) / 2;
            int y = bds.getY() + (bds.getHeight() + fm.getAscent()) / 2;
            g.drawString(str, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(InstanceState circState) {
        AttributeOption trigger = circState.getAttributeValue(StdAttr.EDGE_TRIGGER);
        TtyState state = this.getTtyState(circState);
        Value clear = circState.getPortValue(0);
        Value clock = circState.getPortValue(1);
        Value enable = circState.getPortValue(2);
        Value in = circState.getPortValue(3);
        TtyState ttyState = state;
        synchronized (ttyState) {
            Value lastClock = state.setLastClock(clock);
            if (clear == Value.TRUE) {
                state.clear();
            } else if (enable != Value.FALSE) {
                boolean go;
                boolean bl = trigger == StdAttr.TRIG_FALLING ? lastClock == Value.TRUE && clock == Value.FALSE : (go = lastClock == Value.FALSE && clock == Value.TRUE);
                if (go) {
                    state.add(in.isFullyDefined() ? (char)in.toLongValue() : (char)'?');
                }
            }
        }
    }

    public void sendToStdout(InstanceState state) {
        TtyState tty = this.getTtyState(state);
        tty.setSendStdout(true);
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new TtyShape(x, y, path);
    }
}

