/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.PortHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class PortIo
extends InstanceFactory {
    public static final String _ID = "PortIO";
    public static final int MAX_IO = 64;
    public static final int MIN_IO = 1;
    private static final int INITPORTSIZE = 8;
    public static final Attribute<BitWidth> ATTR_SIZE = Attributes.forBitWidth("number", Strings.S.getter("pioNumber"), 1, 64);
    public static final AttributeOption INPUT = new AttributeOption("onlyinput", Strings.S.getter("pioInput"));
    public static final AttributeOption OUTPUT = new AttributeOption("onlyOutput", Strings.S.getter("pioOutput"));
    public static final AttributeOption INOUTSE = new AttributeOption("IOSingleEnable", Strings.S.getter("pioIOSingle"));
    public static final AttributeOption INOUTME = new AttributeOption("IOMultiEnable", Strings.S.getter("pioIOMultiple"));
    public static final Attribute<AttributeOption> ATTR_DIR = Attributes.forOption("direction", Strings.S.getter("pioDirection"), new AttributeOption[]{INPUT, OUTPUT, INOUTSE, INOUTME});
    protected static final int DELAY = 1;

    public static List<String> getLabels(int size) {
        ArrayList<String> labelNames = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            labelNames.add("pin_" + (i + 1));
        }
        return labelNames;
    }

    public PortIo() {
        super(_ID, Strings.S.getter("pioComponent"), new PortHdlGeneratorFactory(), false);
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR, StdAttr.LABEL_VISIBILITY, ATTR_SIZE, ATTR_DIR, StdAttr.MAPINFO}, new Object[]{Direction.EAST, "", Direction.EAST, StdAttr.DEFAULT_LABEL_FONT, StdAttr.DEFAULT_LABEL_COLOR, false, BitWidth.create(8), INOUTSE, new ComponentMapInformationContainer(0, 0, 8, null, null, PortIo.getLabels(8))});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIconName("pio.gif");
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(ATTR_SIZE, 1, 64, 512), new DirectionConfigurator(StdAttr.LABEL_LOC, 512)));
        this.setInstancePoker(PortPoker.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        instance.computeLabelTextField(4);
        int dipSize = instance.getAttributeValue(ATTR_SIZE).getWidth();
        instance.getAttributeSet().setValue(StdAttr.MAPINFO, new ComponentMapInformationContainer(0, 0, dipSize, null, null, PortIo.getLabels(dipSize)));
    }

    private void updatePorts(Instance instance) {
        String range;
        int n;
        int e;
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        AttributeOption dir = instance.getAttributeValue(ATTR_DIR);
        int size = instance.getAttributeValue(ATTR_SIZE).getWidth();
        int nPorts = dir == INPUT || dir == OUTPUT ? 1 : 3;
        Port[] ps = new Port[nPorts];
        int p = 0;
        int x = 0;
        int y = 0;
        int dx = 0;
        int dy = 0;
        if (facing == Direction.NORTH) {
            dy = -10;
        } else if (facing == Direction.SOUTH) {
            dy = 10;
        } else {
            dx = facing == Direction.WEST ? -10 : 10;
        }
        if (dir == INPUT || dir == OUTPUT) {
            x += dx;
            y += dy;
        }
        if (dir == INOUTSE) {
            ps[p] = new Port(x - dy, y + dx, "input", 1);
            ps[p].setToolTip(Strings.S.getter("pioOutEnable"));
            ++p;
            x += dx;
            y += dy;
        }
        int i = 0;
        for (n = size; n > 0; n -= e) {
            e = Math.min(n, 64);
            range = "[" + i + "..." + (i + e - 1) + "]";
            if (dir == INOUTME) {
                ps[p] = new Port(x - dy, y + dx, "input", e);
                ps[p].setToolTip(Strings.S.getter("pioOutEnables", range));
                ++p;
                x += dx;
                y += dy;
            }
            if (dir == INPUT || dir == INOUTSE || dir == INOUTME) {
                ps[p] = new Port(x, y, "input", e);
                ps[p].setToolTip(Strings.S.getter("pioOutputs", range));
                ++p;
                x += dx;
                y += dy;
            }
            i += 64;
        }
        i = 0;
        for (n = size; n > 0; n -= e) {
            e = Math.min(n, 64);
            range = "[" + i + "..." + (i + e - 1) + "]";
            if (dir == OUTPUT || dir == INOUTSE || dir == INOUTME) {
                ps[p] = new Port(x, y, "output", e);
                ps[p].setToolTip(Strings.S.getter("pioInputs", range));
                ++p;
                x += dx;
                y += dy;
            }
            i += 64;
        }
        instance.setPorts(ps);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        int n = attrs.getValue(ATTR_SIZE).getWidth();
        if (n < 8) {
            n = 8;
        }
        return Bounds.create(0, 0, 10 + (n + 1) / 2 * 10, 50).rotate(Direction.EAST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updatePorts(instance);
            instance.computeLabelTextField(4);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(4);
        } else if (attr == ATTR_SIZE || attr == ATTR_DIR) {
            instance.recomputeBounds();
            this.updatePorts(instance);
            instance.computeLabelTextField(4);
            ComponentMapInformationContainer map = instance.getAttributeValue(StdAttr.MAPINFO);
            if (map != null) {
                int nrPins = instance.getAttributeValue(ATTR_SIZE).getWidth();
                int inputs = 0;
                int outputs = 0;
                int ios = 0;
                List<String> labels = PortIo.getLabels(nrPins);
                if (instance.getAttributeValue(ATTR_DIR) == INPUT) {
                    inputs = nrPins;
                } else if (instance.getAttributeValue(ATTR_DIR) == OUTPUT) {
                    outputs = nrPins;
                } else {
                    ios = nrPins;
                }
                map.setNrOfInports(inputs, labels);
                map.setNrOfOutports(outputs, labels);
                map.setNrOfInOutports(ios, labels);
            }
            if (attr == ATTR_DIR) {
                InstanceStateImpl stateImpl = instance.getComponent().getInstanceStateImpl();
                if (stateImpl == null) {
                    return;
                }
                CircuitState circuitState = stateImpl.getCircuitState();
                if (circuitState == null) {
                    return;
                }
                Circuit circuit = circuitState.getCircuit();
                if (circuit == null) {
                    return;
                }
                Project project = circuit.getProject();
                if (project == null) {
                    return;
                }
                Simulator simulator = project.getSimulator();
                if (simulator == null) {
                    return;
                }
                simulator.reset();
            }
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int[] yp;
        int[] xp;
        int p;
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        Bounds bds = painter.getBounds().rotate(Direction.EAST, facing, 0, 0);
        int w = bds.getWidth();
        int h = bds.getHeight();
        int x = painter.getLocation().getX();
        int y = painter.getLocation().getY();
        Graphics g = painter.getGraphics();
        g.translate(x, y);
        double rotate = 0.0;
        if (facing != Direction.EAST) {
            rotate = -facing.toRadians();
            ((Graphics2D)g).rotate(rotate);
        }
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.DARK_GRAY);
        int[] bx = new int[]{1, 1, 5, w - 6, w - 2, w - 2, 1};
        int[] by = new int[]{20, h - 8, h - 4, h - 4, h - 8, 20, 20};
        g.fillPolygon(bx, by, 6);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        GraphicsUtil.switchToWidth(g, 1);
        g.drawPolyline(bx, by, 7);
        int size = painter.getAttributeValue(ATTR_SIZE).getWidth();
        int nBus = (size - 1) / 64 + 1;
        if (!painter.getShowState()) {
            g.setColor(Color.LIGHT_GRAY);
            for (int i = 0; i < size; ++i) {
                g.fillRect(7 + i / 2 * 10, 25 + i % 2 * 10, 6, 6);
            }
        } else {
            PortState data = PortIo.getState(painter);
            for (int i = 0; i < size; ++i) {
                g.setColor(data.getPinColor(i, painter.getAttributeValue(ATTR_DIR)));
                g.fillRect(7 + i / 2 * 10, 25 + i % 2 * 10, 6, 6);
            }
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        AttributeOption dir = painter.getAttributeValue(ATTR_DIR);
        int px = dir == INOUTSE || dir == INOUTME ? 0 : 10;
        boolean py = false;
        for (p = 0; p < nBus; ++p) {
            if (dir == INOUTSE) {
                GraphicsUtil.switchToWidth(g, 3);
                if (p == 0) {
                    g.drawLine(px, 10, px + 6, 10);
                    px += 10;
                } else {
                    g.drawLine(px - 6, 10, px - 4, 10);
                }
            }
            if (dir == INOUTME) {
                GraphicsUtil.switchToWidth(g, 3);
                g.drawLine(px, 10, px + 6, 10);
                px += 10;
            }
            if (dir != OUTPUT && dir != INOUTSE && dir != INOUTME) continue;
            GraphicsUtil.switchToWidth(g, 3);
            g.drawLine(px, 0, px, 4);
            g.drawLine(px, 15, px, 20);
            GraphicsUtil.switchToWidth(g, 2);
            xp = new int[]{px, px - 4, px + 4, px};
            yp = new int[]{15, 5, 5, 15};
            g.drawPolyline(xp, yp, 4);
            px += 10;
        }
        for (p = 0; p < nBus; ++p) {
            if (dir != INPUT && dir != INOUTSE && dir != INOUTME) continue;
            GraphicsUtil.switchToWidth(g, 3);
            g.drawLine(px, 0, px, 5);
            g.drawLine(px, 16, px, 20);
            GraphicsUtil.switchToWidth(g, 2);
            xp = new int[]{px, px - 4, px + 4, px};
            yp = new int[]{6, 16, 16, 6};
            g.drawPolyline(xp, yp, 4);
            px += 10;
        }
        GraphicsUtil.switchToWidth(g, 1);
        ((Graphics2D)g).rotate(-rotate);
        g.translate(-x, -y);
        painter.drawPorts();
        g.setColor(painter.getAttributeValue(StdAttr.LABEL_COLOR));
        painter.drawLabel();
    }

    private static PortState getState(InstanceState state) {
        int size = state.getAttributeValue(ATTR_SIZE).getWidth();
        PortState data = (PortState)state.getData();
        if (data == null) {
            data = new PortState(size);
            state.setData(data);
            return data;
        }
        if (data.size != size) {
            data.resize(size);
        }
        return data;
    }

    @Override
    public void propagate(InstanceState state) {
        AttributeOption portType = state.getAttributeValue(ATTR_DIR);
        int nrOfPins = state.getAttributeValue(ATTR_SIZE).getWidth();
        PortState stateData = PortIo.getState(state);
        int currentPortIndex = 0;
        if (portType.equals(INOUTSE) || portType.equals(INOUTME) || portType.equals(OUTPUT)) {
            Value enableValue = state.getPortValue(currentPortIndex);
            if (portType.equals(INOUTSE) || portType.equals(INOUTME)) {
                ++currentPortIndex;
            }
            Value inputValue = state.getPortValue(currentPortIndex);
            int pinIndexCorrection = -64;
            for (int pinIndex = 0; pinIndex < nrOfPins; ++pinIndex) {
                if (pinIndex % 64 == 0) {
                    if (portType.equals(INOUTME) && pinIndex > 0) {
                        enableValue = state.getPortValue(currentPortIndex++);
                    }
                    inputValue = state.getPortValue(currentPortIndex++);
                    pinIndexCorrection += 64;
                }
                if (!portType.equals(OUTPUT)) {
                    int enableIndex = portType.equals(INOUTSE) ? 0 : pinIndex - pinIndexCorrection;
                    stateData.setEnableValue(pinIndex, enableValue.get(enableIndex));
                }
                stateData.setInputValue(pinIndex, inputValue.get(pinIndex - pinIndexCorrection));
            }
        }
        if (!portType.equals(OUTPUT)) {
            int nrOfRemainingPins = nrOfPins;
            int nrOfPinsInCurrentBus = Math.min(nrOfRemainingPins, 64);
            nrOfRemainingPins -= nrOfPinsInCurrentBus;
            Value[] outputValue = new Value[nrOfPinsInCurrentBus];
            int pinIndexCorrection = 0;
            for (int pinIndex = 0; pinIndex < nrOfPins; ++pinIndex) {
                if (pinIndex > 0 && pinIndex % 64 == 0) {
                    state.setPort(currentPortIndex++, Value.create(outputValue), 1);
                    nrOfPinsInCurrentBus = Math.min(nrOfRemainingPins, 64);
                    nrOfRemainingPins -= nrOfPinsInCurrentBus;
                    outputValue = new Value[nrOfPinsInCurrentBus];
                    pinIndexCorrection += 64;
                }
                outputValue[pinIndex - pinIndexCorrection] = stateData.getPinValue(pinIndex, portType);
            }
            state.setPort(currentPortIndex++, Value.create(outputValue), 1);
        }
    }

    public static class PortPoker
    extends InstancePoker {
        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            Location loc = state.getInstance().getLocation();
            int cx = e.getX() - loc.getX() - 7 + 2;
            int cy = e.getY() - loc.getY() - 25 + 2;
            if (cx < 0 || cy < 0) {
                return;
            }
            int i = cx / 10;
            int j = cy / 10;
            if (j > 1) {
                return;
            }
            int n = 2 * i + j;
            PortState data = PortIo.getState(state);
            if (n < 0 || n >= data.size) {
                return;
            }
            data.togglePokeValue(n);
            state.fireInvalidated();
        }
    }

    private static class PortState
    implements InstanceData,
    Cloneable {
        private final BitWidth BIT_WIDTH = BitWidth.create(1);
        private final ArrayList<Value> inputState;
        private final ArrayList<Value> pokeState;
        private final ArrayList<Value> enableState;
        private int size;

        public PortState(int size) {
            this.size = size;
            this.inputState = new ArrayList();
            this.pokeState = new ArrayList();
            this.enableState = new ArrayList();
            for (int pin = 0; pin < size; ++pin) {
                this.inputState.add(Value.createUnknown(this.BIT_WIDTH));
                this.pokeState.add(Value.createUnknown(this.BIT_WIDTH));
                this.enableState.add(Value.createKnown(this.BIT_WIDTH, 0L));
            }
        }

        public void resize(int newSize) {
            if (newSize == this.size) {
                return;
            }
            if (newSize > this.size) {
                for (int newPin = this.size; newPin < newSize; ++newPin) {
                    this.inputState.add(Value.createUnknown(this.BIT_WIDTH));
                    this.pokeState.add(Value.createUnknown(this.BIT_WIDTH));
                    this.enableState.add(Value.createKnown(this.BIT_WIDTH, 0L));
                }
            } else {
                while (this.inputState.size() > newSize) {
                    this.inputState.remove(this.inputState.size() - 1);
                    this.pokeState.remove(this.inputState.size() - 1);
                    this.enableState.remove(this.inputState.size() - 1);
                }
            }
            this.size = newSize;
        }

        public void togglePokeValue(int pinIndex) {
            if (pinIndex < 0 || pinIndex > this.size) {
                return;
            }
            Value pokeValue = this.pokeState.get(pinIndex).get(0);
            if (pokeValue.equals(Value.UNKNOWN)) {
                this.pokeState.set(pinIndex, Value.createKnown(this.BIT_WIDTH, 0L));
            } else if (pokeValue.equals(Value.FALSE)) {
                this.pokeState.set(pinIndex, Value.createKnown(this.BIT_WIDTH, 1L));
            } else {
                this.pokeState.set(pinIndex, Value.createUnknown(this.BIT_WIDTH));
            }
        }

        public void setInputValue(int pinIndex, Value value) {
            if (pinIndex < 0 || pinIndex > this.size) {
                return;
            }
            Value[] newValue = new Value[]{value};
            this.inputState.set(pinIndex, Value.create(newValue));
        }

        public Value getPinValue(int pinIndex, AttributeOption directionAttribute) {
            Value resultValue;
            if (pinIndex < 0 || pinIndex > this.size || directionAttribute == null) {
                return Value.ERROR;
            }
            if (directionAttribute.equals(OUTPUT)) {
                return this.inputState.get(pinIndex);
            }
            if (directionAttribute.equals(INPUT)) {
                return this.pokeState.get(pinIndex);
            }
            Value inputValue = this.inputState.get(pinIndex);
            Value pokeValue = this.pokeState.get(pinIndex);
            Value enableValue = this.enableState.get(pinIndex);
            Value value = resultValue = pokeValue.equals(Value.UNKNOWN) || pokeValue.equals(inputValue) ? inputValue : Value.ERROR;
            if (enableValue.equals(Value.UNKNOWN)) {
                return Value.ERROR;
            }
            return enableValue.equals(Value.TRUE) ? resultValue : pokeValue;
        }

        public void setEnableValue(int pinIndex, Value value) {
            if (pinIndex < 0 || pinIndex > this.size) {
                return;
            }
            this.enableState.set(pinIndex, value);
        }

        public Color getPinColor(int pinIndex, AttributeOption directionAttribute) {
            Value pinValue = this.getPinValue(pinIndex, directionAttribute);
            return pinValue.equals(Value.UNKNOWN) ? Color.LIGHT_GRAY : pinValue.getColor();
        }

        @Override
        public Object clone() {
            PortState other = new PortState(this.size);
            for (int pinIndex = 0; pinIndex < this.size; ++pinIndex) {
                other.inputState.set(pinIndex, this.inputState.get(pinIndex));
                other.enableState.set(pinIndex, this.enableState.get(pinIndex));
                other.pokeState.set(pinIndex, this.pokeState.get(pinIndex));
            }
            return other;
        }
    }
}

