/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.gui.icons.SevenSegmentIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.HexDigitHdlGeneratorFactory;
import com.cburch.logisim.std.io.HexDigitShape;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.io.SevenSegment;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import java.awt.Color;

public class HexDigit
extends InstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "Hex Digit Display";
    protected static final int HEX = 0;
    protected static final int DP = 1;
    static final NoDataDisplayMode NO_DATA_DISPLAY = NoDataDisplayMode.BLANK;
    public static final int SEG_A_MASK = 65536;
    public static final int SEG_B_MASK = 16;
    public static final int SEG_C_MASK = 1;
    public static final int SEG_D_MASK = 256;
    public static final int SEG_E_MASK = 0x100000;
    public static final int SEG_F_MASK = 0x1000000;
    public static final int SEG_G_MASK = 4096;

    public HexDigit() {
        super(_ID, Strings.S.getter("hexDigitComponent"), new HexDigitHdlGeneratorFactory(), true);
        this.setAttributes(new Attribute[]{IoLibrary.ATTR_ON_COLOR, IoLibrary.ATTR_OFF_COLOR, IoLibrary.ATTR_BACKGROUND, SevenSegment.ATTR_DP, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, StdAttr.MAPINFO}, new Object[]{new Color(240, 0, 0), SevenSegment.DEFAULT_OFF, IoLibrary.DEFAULT_BACKGROUND, Boolean.TRUE, "", Direction.EAST, StdAttr.DEFAULT_LABEL_FONT, false, new ComponentMapInformationContainer(0, 8, 0, null, SevenSegment.getLabels(), null)});
        this.setOffsetBounds(Bounds.create(-15, -60, 40, 60));
        this.setIcon(new SevenSegmentIcon(true));
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
    }

    private void updatePorts(Instance instance) {
        int nrPorts = instance.getAttributeValue(SevenSegment.ATTR_DP) != false ? 2 : 1;
        Port[] ps = new Port[nrPorts];
        ps[0] = new Port(0, 0, "input", 4);
        ps[0].setToolTip(Strings.S.getter("hexDigitDataTip"));
        if (nrPorts > 1) {
            ps[1] = new Port(20, 0, "input", 1);
            ps[1].setToolTip(Strings.S.getter("hexDigitDPTip"));
        }
        instance.setPorts(ps);
        instance.getAttributeValue(StdAttr.MAPINFO).setNrOfOutports(6 + nrPorts, SevenSegment.getLabels());
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.getAttributeSet().setValue(StdAttr.MAPINFO, new ComponentMapInformationContainer(0, 8, 0, null, SevenSegment.getLabels(), null));
        instance.addAttributeListener();
        this.updatePorts(instance);
        SevenSegment.computeTextField(instance);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.LABEL_LOC) {
            SevenSegment.computeTextField(instance);
        } else if (attr == SevenSegment.ATTR_DP) {
            this.updatePorts(instance);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        SevenSegment.drawBase(painter, painter.getAttributeValue(SevenSegment.ATTR_DP));
    }

    public static int getSegs(int value) {
        return switch (value) {
            case 0 -> 0x1110111;
            case 1 -> 17;
            case 2 -> 0x111110;
            case 3 -> 69905;
            case 4 -> 0x1001011;
            case 5 -> 0x1011101;
            case 6 -> 0x1111101;
            case 7 -> 65553;
            case 8 -> 0x1111111;
            case 9 -> 0x1011011;
            case 10 -> 0x1111011;
            case 11 -> 0x1101101;
            case 12 -> 0x1110100;
            case 13 -> 0x101111;
            case 14 -> 0x1111100;
            case 15 -> 0x1111000;
            case -1 -> {
                int v0 = switch (NO_DATA_DISPLAY.ordinal()) {
                    case 3 -> 0x1101011;
                    case 2 -> 0x1100111;
                    case 1 -> 0x100101;
                    default -> 0;
                };
                yield v0;
            }
            default -> 69888;
        };
    }

    @Override
    public void propagate(InstanceState state) {
        Value dpVal;
        int segs;
        int summary = 0;
        Value baseVal = state.getPortValue(0);
        if (baseVal == null) {
            baseVal = Value.createUnknown(BitWidth.create(4));
        }
        if (((segs = HexDigit.getSegs((int)baseVal.toLongValue())) & 1) != 0) {
            summary |= 4;
        }
        if ((segs & 0x10) != 0) {
            summary |= 2;
        }
        if ((segs & 0x100) != 0) {
            summary |= 8;
        }
        if ((segs & 0x1000) != 0) {
            summary |= 0x40;
        }
        if ((segs & 0x10000) != 0) {
            summary |= 1;
        }
        if ((segs & 0x100000) != 0) {
            summary |= 0x10;
        }
        if ((segs & 0x1000000) != 0) {
            summary |= 0x20;
        }
        if (state.getAttributeValue(SevenSegment.ATTR_DP).booleanValue() && (dpVal = state.getPortValue(1)) != null && (int)dpVal.toLongValue() == 1) {
            summary |= 0x80;
        }
        Integer value = summary;
        InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
        if (data == null) {
            state.setData(new InstanceDataSingleton(value));
        } else {
            data.setValue(value);
        }
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new HexDigitShape(x, y, path);
    }

    protected static enum NoDataDisplayMode {
        BLANK,
        u,
        U,
        H;

    }
}

