/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.std.io.DotMatrix;
import com.cburch.logisim.std.io.DotMatrixBase;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class DotMatrixHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    @Override
    public LineBuffer getInlinedCode(Netlist netlist, Long componentId, netlistComponent componentInfo, String circuitName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        boolean colBased = componentInfo.getComponent().getAttributeSet().getValue(DotMatrixBase.ATTR_INPUT_TYPE) == DotMatrixBase.INPUT_COLUMN;
        boolean rowBased = componentInfo.getComponent().getAttributeSet().getValue(DotMatrixBase.ATTR_INPUT_TYPE) == DotMatrixBase.INPUT_ROW;
        int rows = componentInfo.getComponent().getAttributeSet().getValue(DotMatrix.ATTR_MATRIX_ROWS).getWidth();
        int cols = componentInfo.getComponent().getAttributeSet().getValue(DotMatrix.ATTR_MATRIX_COLS).getWidth();
        HashMap<String, String> wires = new HashMap<String, String>();
        if (colBased) {
            for (int dotMatrixRow = 0; dotMatrixRow < rows; ++dotMatrixRow) {
                int ledMatrixRow = rows - dotMatrixRow - 1;
                for (int ledMatrixCol = 0; ledMatrixCol < cols; ++ledMatrixCol) {
                    String wire = rows == 1 ? Hdl.getNetName(componentInfo, ledMatrixCol, true, netlist) : Hdl.getBusEntryName(componentInfo, ledMatrixCol, true, dotMatrixRow, netlist);
                    int idx = ledMatrixRow * cols + ledMatrixCol + componentInfo.getLocalBubbleOutputStartId();
                    wires.put(LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", "logisimOutputBubbles", idx), wire);
                }
            }
        } else if (rowBased) {
            for (int ledMatrixRow = 0; ledMatrixRow < rows; ++ledMatrixRow) {
                for (int dotMatrixCol = 0; dotMatrixCol < cols; ++dotMatrixCol) {
                    int ledMatrixCol = cols - dotMatrixCol - 1;
                    String wire = cols == 1 ? Hdl.getNetName(componentInfo, ledMatrixRow, true, netlist) : Hdl.getBusEntryName(componentInfo, ledMatrixRow, true, ledMatrixCol, netlist);
                    int idx = ledMatrixRow * cols + dotMatrixCol + componentInfo.getLocalBubbleOutputStartId();
                    wires.put(LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", "logisimOutputBubbles", idx), wire);
                }
            }
        } else {
            for (int dotMatrixRow = 0; dotMatrixRow < rows; ++dotMatrixRow) {
                int ledMatrixRow = rows - dotMatrixRow - 1;
                for (int ledMatrixCol = 0; ledMatrixCol < cols; ++ledMatrixCol) {
                    String rowWire = rows == 1 ? Hdl.getNetName(componentInfo, 1, true, netlist) : Hdl.getBusEntryName(componentInfo, 1, true, dotMatrixRow, netlist);
                    String colWire = cols == 1 ? Hdl.getNetName(componentInfo, 0, true, netlist) : Hdl.getBusEntryName(componentInfo, 0, true, ledMatrixCol, netlist);
                    int idx = ledMatrixRow * cols + ledMatrixCol + componentInfo.getLocalBubbleOutputStartId();
                    wires.put(LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", "logisimOutputBubbles", idx), LineBuffer.formatHdl("{{1}}{{and}}{{2}}", rowWire, colWire));
                }
            }
        }
        Hdl.addAllWiresSorted(contents, wires);
        return contents;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return attrs.getValue(DotMatrixBase.ATTR_PERSIST) == 0;
    }
}

