/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.hdl.HdlModelListener;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.std.hdl.GenericInterfaceComponent;
import com.cburch.logisim.std.hdl.HdlContent;
import com.cburch.logisim.util.StringGetter;
import java.util.WeakHashMap;

public abstract class HdlCircuitComponent<C extends HdlContent>
extends GenericInterfaceComponent {
    protected final WeakHashMap<Instance, HdlCircuitListener> contentListeners = new WeakHashMap();
    protected final Attribute<C> contentAttr;

    public HdlCircuitComponent(String name, StringGetter displayName, HdlGeneratorFactory generator, boolean requiresGlobalClock, Attribute<C> contentAttr) {
        super(name, displayName, generator, requiresGlobalClock);
        this.contentAttr = contentAttr;
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        HdlContent content = (HdlContent)instance.getAttributeValue(this.contentAttr);
        HdlCircuitListener listener = new HdlCircuitListener(instance);
        this.contentListeners.put(instance, listener);
        content.addHdlModelListener(listener);
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    protected final String getGiAttributesName(AttributeSet attrs) {
        HdlContent content = (HdlContent)attrs.getValue(this.contentAttr);
        return content.getName();
    }

    @Override
    protected final HdlModel.PortDescription[] getGiAttributesInputs(AttributeSet attrs) {
        HdlContent content = (HdlContent)attrs.getValue(this.contentAttr);
        return content.getInputs();
    }

    @Override
    protected final HdlModel.PortDescription[] getGiAttributesOutputs(AttributeSet attrs) {
        HdlContent content = (HdlContent)attrs.getValue(this.contentAttr);
        return content.getOutputs();
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == this.contentAttr) {
            this.updatePorts(instance);
        }
    }

    static class HdlCircuitListener
    implements HdlModelListener {
        final Instance instance;

        HdlCircuitListener(Instance instance) {
            this.instance = instance;
        }

        @Override
        public void contentSet(HdlModel source) {
            this.instance.fireInvalidated();
            this.instance.recomputeBounds();
        }
    }
}

