/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.logisim.data.Value;
import java.util.Map;

public final class DenseLogicCircuit {
    public static final int LEV_NONE = 0;
    public static final int LEV_LOW = 1;
    public static final int LEV_HIGH = 2;
    public static final int LEV_ERR = 3;
    public static final int LEV_COUNT = 4;
    public static final Value[] LEV_TO_LS = new Value[]{Value.UNKNOWN, Value.FALSE, Value.TRUE, Value.ERROR};
    public static final int GATE_BUS = 0;
    public static final int GATE_TRIS = 1;
    public static final int GATE_TRISI = 2;
    public static final int GATE_AND = 3;
    public static final int GATE_OR = 4;
    public static final int GATE_XOR = 5;
    public static final int GATE_NAND = 6;
    public static final int GATE_NOR = 7;
    public static final int GATE_NXOR = 8;
    public static final int GATE_ANDNOT = 9;
    public static final int GATE_ORNOT = 10;
    public static final String[] GATE_TYPE_NAMES = new String[]{"BUS", "TRIS", "TRISI", "AND", "OR", "XOR", "NAND", "NOR", "NXOR", "ANDNOT", "ORNOT"};
    public static final int SQOP_DFF = 0;
    public static final int SQOP_LATCH = 1;
    public final int cellCount;
    public final int gateCount;
    private final byte[] cellPull;
    private final int updateQueueSize;
    private final int auxDataSize;
    private final byte[] gateTypes;
    private final int[] gateCellA;
    private final int[] gateCellB;
    private final int[] gateCellO;
    private final int[][] cellUpdateNotifiesGate;
    private final int[] sequentialScript;
    public final Map<String, Integer> symbolTable;

    public DenseLogicCircuit(byte[] cellPull, int[][] cellUpdateNotifiesGate, byte[] gateTypes, int[] gateCellA, int[] gateCellB, int[] gateCellO, int[] seq, int seqDataSize, Map<String, Integer> symbolTable) {
        this.cellCount = cellPull.length;
        this.cellPull = cellPull;
        this.gateCount = gateTypes.length;
        this.updateQueueSize = this.gateCount + 1;
        this.auxDataSize = this.updateQueueSize + seqDataSize;
        this.cellUpdateNotifiesGate = cellUpdateNotifiesGate;
        this.gateTypes = gateTypes;
        this.gateCellA = gateCellA;
        this.gateCellB = gateCellB;
        this.gateCellO = gateCellO;
        this.sequentialScript = seq;
        this.symbolTable = symbolTable;
    }

    public final void simulate(byte[] cells, int[] auxData) {
        this.simulateCombinatorial(cells, auxData);
        this.simulateSequential(cells, auxData);
        this.simulateCombinatorial(cells, auxData);
    }

    public final byte[] newCells() {
        return (byte[])this.cellPull.clone();
    }

    public final int[] newAuxData() {
        int[] dat = new int[this.auxDataSize];
        if (this.gateCount != 0) {
            for (int i = 0; i < this.gateCount - 1; ++i) {
                dat[i] = i + 1;
            }
            dat[this.gateCount - 1] = -1;
            dat[this.gateCount] = 0;
        } else {
            dat[this.gateCount] = -1;
        }
        return dat;
    }

    public final void setCell(int cell, byte value, byte[] cells, int[] auxData) {
        if (cells[cell] == value) {
            return;
        }
        cells[cell] = value;
        for (int g : this.cellUpdateNotifiesGate[cell]) {
            if (auxData[g] != -1) continue;
            auxData[g] = auxData[this.gateCount];
            auxData[this.gateCount] = g;
        }
    }

    private final void simulateCombinatorial(byte[] cells, int[] auxData) {
        long maxIterationCount = this.gateCount;
        maxIterationCount *= maxIterationCount;
        while (maxIterationCount > 0L) {
            --maxIterationCount;
            int gateToEval = auxData[this.gateCount];
            if (gateToEval == -1) break;
            auxData[this.gateCount] = auxData[gateToEval];
            auxData[gateToEval] = -1;
            int va = cells[this.gateCellA[gateToEval]];
            byte vb = cells[this.gateCellB[gateToEval]];
            int vo = 0;
            switch (this.gateTypes[gateToEval]) {
                case 0: {
                    vo = va | vb;
                    break;
                }
                case 1: {
                    if (vb != 2) break;
                    vo = va;
                    break;
                }
                case 2: {
                    if (vb == 2) break;
                    vo = va;
                    break;
                }
                case 3: {
                    vo = va == 2 && vb == 2 ? 2 : 1;
                    break;
                }
                case 4: {
                    vo = va == 2 || vb == 2 ? 2 : 1;
                    break;
                }
                case 5: {
                    vo = va == 2 ^ vb == 2 ? 2 : 1;
                    break;
                }
                case 6: {
                    vo = va == 2 && vb == 2 ? 1 : 2;
                    break;
                }
                case 7: {
                    vo = va == 2 || vb == 2 ? 1 : 2;
                    break;
                }
                case 8: {
                    vo = va == 2 ^ vb == 2 ? 1 : 2;
                    break;
                }
                case 9: {
                    vo = va == 2 && vb != 2 ? 2 : 1;
                    break;
                }
                case 10: {
                    vo = va == 2 || vb != 2 ? 2 : 1;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid gate opcode " + this.gateTypes[gateToEval]);
                }
            }
            int outCell = this.gateCellO[gateToEval];
            if (vo == 0) {
                vo = this.cellPull[outCell];
            }
            if (vo == cells[outCell]) continue;
            cells[outCell] = (byte)vo;
            for (int g : this.cellUpdateNotifiesGate[outCell]) {
                if (auxData[g] != -1) continue;
                auxData[g] = auxData[this.gateCount];
                auxData[this.gateCount] = g;
            }
        }
    }

    private final void simulateSequential(byte[] cells, int[] auxData) {
        int ptr = 0;
        block4: while (ptr < this.sequentialScript.length) {
            int seqType = this.sequentialScript[ptr++];
            switch (seqType) {
                case 0: {
                    byte newValue;
                    int xvNew;
                    int d = this.sequentialScript[ptr++];
                    int c = this.sequentialScript[ptr++];
                    int q = this.sequentialScript[ptr++];
                    int x = this.updateQueueSize + this.sequentialScript[ptr++];
                    int xvOld = auxData[x];
                    auxData[x] = xvNew = cells[c];
                    int newValueSrc = q;
                    if (xvNew == 2 && xvNew != xvOld) {
                        newValueSrc = d;
                    }
                    if (cells[q] == (newValue = (byte)(cells[newValueSrc] == 2 ? 2 : 1))) continue block4;
                    cells[q] = newValue;
                    for (int g : this.cellUpdateNotifiesGate[q]) {
                        if (auxData[g] != -1) continue;
                        auxData[g] = auxData[this.gateCount];
                        auxData[this.gateCount] = g;
                    }
                    continue block4;
                }
                case 1: {
                    byte newValue;
                    int d = this.sequentialScript[ptr++];
                    int e = this.sequentialScript[ptr++];
                    int q = this.sequentialScript[ptr++];
                    if (cells[e] != 2 || cells[q] == (newValue = (byte)(cells[d] == 2 ? 2 : 1))) continue block4;
                    cells[q] = newValue;
                    for (int g : this.cellUpdateNotifiesGate[q]) {
                        if (auxData[g] != -1) continue;
                        auxData[g] = auxData[this.gateCount];
                        auxData[this.gateCount] = g;
                    }
                    continue block4;
                }
                default: {
                    throw new RuntimeException("invalid seq. opcode " + seqType);
                }
            }
        }
    }
}

