/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.gui.CpuDrawSupport;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class TraceInfo {
    private final int pc;
    private final int instruction;
    private final String asm;
    private boolean error;

    public TraceInfo(int pc, int instruction, String asm, boolean error) {
        this.pc = pc;
        this.instruction = instruction;
        this.asm = asm;
        this.error = error;
    }

    public void setError() {
        this.error = true;
    }

    public void paint(Graphics2D g, int yOffset, boolean scale) {
        int blockWidth = CpuDrawSupport.getBlockWidth(g, scale);
        if (scale) {
            blockWidth = AppPreferences.getDownScaled(blockWidth);
        }
        int xOff = 5;
        this.paintBox(g, xOff, yOffset, this.pc, scale, blockWidth);
        this.paintBox(g, xOff += blockWidth + 5, yOffset, this.instruction, scale, blockWidth);
        g.setColor(this.error ? Color.RED : Color.BLACK);
        Font f = g.getFont();
        Font myFont = scale ? AppPreferences.getScaledFont(new Font("Monospaced", 0, 12).deriveFont(1)) : new Font("Monospaced", 0, 12).deriveFont(1);
        g.setFont(myFont);
        Bounds bds = CpuDrawSupport.getBounds(xOff += blockWidth + 5, yOffset + 15, 0, 0, scale);
        g.drawString(this.asm, bds.getX(), bds.getY());
        g.setFont(f);
    }

    private void paintBox(Graphics2D g, int x, int y, int value, boolean scale, int blockWidth) {
        g.setColor(Color.WHITE);
        Bounds bds = CpuDrawSupport.getBounds(x, y + 1, blockWidth, 18, scale);
        g.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        g.setColor(Color.BLACK);
        g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        g.setColor(this.error ? Color.RED : Color.DARK_GRAY);
        bds = CpuDrawSupport.getBounds(x + blockWidth / 2, y + 10, 0, 0, scale);
        GraphicsUtil.drawCenteredText(g, String.format("0x%08X", value), bds.getX(), bds.getY());
        g.setColor(Color.BLACK);
    }
}

