/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.log.LoggableContract;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstanceStateImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstanceLoggerAdapter
implements LoggableContract {
    static final Logger loggerS = LoggerFactory.getLogger(InstanceLoggerAdapter.class);
    private InstanceComponent comp;
    private InstanceLogger logger;
    private InstanceStateImpl state;

    public InstanceLoggerAdapter(InstanceComponent comp, Class<? extends InstanceLogger> loggerClass) {
        try {
            this.comp = comp;
            this.logger = loggerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.state = new InstanceStateImpl(null, comp);
        }
        catch (Exception t) {
            String className = loggerClass.getName();
            loggerS.error("Error while instantiating logger {}: {}", (Object)className, (Object)t.getClass().getName());
            String msg = t.getMessage();
            if (msg != null) {
                loggerS.error("  ({})", (Object)msg);
            }
            this.logger = null;
        }
    }

    @Override
    public String getLogName(Object option) {
        return this.logger == null ? null : this.logger.getLogName(this.state, option);
    }

    @Override
    public BitWidth getBitWidth(Object option) {
        return this.logger == null ? null : this.logger.getBitWidth(this.state, option);
    }

    @Override
    public boolean isInput(Object option) {
        return this.logger == null ? false : this.logger.isInput(this.state, option);
    }

    @Override
    public Object[] getLogOptions() {
        return this.logger == null ? null : this.logger.getLogOptions(this.state);
    }

    @Override
    public Value getLogValue(CircuitState circuitState, Object option) {
        if (this.logger != null) {
            if (this.state.getCircuitState() != circuitState) {
                this.state.repurpose(circuitState, this.comp);
            }
            return this.logger.getLogValue(this.state, option);
        }
        return Value.UNKNOWN;
    }
}

