/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitor;
import com.cburch.logisim.prefs.PrefMonitorKeyStroke;
import com.cburch.logisim.util.JAdjustableScroll;
import com.cburch.logisim.util.JHotkeyInput;
import com.cburch.logisim.util.TableLayout;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

class HotkeyOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    protected static List<PrefMonitor<KeyStroke>> hotkeys = new ArrayList<PrefMonitor<KeyStroke>>();
    private final List<JHotkeyInput> keyInputList;
    private final List<JLabel> keyLabels;
    private final JLabel menuKeyHeaderLabel;
    private final JLabel normalKeyHeaderLabel;
    private JHotkeyInput northBtn;
    private JHotkeyInput southBtn;
    private JHotkeyInput eastBtn;
    private JHotkeyInput westBtn;
    private final JButton resetBtn;
    private final JLabel orientDescLabel;
    private final JLabel orientNorthLabel;
    private final JLabel orientEastLabel;
    private final JLabel orientSouthLabel;
    private final JLabel orientWestLabel;
    private boolean preferredWidthSet = false;

    public HotkeyOptions(PreferencesFrame window) {
        super(window);
        int i;
        this.setLayout(new TableLayout(1));
        this.resetBtn = new JButton();
        this.resetBtn.addActionListener(e -> AppPreferences.resetHotkeys());
        this.add(this.resetBtn);
        this.add(new JLabel(" "));
        this.menuKeyHeaderLabel = new JLabel();
        this.add(this.menuKeyHeaderLabel);
        this.add(new JLabel(" "));
        JPanel menuKeyPanel = new JPanel();
        JAdjustableScroll menuKeyScrollPane = new JAdjustableScroll(menuKeyPanel);
        this.add(menuKeyScrollPane);
        this.add(new JLabel(" "));
        this.normalKeyHeaderLabel = new JLabel();
        this.add(this.normalKeyHeaderLabel);
        this.add(new JLabel(" "));
        JPanel normalKeyPanel = new JPanel();
        JAdjustableScroll normalKeyScrollPane = new JAdjustableScroll(normalKeyPanel);
        this.add(normalKeyScrollPane);
        menuKeyPanel.setMaximumSize(new Dimension(400, 400));
        menuKeyPanel.setLayout(new TableLayout(2));
        normalKeyPanel.setMaximumSize(new Dimension(400, 400));
        normalKeyPanel.setLayout(new TableLayout(2));
        Field[] fields = AppPreferences.class.getDeclaredFields();
        try {
            for (Field f : fields) {
                String name = f.getName();
                if (!name.contains("HOTKEY_")) continue;
                PrefMonitor keyStroke = (PrefMonitor)f.get(AppPreferences.class);
                hotkeys.add(keyStroke);
            }
        }
        catch (Exception e2) {
            AppPreferences.hotkeyReflectError(e2);
        }
        this.keyInputList = new ArrayList<JHotkeyInput>();
        this.keyLabels = new ArrayList<JLabel>();
        for (i = 0; i < hotkeys.size(); ++i) {
            this.keyInputList.add(new JHotkeyInput(window, ""));
            this.keyLabels.add(new JLabel());
        }
        for (i = 0; i < hotkeys.size(); ++i) {
            PrefMonitorKeyStroke prefKeyStroke = (PrefMonitorKeyStroke)hotkeys.get(i);
            if (hotkeys.get(i) == AppPreferences.HOTKEY_DIR_NORTH || hotkeys.get(i) == AppPreferences.HOTKEY_DIR_SOUTH || hotkeys.get(i) == AppPreferences.HOTKEY_DIR_EAST || hotkeys.get(i) == AppPreferences.HOTKEY_DIR_WEST) {
                if (hotkeys.get(i) == AppPreferences.HOTKEY_DIR_NORTH) {
                    this.northBtn = new JHotkeyInput(window, prefKeyStroke.getDisplayString());
                    this.keyInputList.set(i, this.northBtn);
                }
                if (hotkeys.get(i) == AppPreferences.HOTKEY_DIR_SOUTH) {
                    this.southBtn = new JHotkeyInput(window, prefKeyStroke.getDisplayString());
                    this.keyInputList.set(i, this.southBtn);
                }
                if (hotkeys.get(i) == AppPreferences.HOTKEY_DIR_EAST) {
                    this.eastBtn = new JHotkeyInput(window, prefKeyStroke.getDisplayString());
                    this.keyInputList.set(i, this.eastBtn);
                }
                if (hotkeys.get(i) == AppPreferences.HOTKEY_DIR_WEST) {
                    this.westBtn = new JHotkeyInput(window, prefKeyStroke.getDisplayString());
                    this.keyInputList.set(i, this.westBtn);
                }
                this.keyInputList.get(i).setEnabled(prefKeyStroke.canModify());
                this.keyInputList.get(i).setBoundKeyStroke(prefKeyStroke);
                continue;
            }
            this.keyLabels.get(i).setText(Strings.S.get(prefKeyStroke.getName()) + "  ");
            this.keyInputList.set(i, new JHotkeyInput(window, prefKeyStroke.getDisplayString()));
            this.keyInputList.get(i).setEnabled(prefKeyStroke.canModify());
            this.keyInputList.get(i).setBoundKeyStroke(prefKeyStroke);
            if (prefKeyStroke.needMetaKey().booleanValue()) {
                menuKeyPanel.add(this.keyLabels.get(i));
                menuKeyPanel.add(this.keyInputList.get(i));
                continue;
            }
            normalKeyPanel.add(this.keyLabels.get(i));
            normalKeyPanel.add(this.keyInputList.get(i));
        }
        normalKeyPanel.add(new JLabel(" "));
        normalKeyPanel.add(new JLabel(" "));
        this.orientDescLabel = new JLabel();
        normalKeyPanel.add(this.orientDescLabel);
        normalKeyPanel.add(new JLabel(" "));
        JPanel panelLeft = new JPanel();
        JPanel panelRight = new JPanel();
        panelLeft.setLayout(new TableLayout(3));
        panelRight.setLayout(new TableLayout(3));
        this.orientEastLabel = new JLabel();
        this.orientNorthLabel = new JLabel();
        this.orientSouthLabel = new JLabel();
        this.orientWestLabel = new JLabel();
        panelLeft.add(new JLabel(" "));
        panelLeft.add(this.orientNorthLabel);
        panelLeft.add(new JLabel(" "));
        panelLeft.add(this.orientWestLabel);
        panelLeft.add(this.orientSouthLabel);
        panelLeft.add(this.orientEastLabel);
        normalKeyPanel.add(panelLeft);
        panelRight.add(new JLabel(" "));
        panelRight.add(this.northBtn);
        panelRight.add(new JLabel(" "));
        panelRight.add(this.westBtn);
        panelRight.add(this.southBtn);
        panelRight.add(this.eastBtn);
        normalKeyPanel.add(panelRight);
        HotkeyOptions that = this;
        new Timer(200, e -> {
            int menuWidth = menuKeyPanel.getWidth();
            int normalWidth = normalKeyPanel.getWidth();
            if (normalWidth > 0 && (double)normalWidth < (double)that.getWidth() * 0.8 && !this.preferredWidthSet) {
                menuKeyScrollPane.preferredWidth = menuWidth + 40;
                menuKeyPanel.setPreferredSize(new Dimension(menuKeyPanel.getSize().width, menuKeyPanel.getPreferredSize().height));
                normalKeyScrollPane.preferredWidth = normalWidth + 40;
                normalKeyPanel.setPreferredSize(new Dimension(normalKeyPanel.getSize().width, normalKeyPanel.getPreferredSize().height));
                this.preferredWidthSet = true;
            }
        }).start();
        AppPreferences.getPrefs().addPreferenceChangeListener(evt -> {
            AppPreferences.hotkeySync();
            for (int i = 0; i < hotkeys.size(); ++i) {
                this.keyInputList.get(i).resetText(((PrefMonitorKeyStroke)hotkeys.get(i)).getDisplayString());
            }
            for (JHotkeyInput h : this.keyInputList) {
                h.exitEditMode();
            }
        });
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("hotkeyOptHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("hotkeyOptTitle");
    }

    @Override
    public void localeChanged() {
        this.menuKeyHeaderLabel.setText(Strings.S.get("hotkeyOptMenuKeyHeader", InputEvent.getModifiersExText(AppPreferences.hotkeyMenuMask)));
        this.normalKeyHeaderLabel.setText(Strings.S.get("hotkeyOptNormalKeyHeader", InputEvent.getModifiersExText(AppPreferences.hotkeyMenuMask)));
        this.resetBtn.setText(Strings.S.get("hotkeyOptResetBtn"));
        this.orientDescLabel.setText(Strings.S.get("hotkeyOptOrientDesc"));
        this.orientEastLabel.setText(" " + Strings.S.get("hotkeyDirEast") + " ");
        this.orientWestLabel.setText(" " + Strings.S.get("hotkeyDirWest") + " ");
        this.orientSouthLabel.setText(" " + Strings.S.get("hotkeyDirSouth") + " ");
        this.orientNorthLabel.setText(" " + Strings.S.get("hotkeyDirNorth") + " ");
        for (int i = 0; i < hotkeys.size(); ++i) {
            PrefMonitorKeyStroke prefKeyStroke = (PrefMonitorKeyStroke)hotkeys.get(i);
            if (hotkeys.get(i) == AppPreferences.HOTKEY_DIR_NORTH || hotkeys.get(i) == AppPreferences.HOTKEY_DIR_SOUTH || hotkeys.get(i) == AppPreferences.HOTKEY_DIR_EAST || hotkeys.get(i) == AppPreferences.HOTKEY_DIR_WEST) continue;
            this.keyLabels.get(i).setText(Strings.S.get(prefKeyStroke.getName()) + "  ");
        }
    }
}

