/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.gui.Strings;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class TickCounter
implements Simulator.Listener {
    private final DecimalFormat[] formatterWithDigits = new DecimalFormat[4];
    static final long NANOSECONDS_PER_SECONDS = 1000000000L;
    static final long[] hertzValue = new long[]{1L, 1000L, 1000000L};
    static final double[] hertzMinValue = new double[]{0.0, 999.5, 999500.0};
    static final String[] hertzKey = new String[]{"tickRateHz", "tickRateKHz", "tickRateMHz"};
    static final int HZ = 0;
    static final int KHZ = 1;
    static final int MHZ = 2;
    private HistoryData historyData = new HistoryData(false, 1.0);
    private final Object historyLock = new Object();
    private final PropagateData propagateData = new PropagateData();

    public TickCounter() {
        Object pattern = ".";
        for (int i = 0; i < 4; ++i) {
            this.formatterWithDigits[i] = new DecimalFormat((String)pattern);
            this.formatterWithDigits[i].setRoundingMode(RoundingMode.HALF_UP);
            pattern = (String)pattern + "0";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Simulator simulator) {
        Object object = this.historyLock;
        synchronized (object) {
            this.propagateData.clear();
            this.historyData = new HistoryData(simulator.isAutoTicking(), simulator.getTickFrequency() / 2.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTickRate() {
        double fullCyclesPerSecond;
        Object object = this.historyLock;
        synchronized (object) {
            if (!this.historyData.autoTicking) {
                return "";
            }
            fullCyclesPerSecond = this.historyData.getFullCyclesPerSecond();
        }
        int units = hertzMinValue[2] <= fullCyclesPerSecond ? 2 : (hertzMinValue[1] <= fullCyclesPerSecond ? 1 : 0);
        double displayNum = fullCyclesPerSecond / (double)hertzValue[units];
        int fractionalDigits = displayNum < 0.9995 ? 3 : (displayNum < 9.995 ? 2 : (displayNum < 99.95 ? 1 : 0));
        String display = this.formatterWithDigits[fractionalDigits].format(displayNum);
        return Strings.S.get(hertzKey[units], display);
    }

    @Override
    public void simulatorStateChanged(Simulator.Event e) {
        this.clear(e.getSource());
    }

    @Override
    public void simulatorReset(Simulator.Event e) {
        this.clear(e.getSource());
    }

    @Override
    public void propagationCompleted(Simulator.Event e) {
        if (e.didTick() && e.getSource().isAutoTicking()) {
            this.propagateData.propagateCompleted(System.nanoTime());
        }
    }

    private class HistoryData {
        private final boolean autoTicking;
        private final double requestedClockFrequency;
        private final long[] propagationValues = new long[3];
        private long startTime = 0L;
        private long processedTickCount = 0L;

        public HistoryData(boolean ticking, double requestedFrequency) {
            this.autoTicking = ticking;
            this.requestedClockFrequency = requestedFrequency;
        }

        public double getFullCyclesPerSecond() {
            double thresholdForWeightReduction;
            long elapsedTime;
            TickCounter.this.propagateData.getValues(this.propagationValues);
            long fullTickCount = this.propagationValues[0];
            long tickTime = this.propagationValues[1];
            long propStartTime = this.propagationValues[2];
            if (!this.autoTicking || fullTickCount < 1L) {
                return this.requestedClockFrequency;
            }
            if (this.startTime == 0L) {
                this.startTime = propStartTime;
            }
            if ((elapsedTime = tickTime - this.startTime) == 0L) {
                return this.requestedClockFrequency;
            }
            long tickCount = fullTickCount - this.processedTickCount;
            if (tickCount < 1L) {
                return this.requestedClockFrequency;
            }
            double ticksPerNanosecond = (double)tickCount / (double)elapsedTime;
            double ticksPerSecond = ticksPerNanosecond * 1.0E9;
            double fullCyclesPerSecond = ticksPerSecond / 2.0;
            double d = thresholdForWeightReduction = fullCyclesPerSecond > 50.0 ? fullCyclesPerSecond : 50.0;
            if ((double)tickCount > thresholdForWeightReduction) {
                long weightReductionTickCount = tickCount / 2L;
                this.processedTickCount += weightReductionTickCount;
                double nanoseconds = (double)weightReductionTickCount / ticksPerNanosecond;
                this.startTime += (long)nanoseconds;
            }
            return fullCyclesPerSecond;
        }
    }

    private static class PropagateData {
        private long fullTickCount = -1L;
        private long tickTime = 0L;
        private long startTime = 0L;

        private PropagateData() {
        }

        public synchronized void clear() {
            this.fullTickCount = -1L;
            this.startTime = 0L;
            this.tickTime = 0L;
        }

        public synchronized void getValues(long[] values) {
            values[0] = this.fullTickCount;
            values[1] = this.tickTime;
            values[2] = this.startTime;
        }

        public synchronized void propagateCompleted(long nanoTime) {
            long thisTick = this.fullTickCount + 1L;
            this.tickTime = nanoTime;
            this.fullTickCount = thisTick;
            if (thisTick == 0L) {
                this.startTime = nanoTime;
            }
        }
    }
}

