/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.AttrTableSetException;
import com.cburch.logisim.gui.generic.AttributeSetTableModel;
import com.cburch.logisim.proj.Project;

public class AttrTableCircuitModel
extends AttributeSetTableModel {
    private final Project proj;
    private final Circuit circ;

    public AttrTableCircuitModel(Project proj, Circuit circ) {
        super(circ.getStaticAttributes());
        this.proj = proj;
        this.circ = circ;
    }

    @Override
    public String getTitle() {
        return Strings.S.get("circuitAttrTitle", this.circ.getName());
    }

    @Override
    public void setValueRequested(Attribute<Object> attr, Object value) throws AttrTableSetException {
        if (!this.proj.getLogisimFile().contains(this.circ)) {
            String msg = Strings.S.get("cannotModifyCircuitError");
            throw new AttrTableSetException(msg);
        }
        CircuitMutation xn = new CircuitMutation(this.circ);
        xn.setForCircuit(attr, value);
        this.proj.doAction(xn.toAction(Strings.S.getter("changeCircuitAttrAction")));
    }
}

