/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.gui.generic.ProjectExplorerModel;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.base.HdlModelListener;
import com.cburch.logisim.vhdl.base.VhdlContent;
import com.cburch.logisim.vhdl.base.VhdlEntity;

public class ProjectExplorerToolNode
extends ProjectExplorerModel.Node<Tool>
implements CircuitListener,
HdlModelListener {
    private static final long serialVersionUID = 1L;
    private Circuit circuit;
    private VhdlContent vhdl;

    public ProjectExplorerToolNode(ProjectExplorerModel model, Tool tool) {
        super(model, tool);
        if (tool instanceof AddTool) {
            ComponentFactory factory = ((AddTool)tool).getFactory();
            if (factory instanceof SubcircuitFactory) {
                SubcircuitFactory sub = (SubcircuitFactory)factory;
                this.circuit = sub.getSubcircuit();
                this.circuit.addCircuitListener(this);
            } else if (factory instanceof VhdlEntity) {
                VhdlEntity vhdlEntity = (VhdlEntity)factory;
                this.vhdl = vhdlEntity.getContent();
                this.vhdl.addHdlModelListener(this);
            }
        }
    }

    @Override
    public void contentSet(HdlModel model) {
        this.fireNodeChanged();
    }

    @Override
    public void aboutToSave(HdlModel source) {
    }

    @Override
    public void displayChanged(HdlModel source) {
        this.fireNodeChanged();
    }

    @Override
    public void appearanceChanged(HdlModel source) {
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        int act = event.getAction();
        if (act == 0 || act == 9) {
            this.fireNodeChanged();
        }
    }

    ProjectExplorerToolNode create(Tool userObject) {
        return new ProjectExplorerToolNode(this.getModel(), userObject);
    }

    @Override
    void decommission() {
        if (this.circuit != null) {
            this.circuit.removeCircuitListener(this);
        }
        if (this.vhdl != null) {
            this.vhdl.removeHdlModelListener(this);
        }
    }
}

