/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.chrono;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.chrono.ChronoPanel;
import com.cburch.logisim.gui.chrono.PopupMenu;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.Signal;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class RightPanel
extends JPanel {
    private static final Font MSG_FONT = AppPreferences.getScaledFont(new Font("Serif", 2, 12));
    private static final Font TIME_FONT = new Font("Serif", 2, 9);
    private static final long serialVersionUID = 1L;
    private static final int WAVE_HEIGHT = 30;
    private static final int EXTRA_SPACE = 40;
    private static final int CURSOR_GAP = 20;
    private static final int TIMELINE_SPACING = 80;
    private final ChronoPanel chronoPanel;
    final DefaultListSelectionModel selectionModel;
    private Model model;
    private final ArrayList<Waveform> rows = new ArrayList();
    private int curX = Integer.MAX_VALUE;
    private long curT = Long.MAX_VALUE;
    private int zoom = 20;
    private double tickWidth = 20.0;
    private final int slope;
    private long timeStartDraw = 0L;
    private long timeNextDraw = 0L;
    private int width;
    private int height;
    private final MyListener myListener = new MyListener();
    private Timeline header;
    static final long[] unit = new long[]{10L, 20L, 25L, 50L};
    static final long[] subd = new long[]{4L, 4L, 5L, 5L};

    public RightPanel(ChronoPanel p, ListSelectionModel m) {
        this.chronoPanel = p;
        this.selectionModel = (DefaultListSelectionModel)m;
        this.model = p.getModel();
        this.slope = this.tickWidth < 12.0 ? (int)(this.tickWidth / 3.0) : 4;
        this.configure();
    }

    private void configure() {
        int n = this.model.getSignalCount();
        this.height = n * 30;
        this.setBackground(Color.WHITE);
        long timeScale = this.model.getTimeScale();
        long numTicks = (this.model.getEndTime() - this.model.getStartTime() + timeScale - 1L) / timeScale;
        this.width = (int)(this.tickWidth * (double)numTicks + 40.0 + 0.5);
        this.header = new Timeline();
        this.header.setPreferredSize(new Dimension(this.width, 20));
        this.addMouseListener(this.myListener);
        this.addMouseMotionListener(this.myListener);
        MouseAdapter tracker = new MouseAdapter(){

            void track(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    RightPanel.this.chronoPanel.setSignalCursorX(e.getX());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.track(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.track(e);
            }
        };
        this.header.addMouseListener(tracker);
        this.header.addMouseMotionListener(tracker);
        this.updateSignals();
    }

    public void setModel(Model m) {
        this.model = m;
        this.setSignalCursorX(Integer.MAX_VALUE);
        this.updateSignals();
    }

    int indexOf(Signal s) {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            Waveform waveForm = this.rows.get(i);
            if (waveForm.signal != s) continue;
            return i;
        }
        return -1;
    }

    public void updateSignals() {
        int n = this.model.getSignalCount();
        for (int i = 0; i < n; ++i) {
            Signal s = this.model.getSignal(i);
            int idx = this.indexOf(s);
            if (idx < 0) {
                this.rows.add(i, new Waveform(s));
                continue;
            }
            if (idx == i) continue;
            this.rows.add(i, this.rows.remove(idx));
        }
        if (this.rows.size() > n) {
            this.rows.subList(n, this.rows.size()).clear();
        }
        this.updateWaveforms(true);
    }

    public void updateWaveforms(boolean force) {
        long t0 = this.model.getStartTime();
        long t1 = this.model.getEndTime();
        if (!force && t0 == this.timeStartDraw && t1 == this.timeNextDraw) {
            return;
        }
        this.timeStartDraw = t0;
        this.timeNextDraw = t1;
        this.updateSize(true);
        this.flushWaveforms();
        this.header.repaint();
        this.repaint();
    }

    private void updateSize(boolean scrollRight) {
        boolean cursorVisible;
        long timeScale = this.model.getTimeScale();
        long numTicks = (this.timeNextDraw - this.timeStartDraw + timeScale - 1L) / timeScale;
        int m = this.model.getSignalCount();
        this.height = m * 30;
        this.width = (int)(this.tickWidth * (double)numTicks + 40.0 + 0.5);
        Dimension d = this.getPreferredSize();
        if (d.width == this.width && d.height == this.height) {
            return;
        }
        int oldWidth = d.width;
        JViewport v = this.chronoPanel.getRightViewport();
        JScrollBar sb = this.chronoPanel.getHorizontalScrollBar();
        Rectangle oldR = v == null ? null : v.getViewRect();
        d.width = this.width;
        d.height = this.height;
        this.header.setPreferredSize(new Dimension(this.width, 20));
        this.setPreferredSize(d);
        this.revalidate();
        if (!scrollRight || sb == null || v == null || sb.getValueIsAdjusting()) {
            return;
        }
        Rectangle r = v.getViewRect();
        boolean edgeVisible = oldWidth <= oldR.x + oldR.width;
        boolean bl = cursorVisible = oldR.x <= this.curX && this.curX <= oldR.x + oldR.width;
        if (cursorVisible && edgeVisible) {
            r.x = Math.max(oldR.x, this.curX - 20);
            r.width = Math.max(r.width, this.width - r.x);
            SwingUtilities.invokeLater(() -> this.scrollRectToVisible(r));
        } else if (edgeVisible) {
            r.x = Math.max(0, this.width - r.width);
            r.width = this.width - r.x;
            SwingUtilities.invokeLater(() -> this.scrollRectToVisible(r));
        }
    }

    static long snapToPixel(long delta, long t) {
        long s;
        for (s = 1L; s < t && (t + 10L * s - 1L) / (10L * s) * (10L * s) < t + delta; s *= 10L) {
        }
        return (t + s - 1L) / s * s;
    }

    public void setSignalCursorX(int posX) {
        double f = (double)this.model.getTimeScale() / this.tickWidth;
        this.curX = Math.max(0, posX);
        long t0 = this.model.getStartTime();
        this.curT = Math.max(t0, RightPanel.snapToPixel((long)f, (long)((double)t0 + (double)this.curX * f)));
        if (this.curT >= this.model.getEndTime()) {
            this.curX = Integer.MAX_VALUE;
            this.curT = Long.MAX_VALUE;
        }
        this.header.repaint();
        this.repaint();
    }

    public int getSignalCursorX() {
        long timeScale = this.model.getTimeScale();
        return this.curX == Integer.MAX_VALUE ? (int)((double)(this.model.getEndTime() - this.model.getStartTime() - 1L) * this.tickWidth / (double)timeScale) : this.curX;
    }

    public long getCurrentTime() {
        return this.curT == Long.MAX_VALUE ? this.model.getEndTime() - 1L : this.curT;
    }

    public void changeSpotlight(Signal oldSignal, Signal newSignal) {
        Waveform waveform;
        if (oldSignal != null) {
            waveform = this.rows.get(oldSignal.idx);
            waveform.flush();
            this.repaint(waveform.getBounds());
        }
        if (newSignal != null) {
            waveform = this.rows.get(newSignal.idx);
            waveform.flush();
            this.repaint(waveform.getBounds());
        }
    }

    public void updateSelected(int firstIdx, int lastIdx) {
        for (int i = firstIdx; i <= lastIdx; ++i) {
            Waveform waveform = this.rows.get(i);
            boolean selected = this.selectionModel.isSelectedIndex(i);
            if (selected == waveform.selected) continue;
            waveform.selected = selected;
            waveform.flush();
            this.repaint(waveform.getBounds());
        }
    }

    private void flushWaveforms() {
        for (Waveform w : this.rows) {
            w.flush();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D gfx = (Graphics2D)graphics;
        gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.setColor(Color.WHITE);
        gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        gfx.setColor(Color.BLACK);
        if (this.rows.isEmpty()) {
            Font f = gfx.getFont();
            gfx.setFont(MSG_FONT);
            String lines = Strings.S.get("NoSignalsSelected");
            int x = AppPreferences.getScaled(15);
            int y = AppPreferences.getScaled(15);
            for (String s : lines.split("\\|")) {
                gfx.drawString(s.trim(), x, y);
                y += AppPreferences.getScaled(14);
            }
            gfx.setFont(f);
            return;
        }
        if (this.width > 32000) {
            gfx.setColor(Color.BLACK);
            gfx.setFont(MSG_FONT);
            gfx.drawString("Oops! Chronogram is too large to display.", 15, 15);
            gfx.drawString("Try zooming out, or reset the simulation.", 15, 29);
        } else {
            for (Waveform w : this.rows) {
                w.paintWaveform(gfx);
            }
            this.paintCursor(gfx);
        }
    }

    private void paintCursor(Graphics2D g) {
        int x = this.getSignalCursorX();
        g.setColor(Color.RED);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(x, 0, x, this.getHeight());
    }

    public void zoom(int sens, int posX) {
        if (this.zoom + sens < 1 || this.zoom + sens > 40) {
            return;
        }
        long timeScale = this.model.getTimeScale();
        long t0 = this.model.getStartTime();
        long t1 = this.model.getEndTime();
        long numTicks = (t1 - t0 + timeScale - 1L) / timeScale;
        double newTickWidth = 20.0 * Math.pow(1.15, this.zoom + sens - 20);
        int newWidth = (int)(newTickWidth * (double)numTicks + 40.0 + 0.5);
        if (newWidth > 32000) {
            return;
        }
        double f = (double)timeScale / this.tickWidth;
        double mouseT = (double)t0 + (double)posX * f;
        JScrollBar sb = this.chronoPanel.getHorizontalScrollBar();
        int vx = posX - sb.getValue();
        this.zoom += sens;
        this.tickWidth = 20.0 * Math.pow(1.15, this.zoom - 20);
        double q = this.tickWidth / (double)timeScale;
        if (this.curX != Integer.MAX_VALUE) {
            this.curX = (int)Math.max(0.0, (double)(this.curT - t0) * q);
        }
        this.updateSize(false);
        SwingUtilities.invokeLater(() -> {
            int x = Math.max(0, (int)((mouseT - (double)t0) * q));
            int scrollPos = Math.min(sb.getMaximum(), Math.max(sb.getMinimum(), x - vx));
            sb.setValue(scrollPos);
        });
        this.flushWaveforms();
        this.header.repaint();
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JScrollPane jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jsp != null && this.header != null) {
            jsp.setColumnHeaderView(this.header);
        }
    }

    @Override
    public void removeNotify() {
        super.addNotify();
        JScrollPane jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jsp != null) {
            jsp.setColumnHeaderView(null);
        }
    }

    public JPanel getTimelineHeader() {
        return this.header;
    }

    private class MyListener
    extends MouseAdapter {
        boolean shiftDrag;
        boolean controlDrag;
        boolean subtracting;

        private MyListener() {
        }

        Signal getSignal(int y, boolean force) {
            int idx = y / 30;
            int n = RightPanel.this.model.getSignalCount();
            if (idx < 0 && force) {
                idx = 0;
            } else if (idx >= n && force) {
                idx = n - 1;
            }
            return idx < 0 || idx >= n ? null : RightPanel.this.model.getSignal(idx);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RightPanel.this.chronoPanel.changeSpotlight(this.getSignal(e.getY(), false));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RightPanel.this.chronoPanel.changeSpotlight(this.getSignal(e.getY(), false));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RightPanel.this.chronoPanel.changeSpotlight(null);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                RightPanel.this.chronoPanel.setSignalCursorX(e.getX());
                Signal signal = this.getSignal(e.getY(), false);
                if (signal == null) {
                    this.subtracting = false;
                    this.controlDrag = false;
                    this.shiftDrag = false;
                    return;
                }
                this.shiftDrag = e.isShiftDown();
                this.controlDrag = !this.shiftDrag && e.isControlDown();
                this.subtracting = this.controlDrag && RightPanel.this.selectionModel.isSelectedIndex(signal.idx);
                RightPanel.this.selectionModel.setValueIsAdjusting(true);
                if (this.shiftDrag) {
                    if (RightPanel.this.selectionModel.getAnchorSelectionIndex() < 0) {
                        RightPanel.this.selectionModel.setAnchorSelectionIndex(0);
                    }
                    RightPanel.this.selectionModel.setLeadSelectionIndex(signal.idx);
                } else if (this.controlDrag) {
                    if (this.subtracting) {
                        RightPanel.this.selectionModel.removeSelectionInterval(signal.idx, signal.idx);
                    } else {
                        RightPanel.this.selectionModel.addSelectionInterval(signal.idx, signal.idx);
                    }
                } else {
                    RightPanel.this.selectionModel.setSelectionInterval(signal.idx, signal.idx);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            RightPanel.this.chronoPanel.changeSpotlight(this.getSignal(e.getY(), false));
            if (SwingUtilities.isLeftMouseButton(e)) {
                RightPanel.this.chronoPanel.setSignalCursorX(e.getX());
                if (!RightPanel.this.selectionModel.getValueIsAdjusting()) {
                    return;
                }
                Signal signal = this.getSignal(e.getY(), false);
                if (signal == null) {
                    return;
                }
                RightPanel.this.selectionModel.setLeadSelectionIndex(signal.idx);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (!RightPanel.this.selectionModel.getValueIsAdjusting()) {
                    return;
                }
                Signal signal = this.getSignal(e.getY(), true);
                if (signal == null) {
                    return;
                }
                int idx = RightPanel.this.selectionModel.getAnchorSelectionIndex();
                if (idx < 0) {
                    idx = signal.idx;
                    RightPanel.this.selectionModel.setAnchorSelectionIndex(signal.idx);
                }
                RightPanel.this.selectionModel.setLeadSelectionIndex(signal.idx);
                this.subtracting = false;
                this.controlDrag = false;
                this.shiftDrag = false;
                RightPanel.this.selectionModel.setValueIsAdjusting(false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Signal signal;
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            Signal.List signals = RightPanel.this.chronoPanel.getLeftPanel().getSelectedValuesList();
            if (signals.isEmpty() && (signal = this.getSignal(e.getY(), false)) != null) {
                signals.add(signal);
            }
            PopupMenu m = new PopupMenu(RightPanel.this.chronoPanel, signals);
            m.doPop(e);
        }
    }

    private class Timeline
    extends JPanel {
        final Color borderColor = UIManager.getDefaults().getColor("InternalFrame.borderDarkShadow");
        final int height = 20;

        private Timeline() {
        }

        @Override
        public void paintComponent(Graphics gr) {
            Graphics2D g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth() - 1, 19);
            g.setColor(this.borderColor);
            g.drawLine(0, 19, this.getWidth() - 1, 19);
            this.paintScale(g);
            this.paintCursorWithLabel(g);
        }

        void paintCursorWithLabel(Graphics2D g) {
            int x = RightPanel.this.getSignalCursorX();
            long t = RightPanel.this.getCurrentTime();
            g.setFont(TIME_FONT);
            String s = Model.formatDuration(t);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(s, g);
            g.setColor(Color.YELLOW);
            int y = 9;
            g.fillRect(x + 2 + (int)r.getX() - 1, 9 + (int)r.getY() - 1, (int)r.getWidth() + 2, (int)r.getHeight() + 2);
            g.setColor(Color.RED);
            g.drawString(s, x + 2, 9);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(x, 0, x, 20);
        }

        void paintScale(Graphics2D g) {
            long timeScale = RightPanel.this.model.getTimeScale();
            double pixelPerTime = RightPanel.this.tickWidth / (double)timeScale;
            long b = 1L;
            int j = 0;
            while ((int)((double)(unit[j] * b) * pixelPerTime) < 80) {
                if (++j < unit.length) continue;
                b *= 10L;
                j = 0;
            }
            long divMajor = unit[j] * b;
            long numMinor = subd[j];
            long divMinor = divMajor / numMinor;
            Font f = g.getFont();
            g.setFont(TIME_FONT);
            long time0 = RightPanel.this.model.getStartTime();
            long timeL = time0 / divMajor * divMajor;
            int h = 18;
            g.setColor(Color.BLACK);
            g.drawLine(0, 18, RightPanel.this.width, 18);
            int i = 0;
            while (true) {
                long t;
                if ((t = timeL + divMinor * (long)i) >= time0) {
                    int x = (int)((double)(t - time0) * pixelPerTime);
                    if (x >= RightPanel.this.width) break;
                    if ((long)i % numMinor == 0L) {
                        if (x + 40 <= RightPanel.this.width) {
                            g.drawString(Model.formatDuration(t), x, 9);
                        }
                        g.drawLine(x, 12, x, 18);
                    } else {
                        g.drawLine(x, 16, x, 18);
                    }
                }
                ++i;
            }
            g.setFont(f);
        }
    }

    private class Waveform {
        private static final int HIGH = 2;
        private static final int LOW = 28;
        private static final int MID = 15;
        final Signal signal;
        private BufferedImage buf;
        boolean selected;

        public Waveform(Signal s) {
            this.signal = s;
        }

        Rectangle getBounds() {
            int y = 30 * this.signal.idx;
            return new Rectangle(0, y, RightPanel.this.width, 30);
        }

        private void drawSignal(Graphics2D g, boolean bold, Color[] colors) {
            g.setStroke(new BasicStroke(bold ? 2.0f : 1.0f));
            long t0 = RightPanel.this.model.getStartTime();
            Signal signal = this.signal;
            Objects.requireNonNull(signal);
            Signal.Iterator cur = new Signal.Iterator(signal, t0);
            FontMetrics fm = g.getFontMetrics();
            String max = this.signal.getFormattedMaxValue();
            String min = this.signal.getFormattedMinValue();
            int labelWidth = Math.max(fm.stringWidth(max), fm.stringWidth(min));
            double z = RightPanel.this.tickWidth / (double)RightPanel.this.model.getTimeScale();
            boolean prevHi = false;
            boolean prevLo = false;
            Color prevFill = null;
            while (cur.value != null) {
                Color lineColor;
                Color fillColor;
                String v = cur.getFormattedValue();
                int x0 = (int)(z * (double)(cur.time - t0));
                int x1 = (int)(z * (double)(cur.time + cur.duration - t0));
                boolean hi = true;
                boolean lo = true;
                if (v.contains("E")) {
                    fillColor = colors[3];
                    lineColor = colors[4];
                } else if (v.contains("x")) {
                    fillColor = colors[5];
                    lineColor = colors[6];
                } else if (v.equals(min)) {
                    hi = false;
                    fillColor = colors[1];
                    lineColor = colors[2];
                } else if (v.equals(max)) {
                    lo = false;
                    fillColor = colors[1];
                    lineColor = colors[2];
                } else {
                    fillColor = colors[1];
                    lineColor = colors[2];
                }
                if (prevFill != null) {
                    int xt = x0 + Math.min(RightPanel.this.slope, (x1 - x0) / 2);
                    if (xt == x0) {
                        if (hi) {
                            g.setColor(fillColor);
                            g.fillRect(x0, 2, x1 - x0 + 1, 27);
                        }
                        g.setColor(lineColor);
                        g.drawLine(x0, 2, x0, 28);
                        if (hi) {
                            g.drawLine(x0, 2, x1, 2);
                        }
                        if (lo) {
                            g.drawLine(x0, 28, x1, 28);
                        }
                    } else if (prevHi && prevLo && hi && lo) {
                        g.setColor(prevFill);
                        g.fillPolygon(new int[]{x0, x0 + (xt - x0) / 2, x0}, new int[]{2, 15, 29}, 3);
                        g.setColor(fillColor);
                        g.fillPolygon(new int[]{x0 + (xt - x0) / 2, xt, x1, x1, xt}, new int[]{15, 2, 2, 29, 29}, 5);
                        g.setColor(lineColor);
                        g.drawLine(x0, 2, xt, 28);
                        g.drawLine(x0, 28, xt, 2);
                        g.drawLine(xt, 2, x1, 2);
                        g.drawLine(xt, 28, x1, 28);
                    } else if (!hi) {
                        g.setColor(prevFill);
                        g.fillPolygon(new int[]{x0, xt, x0}, new int[]{2, 29, 29}, 3);
                        g.setColor(lineColor);
                        g.drawLine(x0, 2, xt, 28);
                        g.drawLine(prevLo ? x0 : xt, 28, x1, 28);
                    } else if (!lo) {
                        if (prevHi) {
                            g.setColor(prevFill);
                            g.fillPolygon(new int[]{x0, xt, x0}, new int[]{2, 2, 29}, 3);
                        }
                        g.setColor(fillColor);
                        g.fillPolygon(new int[]{x0, xt, x1, x1, x0}, new int[]{29, 2, 2, 29}, 4);
                        g.setColor(lineColor);
                        g.drawLine(x0, 28, xt, 2);
                        g.drawLine(prevHi ? x0 : xt, 2, x1, 2);
                    } else if (!prevHi) {
                        g.setColor(fillColor);
                        g.fillPolygon(new int[]{x0, xt, x1, x1, x0}, new int[]{29, 2, 2, 29}, 4);
                        g.setColor(lineColor);
                        g.drawLine(x0, 28, x1, 28);
                        g.drawLine(x0, 28, xt, 2);
                        g.drawLine(xt, 2, x1, 2);
                    } else if (!prevLo) {
                        g.setColor(prevFill);
                        g.fillPolygon(new int[]{x0, xt, x0}, new int[]{2, 29, 29}, 3);
                        g.setColor(fillColor);
                        g.fillPolygon(new int[]{x0, x1, x1, xt}, new int[]{2, 2, 29, 29}, 4);
                        g.setColor(lineColor);
                        g.drawLine(x0, 2, x1, 2);
                        g.drawLine(x0, 2, xt, 28);
                        g.drawLine(xt, 28, x1, 28);
                    } else {
                        System.out.println("huh? Unknown (and unhandled) case occured!");
                    }
                } else {
                    if (hi) {
                        g.setColor(fillColor);
                        g.fillRect(x0, 2, x1 - x0 + 1, 27);
                        g.setColor(lineColor);
                        g.drawLine(x0, 2, x1, 2);
                    }
                    if (lo) {
                        g.setColor(lineColor);
                        g.drawLine(x0, 28, x1, 28);
                    }
                }
                if (x1 - x0 > labelWidth) {
                    g.setColor(Color.BLACK);
                    g.drawString(v, x0 + 6, 20);
                }
                prevHi = hi;
                prevLo = lo;
                prevFill = fillColor;
                if (cur.advance()) continue;
                break;
            }
        }

        private void createOffscreen() {
            this.buf = (BufferedImage)RightPanel.this.createImage(RightPanel.this.width, 30);
            Graphics2D g = this.buf.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            boolean isBold = RightPanel.this.model.getSpotlight() == this.signal;
            Color[] colors = RightPanel.this.chronoPanel.rowColors(this.signal.info, this.selected);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, RightPanel.this.width, 1);
            g.fillRect(0, 28, RightPanel.this.width, 1);
            g.setColor(colors[0]);
            g.fillRect(0, 2, RightPanel.this.width, 26);
            g.setColor(Color.BLACK);
            this.drawSignal(g, isBold, colors);
            g.dispose();
        }

        public void paintWaveform(Graphics2D g) {
            if (this.buf == null) {
                this.createOffscreen();
            }
            int y = 30 * this.signal.idx;
            g.drawImage(this.buf, null, 0, y);
        }

        public void flush() {
            this.buf = null;
        }
    }
}

