/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.file;

import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoStandards;
import com.cburch.logisim.fpga.data.PullBehaviors;
import com.cburch.logisim.fpga.file.ImageXmlFactory;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.util.XmlUtil;
import java.awt.Image;
import java.io.File;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BoardWriterClass {
    static final Logger logger = LoggerFactory.getLogger(BoardWriterClass.class);
    public static final String BOARD_INFORMATION_SECTION_STRING = "BoardInformation";
    public static final String CLOCK_INFORMATION_SECTION_STRING = "ClockInformation";
    public static final String INPUT_SET_STRING = "InputPinSet";
    public static final String OUTPUT_SET_STRING = "OutputPinSet";
    public static final String IO_SET_STRING = "BiDirPinSet";
    public static final String RECT_SET_STRING = "Rect_x_y_w_h";
    public static final String LED_ARRAY_INFO_STRING = "LedArrayInfo";
    public static final String SCANNING_SEVEN_SEGMENT_INFO_STRING = "ScanningSevenSegInfo";
    public static final String MAP_ROTATION = "rotation";
    public static final String[] CLOCK_SECTION_STRINGS = new String[]{"Frequency", "FPGApin", "PullBehavior", "IOStandard"};
    public static final String FPGA_INFORMATION_SECTION_STRING = "FPGAInformation";
    public static final String[] FPGA_SECTION_STRINGS = new String[]{"Vendor", "Part", "Family", "Package", "Speedgrade", "USBTMC", "JTAGPos", "FlashName", "FlashPos"};
    public static final String UNUSED_PINS_STRING = "UnusedPins";
    public static final String COMPONENTS_SECTION_STRING = "IOComponents";
    public static final String LOCATION_X_STRING = "LocationX";
    public static final String LOCATION_Y_STRING = "LocationY";
    public static final String WIDTH_STRING = "Width";
    public static final String HEIGHT_STRING = "Height";
    public static final String PIN_LOCATION_STRING = "FPGAPinName";
    public static final String IMAGE_INFORMATION_STRING = "BoardPicture";
    public static final String MULTI_PIN_INFORMATION_STRING = "NrOfPins";
    public static final String MULTI_PIN_PREFIX_STRING = "FPGAPin_";
    public static final String LABEL_STRING = "Label";
    private DocumentBuilderFactory factory;
    private DocumentBuilder parser;
    private Document boardInfo;

    public BoardWriterClass(BoardInformation BoardInfo, Image BoardImage) {
        try {
            this.factory = XmlUtil.getHardenedBuilderFactory();
            this.parser = this.factory.newDocumentBuilder();
            this.boardInfo = this.parser.newDocument();
            Element root = this.boardInfo.createElement(BoardInfo.getBoardName());
            this.boardInfo.appendChild(root);
            Element fpgaInfo = this.boardInfo.createElement(BOARD_INFORMATION_SECTION_STRING);
            root.appendChild(fpgaInfo);
            Comment comment = this.boardInfo.createComment("This section decribes the FPGA and its clock");
            fpgaInfo.appendChild(comment);
            Element clkInfo = this.boardInfo.createElement(CLOCK_INFORMATION_SECTION_STRING);
            clkInfo.setAttribute(CLOCK_SECTION_STRINGS[0], Long.toString(BoardInfo.fpga.getClockFrequency()));
            Attr pin = this.boardInfo.createAttribute(CLOCK_SECTION_STRINGS[1]);
            pin.setValue(BoardInfo.fpga.getClockPinLocation().toUpperCase());
            clkInfo.setAttributeNode(pin);
            Attr pull = this.boardInfo.createAttribute(CLOCK_SECTION_STRINGS[2]);
            pull.setValue(PullBehaviors.BEHAVIOR_STRINGS[BoardInfo.fpga.getClockPull()]);
            clkInfo.setAttributeNode(pull);
            Attr ios = this.boardInfo.createAttribute(CLOCK_SECTION_STRINGS[3]);
            ios.setValue(IoStandards.BEHAVIOR_STRINGS[BoardInfo.fpga.getClockStandard()]);
            clkInfo.setAttributeNode(ios);
            fpgaInfo.appendChild(clkInfo);
            Element fpga = this.boardInfo.createElement(FPGA_INFORMATION_SECTION_STRING);
            fpga.setAttribute(FPGA_SECTION_STRINGS[0], VendorSoftware.VENDORS[BoardInfo.fpga.getVendor()].toUpperCase());
            Attr part = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[1]);
            part.setValue(BoardInfo.fpga.getPart());
            fpga.setAttributeNode(part);
            Attr tech = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[2]);
            tech.setValue(BoardInfo.fpga.getTechnology());
            fpga.setAttributeNode(tech);
            Attr box = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[3]);
            box.setValue(BoardInfo.fpga.getPackage());
            fpga.setAttributeNode(box);
            Attr speed = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[4]);
            speed.setValue(BoardInfo.fpga.getSpeedGrade());
            fpga.setAttributeNode(speed);
            Attr usbTmc = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[5]);
            usbTmc.setValue(BoardInfo.fpga.isUsbTmcDownloadRequired().toString());
            fpga.setAttributeNode(usbTmc);
            Attr jtagPos = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[6]);
            jtagPos.setValue(String.valueOf(BoardInfo.fpga.getFpgaJTAGChainPosition()));
            fpga.setAttributeNode(jtagPos);
            Attr flashName = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[7]);
            flashName.setValue(String.valueOf(BoardInfo.fpga.getFlashName()));
            fpga.setAttributeNode(flashName);
            Attr flashJtagPos = this.boardInfo.createAttribute(FPGA_SECTION_STRINGS[8]);
            flashJtagPos.setValue(String.valueOf(BoardInfo.fpga.getFlashJTAGChainPosition()));
            fpga.setAttributeNode(flashJtagPos);
            Element unusedPins = this.boardInfo.createElement(UNUSED_PINS_STRING);
            fpgaInfo.appendChild(fpga);
            unusedPins.setAttribute("PullBehavior", PullBehaviors.BEHAVIOR_STRINGS[BoardInfo.fpga.getUnusedPinsBehavior()]);
            fpgaInfo.appendChild(unusedPins);
            Element components = this.boardInfo.createElement(COMPONENTS_SECTION_STRING);
            root.appendChild(components);
            Comment compCmd = this.boardInfo.createComment("This section describes all Components present on the boards");
            components.appendChild(compCmd);
            for (FpgaIoInformationContainer comp : BoardInfo.getAllComponents()) {
                components.appendChild(comp.getDocumentElement(this.boardInfo));
            }
            ImageXmlFactory writer = new ImageXmlFactory();
            writer.createStream(BoardImage);
            Element boardPicture = this.boardInfo.createElement(IMAGE_INFORMATION_STRING);
            root.appendChild(boardPicture);
            Comment pictCmd = this.boardInfo.createComment("This section hold the board picture");
            boardPicture.appendChild(pictCmd);
            Element pictsize = this.boardInfo.createElement("PictureDimension");
            pictsize.setAttribute(WIDTH_STRING, Integer.toString(BoardImage.getWidth(null)));
            Attr height = this.boardInfo.createAttribute(HEIGHT_STRING);
            height.setValue(Integer.toString(BoardImage.getHeight(null)));
            pictsize.setAttributeNode(height);
            boardPicture.appendChild(pictsize);
            Element codeTable = this.boardInfo.createElement("CompressionCodeTable");
            boardPicture.appendChild(codeTable);
            codeTable.setAttribute("TableData", writer.getCodeTable());
            Element pixelData = this.boardInfo.createElement("PixelData");
            boardPicture.appendChild(pixelData);
            pixelData.setAttribute("PixelRGB", writer.getCompressedString());
        }
        catch (Exception e) {
            logger.error("Exceptions not handled yet in BoardWriterClass(), but got an exception: {}", (Object)e.getMessage());
        }
    }

    public void printXml() {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            aTransformer.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource(this.boardInfo);
            StreamResult dest = new StreamResult(new StringWriter());
            aTransformer.transform(src, dest);
            logger.info(dest.getWriter().toString());
        }
        catch (Exception e) {
            logger.error("Exceptions not handled yet in PrintXml(), but got an exception: {}", (Object)e.getMessage());
        }
    }

    public void printXml(String filename) {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            tranFactory.setAttribute("indent-number", 3);
            Transformer aTransformer = tranFactory.newTransformer();
            aTransformer.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource(this.boardInfo);
            File file = new File(filename);
            StreamResult dest = new StreamResult(file);
            aTransformer.transform(src, dest);
        }
        catch (Exception e) {
            logger.error("Exceptions not handled yet in PrintXml(), but got an exception: {}", (Object)e.getMessage());
        }
    }
}

