/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class ToolbarToolItem
implements ToolbarItem {
    private final AbstractTool tool;
    private final Icon icon;

    public ToolbarToolItem(AbstractTool tool) {
        this.tool = tool;
        this.icon = tool.getIcon();
    }

    @Override
    public Dimension getDimension(Object orientation) {
        if (this.icon == null) {
            return new Dimension(AppPreferences.getScaled(16), AppPreferences.getScaled(16));
        }
        return new Dimension(this.icon.getIconWidth() + 8, this.icon.getIconHeight() + 8);
    }

    public AbstractTool getTool() {
        return this.tool;
    }

    @Override
    public String getToolTip() {
        return this.tool.getDescription();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void paintIcon(Component destination, Graphics gfx) {
        if (this.icon == null) {
            gfx.setColor(new Color(255, 128, 128));
            gfx.fillRect(4, 4, 8, 8);
            gfx.setColor(Color.BLACK);
            gfx.drawLine(4, 4, 12, 12);
            gfx.drawLine(4, 12, 12, 4);
            gfx.drawRect(4, 4, 8, 8);
        } else {
            this.icon.paintIcon(destination, gfx, 4, 4);
        }
    }
}

