/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.actions.ModelAddAction;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.icons.DrawPolylineIcon;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.LineUtil;
import com.cburch.draw.shapes.Poly;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Location;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class PolyTool
extends AbstractTool {
    private static final int CLOSE_TOLERANCE = 2;
    private final boolean closed;
    private final DrawingAttributeSet attrs;
    private final List<Location> locations;
    private boolean active;
    private boolean mouseDown;
    private int lastMouseX;
    private int lastMouseY;

    public PolyTool(boolean closed, DrawingAttributeSet attrs) {
        this.closed = closed;
        this.attrs = attrs;
        this.active = false;
        this.locations = new ArrayList<Location>();
    }

    private CanvasObject commit(Canvas canvas) {
        if (!this.active) {
            return null;
        }
        Poly add = null;
        this.active = false;
        List<Location> locs = this.locations;
        for (int i = locs.size() - 2; i >= 0; --i) {
            if (!locs.get(i).equals(locs.get(i + 1))) continue;
            locs.remove(i);
        }
        if (locs.size() > 1) {
            CanvasModel model = canvas.getModel();
            add = new Poly(this.closed, locs);
            canvas.doAction(new ModelAddAction(model, add));
            this.repaintArea(canvas);
        }
        locs.clear();
        return add;
    }

    @Override
    public void draw(Canvas canvas, Graphics gfx) {
        if (this.active) {
            gfx.setColor(Color.GRAY);
            int size = this.locations.size();
            int[] xs = new int[size];
            int[] ys = new int[size];
            for (int i = 0; i < size; ++i) {
                Location loc = this.locations.get(i);
                xs[i] = loc.getX();
                ys[i] = loc.getY();
            }
            gfx.drawPolyline(xs, ys, size);
            int lastX = xs[xs.length - 1];
            int lastY = ys[ys.length - 1];
            gfx.fillOval(lastX - 2, lastY - 2, 4, 4);
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.getFillAttributes(this.attrs.getValue(DrawAttr.PAINT_TYPE));
    }

    @Override
    public Cursor getCursor(Canvas canvas) {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public Icon getIcon() {
        return new DrawPolylineIcon(this.closed);
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        int code = e.getKeyCode();
        if (this.active && this.mouseDown && (code == 16 || code == 17)) {
            this.updateMouse(canvas, this.lastMouseX, this.lastMouseY, e.getModifiersEx());
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        this.keyPressed(canvas, e);
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent e) {
        if (this.active) {
            char ch = e.getKeyChar();
            if (ch == '\u001b') {
                this.active = false;
                this.locations.clear();
                this.repaintArea(canvas);
                canvas.toolGestureComplete(this, null);
            } else if (ch == '\n') {
                CanvasObject add = this.commit(canvas);
                canvas.toolGestureComplete(this, add);
            }
        }
    }

    @Override
    public void mouseDragged(Canvas canvas, MouseEvent e) {
        this.updateMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
    }

    @Override
    public void mousePressed(Canvas canvas, MouseEvent e) {
        int mx = e.getX();
        int my = e.getY();
        this.lastMouseX = mx;
        this.lastMouseY = my;
        if ((e.getModifiersEx() & 0x80) != 0) {
            mx = canvas.snapX(mx);
            my = canvas.snapY(my);
        }
        if (this.active && e.getClickCount() > 1) {
            CanvasObject add = this.commit(canvas);
            canvas.toolGestureComplete(this, add);
            return;
        }
        Location loc = Location.create(mx, my, false);
        List<Location> locs = this.locations;
        if (!this.active) {
            locs.clear();
            locs.add(loc);
        }
        locs.add(loc);
        this.mouseDown = true;
        this.active = canvas.getModel() != null;
        this.repaintArea(canvas);
    }

    @Override
    public void mouseReleased(Canvas canvas, MouseEvent e) {
        if (this.active) {
            Location last;
            Location first;
            this.updateMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
            this.mouseDown = false;
            int size = this.locations.size();
            if (size >= 3 && (first = this.locations.get(0)).manhattanDistanceTo(last = this.locations.get(size - 1)) <= 2) {
                this.locations.remove(size - 1);
                CanvasObject add = this.commit(canvas);
                canvas.toolGestureComplete(this, add);
            }
        }
    }

    private void repaintArea(Canvas canvas) {
        canvas.repaint();
    }

    @Override
    public void toolDeselected(Canvas canvas) {
        CanvasObject add = this.commit(canvas);
        canvas.toolGestureComplete(this, add);
        this.repaintArea(canvas);
    }

    private void updateMouse(Canvas canvas, int mx, int my, int mods) {
        this.lastMouseX = mx;
        this.lastMouseY = my;
        if (this.active) {
            Location newLast;
            int index = this.locations.size() - 1;
            Location last = this.locations.get(index);
            if ((mods & 0x40) != 0 && index > 0) {
                Location nextLast = this.locations.get(index - 1);
                newLast = LineUtil.snapTo8Cardinals(nextLast, mx, my);
            } else {
                newLast = Location.create(mx, my, false);
            }
            if ((mods & 0x80) != 0) {
                int lastX = newLast.getX();
                int lastY = newLast.getY();
                lastX = canvas.snapX(lastX);
                lastY = canvas.snapY(lastY);
                newLast = Location.create(lastX, lastY, false);
            }
            if (!newLast.equals(last)) {
                this.locations.set(index, newLast);
                this.repaintArea(canvas);
            }
        }
    }
}

