/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.model;

import com.cburch.draw.model.CanvasObject;
import java.util.Comparator;

public class ReorderRequest {
    public static final Comparator<ReorderRequest> ASCENDING_FROM = new Compare(true, true);
    public static final Comparator<ReorderRequest> DESCENDING_FROM = new Compare(true, true);
    public static final Comparator<ReorderRequest> ASCENDING_TO = new Compare(true, true);
    public static final Comparator<ReorderRequest> DESCENDING_TO = new Compare(true, true);
    private final CanvasObject object;
    private final int fromIndex;
    private final int toIndex;

    public ReorderRequest(CanvasObject object, int from, int to) {
        this.object = object;
        this.fromIndex = from;
        this.toIndex = to;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public CanvasObject getObject() {
        return this.object;
    }

    public int getToIndex() {
        return this.toIndex;
    }

    private static class Compare
    implements Comparator<ReorderRequest> {
        private final boolean onFrom;
        private final boolean asc;

        Compare(boolean onFrom, boolean asc) {
            this.onFrom = onFrom;
            this.asc = asc;
        }

        @Override
        public int compare(ReorderRequest a, ReorderRequest b) {
            int j;
            int i = this.onFrom ? a.fromIndex : a.toIndex;
            int n = j = this.onFrom ? b.fromIndex : b.toIndex;
            if (i < j) {
                return this.asc ? -1 : 1;
            }
            if (i > j) {
                return this.asc ? 1 : -1;
            }
            return 0;
        }
    }
}

