/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class OutputStreamEscaper
extends OutputStream {
    protected static final String[] escapes = new String[]{"\\0", "\\a", "\\b", "\\t", "\\n", "\\v", "\\f", "\\r", "\\\"", "\\'", "\\?", "\\\\"};
    protected final Writer out;
    protected boolean preserveWhitespace;
    protected int textWidth;
    protected int col;
    protected char lastChar;
    protected final char[] sep = System.lineSeparator().toCharArray();

    public OutputStreamEscaper(Writer out) {
        this.out = out;
    }

    public OutputStreamEscaper(Writer out, boolean preserveWhitespace, int textWidth) {
        this.out = out;
        this.preserveWhitespace = preserveWhitespace;
        this.textWidth = textWidth;
    }

    public boolean preservesWhitespace() {
        return this.preserveWhitespace;
    }

    public void preserveWhitespace(boolean b) {
        this.preserveWhitespace = b;
    }

    public int textWidth() {
        return this.textWidth;
    }

    public void textWidth(int cols) {
        this.textWidth = cols;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.textWidth > 0 && this.lastChar != '\n') {
            this.out.write(this.sep);
            this.lastChar = (char)10;
            this.col = 0;
        }
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (32 <= b && b <= 126 && b != 92) {
            this.out.write(this.textWidth > 0 ? this.linebreak((char)b) : (char)b);
        } else if (this.preserveWhitespace && (b == 10 || b == 13 || b == 9)) {
            this.out.write(this.textWidth > 0 ? this.linebreak((char)b) : (char)b);
        } else {
            String s = OutputStreamEscaper.escapeCode(b);
            this.out.write(this.textWidth > 0 ? this.linebreak(s) : s);
        }
    }

    protected char linebreak(char b) throws IOException {
        if (b == '\r' || b == '\n') {
            this.col = 0;
        } else if (++this.col > this.textWidth) {
            this.out.write(this.sep);
            this.col = 1;
        }
        this.lastChar = b;
        return b;
    }

    protected String linebreak(String esc) throws IOException {
        int n = esc.length();
        if (this.col + n > this.textWidth) {
            this.out.write(this.sep);
            this.col = 0;
        }
        this.col += n;
        this.lastChar = '\u0000';
        return esc;
    }

    protected static String escapeCode(int b) {
        return switch (b) {
            case 0 -> escapes[0];
            case 7 -> escapes[1];
            case 8 -> escapes[2];
            case 9 -> escapes[3];
            case 10 -> escapes[4];
            case 11 -> escapes[5];
            case 12 -> escapes[6];
            case 13 -> escapes[7];
            case 34 -> escapes[8];
            case 39 -> escapes[9];
            case 63 -> escapes[10];
            case 92 -> escapes[11];
            default -> "\\x" + (char)OutputStreamEscaper.int2hex(b >>> 4 & 0xF) + (char)OutputStreamEscaper.int2hex(b & 0xF);
        };
    }

    public static byte int2hex(int n) {
        if (0 <= n && n <= 9) {
            return (byte)(48 + n);
        }
        if (10 <= n && n <= 15) {
            return (byte)(65 + (n - 10));
        }
        return -1;
    }

    public static String escape(char b) {
        return b >= ' ' && b <= '~' && b != '\\' ? String.valueOf(b) : OutputStreamEscaper.escapeCode(b);
    }

    public static String escape(String w) {
        StringWriter s = new StringWriter();
        for (int i = 0; i < w.length(); ++i) {
            char b = w.charAt(i);
            if (b >= ' ' && b <= '~' && b != '\\') {
                s.write(b);
                continue;
            }
            s.write(OutputStreamEscaper.escapeCode(b));
        }
        return s.toString();
    }
}

