/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.log.ComponentSelector;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.util.JDialogOk;
import com.cburch.logisim.util.StringGetter;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ClockSource
extends JDialogOk {
    private static final long serialVersionUID = 1L;
    private final ComponentSelector selector;
    private final JLabel msgLabel = new JLabel();
    private final StringGetter msg;
    SignalInfo item;
    public static final CycleInfo DEFAULT_CYCLE_INFO = new CycleInfo(1, 1, 0);

    public ClockSource(StringGetter msg, Circuit circ, boolean requireDriveable) {
        super("Clock Source Selection", true);
        this.msg = msg;
        this.selector = new ComponentSelector(circ, requireDriveable ? 3 : 2);
        JScrollPane explorerPane = new JScrollPane(this.selector, 22, 30);
        explorerPane.setPreferredSize(new Dimension(120, 200));
        this.msgLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        explorerPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10), explorerPane.getBorder()));
        this.getContentPane().add((Component)this.msgLabel, "North");
        this.getContentPane().add((Component)explorerPane, "Center");
        this.localeChanged();
        this.setMinimumSize(new Dimension(200, 300));
        this.setPreferredSize(new Dimension(300, 400));
        this.pack();
    }

    public void localeChanged() {
        this.selector.localeChanged();
        this.msgLabel.setText("<html>" + this.msg.toString() + "</html>");
    }

    @Override
    public void okClicked() {
        SignalInfo.List list = this.selector.getSelectedItems();
        if (list == null || list.size() != 1) {
            return;
        }
        this.item = (SignalInfo)list.get(0);
    }

    public static com.cburch.logisim.comp.Component doClockDriverDialog(Circuit circ) {
        ClockSource dialog = new ClockSource(Strings.S.getter("selectClockDriverMessage"), circ, true);
        dialog.setVisible(true);
        return dialog.item == null ? null : dialog.item.getComponent();
    }

    public static SignalInfo doClockMissingObserverDialog(Circuit circ) {
        ClockSource dialog = new ClockSource(Strings.S.getter("selectClockMissingMessage"), circ, false);
        dialog.setVisible(true);
        return dialog.item;
    }

    public static SignalInfo doClockMultipleObserverDialog(Circuit circ) {
        ClockSource dialog = new ClockSource(Strings.S.getter("selectClockMultipleMessage"), circ, false);
        dialog.setVisible(true);
        return dialog.item;
    }

    public static SignalInfo doClockObserverDialog(Circuit circ) {
        ClockSource dialog = new ClockSource(Strings.S.getter("selectClockObserverMessage"), circ, false);
        dialog.setVisible(true);
        return dialog.item;
    }

    public static CycleInfo getCycleInfo(SignalInfo clockSource) {
        com.cburch.logisim.comp.Component clk = clockSource.getComponent();
        if (clk.getFactory() instanceof Clock) {
            Integer hi = clk.getAttributeSet().getValue(Clock.ATTR_HIGH);
            Integer lo = clk.getAttributeSet().getValue(Clock.ATTR_LOW);
            Integer phase = clk.getAttributeSet().getValue(Clock.ATTR_PHASE);
            return new CycleInfo(hi, lo, phase);
        }
        return DEFAULT_CYCLE_INFO;
    }

    public static class CycleInfo {
        public final int hi;
        public final int lo;
        public final int phase;
        public final int ticks;

        public CycleInfo(int h, int l, int p) {
            this.hi = h;
            this.lo = l;
            this.phase = p;
            this.ticks = this.hi + this.lo;
        }
    }
}

