/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.file.LibraryManager;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.file.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.std.base.Text;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.LibraryTools;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.vhdl.base.VhdlContent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class LogisimFileActions {
    private LogisimFileActions() {
    }

    public static Action addVhdl(VhdlContent vhdl) {
        return new AddVhdl(vhdl);
    }

    public static Action addCircuit(Circuit circuit) {
        return new AddCircuit(circuit);
    }

    public static Action mergeFile(LogisimFile mergelib, LogisimFile source) {
        return new MergeFile(mergelib, source);
    }

    public static Action loadLibraries(Library[] libs, LogisimFile source) {
        return new LoadLibraries(libs, source);
    }

    public static Action loadLibrary(Library lib, LogisimFile source) {
        return new LoadLibraries(new Library[]{lib}, source);
    }

    public static Action moveCircuit(AddTool tool, int toIndex) {
        return new MoveCircuit(tool, toIndex);
    }

    public static Action removeCircuit(Circuit circuit) {
        return new RemoveCircuit(circuit);
    }

    public static Action removeVhdl(VhdlContent vhdl) {
        return new RemoveVhdl(vhdl);
    }

    public static Action revertDefaults() {
        return new RevertDefaults();
    }

    public static Action setMainCircuit(Circuit circuit) {
        return new SetMainCircuit(circuit);
    }

    public static Action unloadLibraries(Library[] libs) {
        return new UnloadLibraries(libs);
    }

    public static Action unloadLibrary(Library lib) {
        return new UnloadLibraries(new Library[]{lib});
    }

    private static class AddVhdl
    extends Action {
        private final VhdlContent vhdl;

        AddVhdl(VhdlContent vhdl) {
            this.vhdl = vhdl;
        }

        @Override
        public void doIt(Project proj) {
            proj.getLogisimFile().addVhdlContent(this.vhdl);
        }

        @Override
        public String getName() {
            return Strings.S.get("addVhdlAction");
        }

        @Override
        public void undo(Project proj) {
            proj.getLogisimFile().removeVhdl(this.vhdl);
        }
    }

    private static class AddCircuit
    extends Action {
        private final Circuit circuit;

        AddCircuit(Circuit circuit) {
            this.circuit = circuit;
        }

        @Override
        public void doIt(Project proj) {
            proj.getLogisimFile().addCircuit(this.circuit);
        }

        @Override
        public String getName() {
            return Strings.S.get("addCircuitAction");
        }

        @Override
        public void undo(Project proj) {
            proj.getLogisimFile().removeCircuit(this.circuit);
        }
    }

    private static class MergeFile
    extends Action {
        private final ArrayList<Circuit> mergedCircuits = new ArrayList();
        private final ArrayList<File> jarLibs = new ArrayList();
        private final ArrayList<File> logiLibs = new ArrayList();

        MergeFile(LogisimFile mergelib, LogisimFile source) {
            HashMap<String, Library> libNames = new HashMap<String, Library>();
            HashSet<String> toolList = new HashSet<String>();
            HashMap<String, String> errors = new HashMap<String, String>();
            boolean canContinue = true;
            for (Library lib : source.getLibraries()) {
                LibraryTools.buildLibraryList(lib, libNames);
            }
            LibraryTools.buildToolList((Library)source, toolList);
            LibraryTools.removePresentLibraries(mergelib, libNames, false);
            if (LibraryTools.isLibraryConform(mergelib, new HashSet<String>(), new HashSet<String>(), errors)) {
                List<String> ret;
                for (Library lib : mergelib.getLibraries()) {
                    HashSet<String> newToolList = new HashSet<String>();
                    LibraryTools.buildToolList(lib, newToolList);
                    ret = LibraryTools.libraryCanBeMerged(toolList, newToolList);
                    if (!ret.isEmpty()) {
                        String Location2 = "";
                        Map<String, String> toolNames = LibraryTools.getToolLocation(source, "", ret);
                        for (String key : toolNames.keySet()) {
                            Object solStr = Strings.S.get("LibMergeFailure2") + " a) ";
                            String errLoc = toolNames.get(key);
                            String[] errParts = errLoc.split("->");
                            solStr = errParts.length > 1 ? ((String)solStr).concat(Strings.S.get("LibMergeFailure4", errParts[1])) : ((String)solStr).concat(Strings.S.get("LibMergeFailure3", key));
                            solStr = ((String)solStr).concat(" " + Strings.S.get("LibMergeFailure5") + " b) ");
                            solStr = ((String)solStr).concat(Strings.S.get("LibMergeFailure6", lib.getName()));
                            errors.put((String)solStr, Strings.S.get("LibMergeFailure1", lib.getName(), key));
                        }
                        canContinue = false;
                    }
                    String[] splits = mergelib.getLoader().getDescriptor(lib).split("#");
                    File theFile = mergelib.getLoader().getFileFor(splits[1], null);
                    if ("file".equals(splits[0])) {
                        this.logiLibs.add(theFile);
                        continue;
                    }
                    if (!"jar".equals(splits[0])) continue;
                    this.jarLibs.add(theFile);
                }
                if (!canContinue) {
                    LibraryTools.showErrors(mergelib.getName(), errors);
                    this.logiLibs.clear();
                    this.jarLibs.clear();
                    return;
                }
                for (Circuit circ : mergelib.getCircuits()) {
                    String circName = circ.getName().toUpperCase();
                    if (toolList.contains(circName)) {
                        int Reponse;
                        ret = new ArrayList<String>();
                        ((ArrayList)ret).add(circName);
                        Map<String, String> toolNames = LibraryTools.getToolLocation(source, "", ret);
                        for (String key : toolNames.keySet()) {
                            String errLoc = toolNames.get(key);
                            String[] errParts = errLoc.split("->");
                            if (errParts.length <= 1) continue;
                            Object solStr = Strings.S.get("LibMergeFailure2") + " a) ";
                            solStr = ((String)solStr).concat(Strings.S.get("LibMergeFailure4", errParts[1]));
                            solStr = ((String)solStr).concat(" " + Strings.S.get("LibMergeFailure5") + " b) ");
                            solStr = ((String)solStr).concat(Strings.S.get("LibMergeFailure8", circ.getName()));
                            errors.put((String)solStr, Strings.S.get("LibMergeFailure7", key, errParts[1]));
                            canContinue = false;
                        }
                        if (!canContinue) continue;
                        Circuit circ1 = LibraryTools.getCircuitFromLibs(source, circName);
                        if (circ1 == null) {
                            OptionPane.showMessageDialog(null, "Fatal internal error: Cannot find a referenced circuit", "LogosimFileAction:", 0);
                            canContinue = false;
                            continue;
                        }
                        if (this.areCircuitsEqual(circ1, circ) || (Reponse = OptionPane.showConfirmDialog(null, Strings.S.get("FileMergeQuestion", circ.getName()), Strings.S.get("FileMergeTitle"), 0)) != 0) continue;
                        this.mergedCircuits.add(circ);
                        continue;
                    }
                    this.mergedCircuits.add(circ);
                }
                if (!canContinue) {
                    LibraryTools.showErrors(mergelib.getName(), errors);
                    this.logiLibs.clear();
                    this.jarLibs.clear();
                    this.mergedCircuits.clear();
                    return;
                }
            } else {
                LibraryTools.showErrors(mergelib.getName(), errors);
            }
        }

        private boolean areCircuitsEqual(Circuit orig, Circuit newone) {
            HashMap<Location, Component> origComps = new HashMap<Location, Component>();
            HashMap<Location, Component> newComps = new HashMap<Location, Component>();
            for (Wire wire : orig.getWires()) {
                origComps.put(wire.getLocation(), wire);
            }
            for (Component component : orig.getNonWires()) {
                origComps.put(component.getLocation(), component);
            }
            for (Wire wire : newone.getWires()) {
                newComps.put(wire.getLocation(), wire);
            }
            for (Component component : newone.getNonWires()) {
                newComps.put(component.getLocation(), component);
            }
            Iterator it = newComps.keySet().iterator();
            while (it.hasNext()) {
                Location location = (Location)it.next();
                if (!origComps.containsKey(location)) continue;
                Component comp1 = (Component)newComps.get(location);
                Component comp2 = (Component)newComps.get(location);
                if (!comp1.getFactory().getName().equals(comp2.getFactory().getName())) continue;
                if ("Wire".equals(comp1.getFactory().getName())) {
                    Wire wire1 = (Wire)comp1;
                    Wire wire2 = (Wire)comp2;
                    if (wire1.overlaps(wire2, true)) {
                        it.remove();
                        origComps.remove(location);
                        continue;
                    }
                    System.out.println("No Wire Overlap");
                    continue;
                }
                if (comp1.getAttributeSet().equals(comp2.getAttributeSet())) {
                    it.remove();
                    origComps.remove(location);
                    continue;
                }
                System.out.println("Different component");
            }
            return origComps.isEmpty() && newComps.isEmpty();
        }

        @Override
        public void doIt(Project proj) {
            CircuitMutation result;
            Loader loader = proj.getLogisimFile().getLoader();
            for (File jarLib : this.jarLibs) {
                Library lib;
                String className = null;
                try (JarFile jarFile2 = new JarFile(jarLib);){
                    Manifest manifest = jarFile2.getManifest();
                    className = manifest.getMainAttributes().getValue("Library-Class");
                }
                catch (IOException jarFile2) {
                    // empty catch block
                }
                if (className == null && (className = OptionPane.showInputDialog(proj.getFrame(), Strings.S.get("jarClassNamePrompt"), Strings.S.get("jarClassNameTitle"), 3)) == null || (lib = loader.loadJarLibrary(jarLib, className)) == null) continue;
                proj.doAction(LogisimFileActions.loadLibrary(lib, proj.getLogisimFile()));
            }
            this.jarLibs.clear();
            for (File logiLib : this.logiLibs) {
                Library put = loader.loadLogisimLibrary(logiLib);
                if (put == null) continue;
                proj.doAction(LogisimFileActions.loadLibrary(put, proj.getLogisimFile()));
            }
            this.logiLibs.clear();
            for (Circuit circ : this.mergedCircuits) {
                Circuit newCircuit = null;
                boolean replace = false;
                for (Circuit circs : proj.getLogisimFile().getCircuits()) {
                    if (!circs.getName().equalsIgnoreCase(circ.getName())) continue;
                    newCircuit = circs;
                    replace = true;
                }
                if (newCircuit == null) {
                    newCircuit = new Circuit(circ.getName(), proj.getLogisimFile(), proj);
                }
                CircuitAttributes.copyStaticAttributes(newCircuit.getStaticAttributes(), circ.getStaticAttributes());
                result = new CircuitMutation(newCircuit);
                if (replace) {
                    result.clear();
                }
                for (Component comp : circ.getNonWires()) {
                    if (!(comp.getFactory() instanceof Pin)) continue;
                    result.add(Pin.FACTORY.createComponent(comp.getLocation(), (AttributeSet)comp.getAttributeSet().clone()));
                }
                for (Wire wir : circ.getWires()) {
                    result.add(Wire.create(wir.getEnd0(), wir.getEnd1()));
                }
                if (!replace) {
                    result.execute();
                    proj.doAction(LogisimFileActions.addCircuit(newCircuit));
                    continue;
                }
                proj.doAction(result.toAction(Strings.S.getter("replaceCircuitAction")));
            }
            HashMap<String, AddTool> availableTools = new HashMap<String, AddTool>();
            LibraryTools.buildToolList((Library)proj.getLogisimFile(), availableTools);
            for (Circuit circ : this.mergedCircuits) {
                Circuit newCirc = proj.getLogisimFile().getCircuit(circ.getName());
                if (newCirc == null) continue;
                result = new CircuitMutation(newCirc);
                for (Component comp : circ.getNonWires()) {
                    if (comp.getFactory() instanceof Pin) continue;
                    AddTool current = availableTools.get(comp.getFactory().getName().toUpperCase());
                    if (current != null) {
                        ComponentFactory factory = current.getFactory();
                        if (factory instanceof SubcircuitFactory) {
                            SubcircuitFactory subcirc = (SubcircuitFactory)factory;
                            AttributeSet newAttrs = factory.createAttributeSet();
                            CircuitAttributes.copyInto(comp.getAttributeSet(), newAttrs);
                            result.add(factory.createComponent(comp.getLocation(), newAttrs));
                            continue;
                        }
                        result.add(factory.createComponent(comp.getLocation(), (AttributeSet)comp.getAttributeSet().clone()));
                        continue;
                    }
                    if ("Text".equals(comp.getFactory().getName())) {
                        result.add(Text.FACTORY.createComponent(comp.getLocation(), (AttributeSet)comp.getAttributeSet().clone()));
                        continue;
                    }
                    System.out.println("Not found:" + comp.getFactory().getName());
                }
                proj.doAction(result.toAction(Strings.S.getter("replaceCircuitAction")));
            }
            for (Circuit circ : this.mergedCircuits) {
                if (!circ.getAppearance().hasCustomAppearance()) continue;
                Circuit newCirc = proj.getLogisimFile().getCircuit(circ.getName());
                newCirc.getAppearance().repairCustomAppearance(circ.getAppearance().getCustomObjectsFromBottom(), proj, newCirc);
            }
            this.mergedCircuits.clear();
        }

        @Override
        public String getName() {
            return Strings.S.get("mergeFileAction");
        }

        @Override
        public boolean isModification() {
            return false;
        }

        @Override
        public void undo(Project proj) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LoadLibraries
    extends Action {
        private final List<Library> mergedLibs = new ArrayList<Library>();
        private final Set<String> baseLibsToEnable = new HashSet<String>();

        LoadLibraries(Library[] libs, LogisimFile source) {
            HashMap<String, Library> libNames = new HashMap<String, Library>();
            HashSet<String> toolList = new HashSet<String>();
            HashMap<String, String> errors = new HashMap<String, String>();
            for (Library newLib : libs) {
                LibraryManager.removeUnusedLibraries(newLib);
                this.baseLibsToEnable.addAll(LibraryManager.getUsedBaseLibraries(newLib));
            }
            Set<String> builtinLibraries = LibraryManager.getBuildinNames(source.getLoader());
            for (Library lib : source.getLibraries()) {
                String libName = lib.getName();
                if (!this.baseLibsToEnable.contains(libName) && builtinLibraries.contains(libName)) continue;
                this.baseLibsToEnable.remove(libName);
            }
            for (Library newLib : libs) {
                LibraryManager.removeBaseLibraries(newLib, this.baseLibsToEnable);
            }
            for (Library lib : source.getLibraries()) {
                LibraryTools.buildLibraryList(lib, libNames);
            }
            LibraryTools.buildToolList((Library)source, toolList);
            for (Library lib : libs) {
                if (libNames.containsKey(lib.getName().toUpperCase())) {
                    OptionPane.showMessageDialog(null, "\"" + lib.getName() + "\": " + Strings.S.get("LibraryAlreadyLoaded"), Strings.S.get("LibLoadErrors") + " " + lib.getName() + " !", 2);
                    continue;
                }
                LibraryTools.removePresentLibraries(lib, libNames, false);
                if (LibraryTools.isLibraryConform(lib, new HashSet<String>(), new HashSet<String>(), errors)) {
                    HashSet<String> addedToolList = new HashSet<String>();
                    LibraryTools.buildToolList(lib, addedToolList);
                    for (String tool : addedToolList) {
                        if (!toolList.contains(tool)) continue;
                        errors.put(tool, Strings.S.get("LibraryMultipleToolError"));
                    }
                    if (errors.keySet().isEmpty()) {
                        LibraryTools.buildLibraryList(lib, libNames);
                        toolList.addAll(addedToolList);
                        this.mergedLibs.add(lib);
                        continue;
                    }
                    LibraryTools.showErrors(lib.getName(), errors);
                    this.baseLibsToEnable.clear();
                    continue;
                }
                LibraryTools.showErrors(lib.getName(), errors);
            }
        }

        @Override
        public void doIt(Project proj) {
            for (String string : this.baseLibsToEnable) {
                LogisimFile logisimFile = proj.getLogisimFile();
                logisimFile.addLibrary(logisimFile.getLoader().getBuiltin().getLibrary(string));
            }
            for (Library library : this.mergedLibs) {
                if (library instanceof LoadedLibrary) {
                    LoadedLibrary lib1 = (LoadedLibrary)library;
                    if (lib1.getBase() instanceof LogisimFile) {
                        this.repair(proj, lib1.getBase());
                    }
                } else if (library instanceof LogisimFile) {
                    this.repair(proj, library);
                }
                proj.getLogisimFile().addLibrary(library);
            }
        }

        private void repair(Project proj, Library lib) {
            HashMap<String, AddTool> availableTools = new HashMap<String, AddTool>();
            LibraryTools.buildToolList((Library)proj.getLogisimFile(), availableTools);
            if (lib instanceof LogisimFile) {
                LogisimFile thisLib = (LogisimFile)lib;
                for (Circuit circ : thisLib.getCircuits()) {
                    for (Component tool : circ.getNonWires()) {
                        if (!availableTools.containsKey(tool.getFactory().getName().toUpperCase())) continue;
                        AddTool current = availableTools.get(tool.getFactory().getName().toUpperCase());
                        if (current != null) {
                            tool.setFactory(current.getFactory());
                            continue;
                        }
                        if ("Text".equals(tool.getFactory().getName())) {
                            Component newComp = Text.FACTORY.createComponent(tool.getLocation(), (AttributeSet)tool.getAttributeSet().clone());
                            tool.setFactory(newComp.getFactory());
                            continue;
                        }
                        System.out.println("Not found:" + tool.getFactory().getName());
                    }
                }
            }
            for (Library libs : lib.getLibraries()) {
                this.repair(proj, libs);
            }
        }

        @Override
        public boolean isModification() {
            return !this.mergedLibs.isEmpty();
        }

        @Override
        public String getName() {
            return this.mergedLibs.size() <= 1 ? Strings.S.get("loadLibraryAction") : Strings.S.get("loadLibrariesAction");
        }

        @Override
        public void undo(Project proj) {
            for (Library library : this.mergedLibs) {
                proj.getLogisimFile().removeLibrary(library);
            }
            for (String string : this.baseLibsToEnable) {
                proj.getLogisimFile().removeLibrary(string);
            }
        }
    }

    private static class MoveCircuit
    extends Action {
        private final AddTool tool;
        private int fromIndex;
        private final int toIndex;

        MoveCircuit(AddTool tool, int toIndex) {
            this.tool = tool;
            this.toIndex = toIndex;
        }

        @Override
        public Action append(Action other) {
            MoveCircuit ret = new MoveCircuit(this.tool, ((MoveCircuit)other).toIndex);
            ret.fromIndex = this.fromIndex;
            return ret.fromIndex == ret.toIndex ? null : ret;
        }

        @Override
        public void doIt(Project proj) {
            this.fromIndex = proj.getLogisimFile().getTools().indexOf(this.tool);
            proj.getLogisimFile().moveCircuit(this.tool, this.toIndex);
        }

        @Override
        public String getName() {
            return Strings.S.get("moveCircuitAction");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean shouldAppendTo(Action other) {
            if (!(other instanceof MoveCircuit)) return false;
            MoveCircuit circ = (MoveCircuit)other;
            if (circ.tool != this.tool) return false;
            return true;
        }

        @Override
        public void undo(Project proj) {
            proj.getLogisimFile().moveCircuit(this.tool, this.fromIndex);
        }
    }

    private static class RemoveCircuit
    extends Action {
        private final Circuit circuit;
        private int index;

        RemoveCircuit(Circuit circuit) {
            this.circuit = circuit;
        }

        @Override
        public void doIt(Project proj) {
            this.index = proj.getLogisimFile().indexOfCircuit(this.circuit);
            proj.getLogisimFile().removeCircuit(this.circuit);
        }

        @Override
        public String getName() {
            return Strings.S.get("removeCircuitAction");
        }

        @Override
        public void undo(Project proj) {
            proj.getLogisimFile().addCircuit(this.circuit, this.index);
        }
    }

    private static class RemoveVhdl
    extends Action {
        private final VhdlContent vhdl;
        private int index;

        RemoveVhdl(VhdlContent vhdl) {
            this.vhdl = vhdl;
        }

        @Override
        public void doIt(Project proj) {
            this.index = proj.getLogisimFile().indexOfVhdl(this.vhdl);
            proj.getLogisimFile().removeVhdl(this.vhdl);
        }

        @Override
        public String getName() {
            return Strings.S.get("removeVhdlAction");
        }

        @Override
        public void undo(Project proj) {
            proj.getLogisimFile().addVhdlContent(this.vhdl, this.index);
        }
    }

    private static class RevertDefaults
    extends Action {
        private Options oldOpts;
        private ArrayList<Library> libraries = null;
        private final ArrayList<RevertAttributeValue> attrValues = new ArrayList();

        RevertDefaults() {
        }

        private void copyToolAttributes(Library srcLib, Library dstLib) {
            for (Tool tool : srcLib.getTools()) {
                AttributeSet srcAttrs = tool.getAttributeSet();
                Tool dstTool = dstLib.getTool(tool.getName());
                if (srcAttrs == null || dstTool == null) continue;
                AttributeSet dstAttrs = dstTool.getAttributeSet();
                Iterator<Attribute<?>> iterator = srcAttrs.getAttributes().iterator();
                while (iterator.hasNext()) {
                    Attribute<Object> attrBase;
                    Attribute<Object> attr = attrBase = iterator.next();
                    Object srcValue = srcAttrs.getValue(attr);
                    Object dstValue = dstAttrs.getValue(attr);
                    if (dstValue.equals(srcValue)) continue;
                    dstAttrs.setValue(attr, srcValue);
                    this.attrValues.add(new RevertAttributeValue(dstAttrs, attr, dstValue));
                }
            }
        }

        @Override
        public void doIt(Project proj) {
            LogisimFile src = ProjectActions.createNewFile(proj);
            LogisimFile dst = proj.getLogisimFile();
            this.copyToolAttributes(src, dst);
            for (Library srcLib : src.getLibraries()) {
                Library dstLib = dst.getLibrary(srcLib.getName());
                if (dstLib == null) {
                    String desc = src.getLoader().getDescriptor(srcLib);
                    dstLib = dst.getLoader().loadLibrary(desc);
                    proj.getLogisimFile().addLibrary(dstLib);
                    if (this.libraries == null) {
                        this.libraries = new ArrayList();
                    }
                    this.libraries.add(dstLib);
                }
                this.copyToolAttributes(srcLib, dstLib);
            }
            Options newOpts = proj.getOptions();
            this.oldOpts = new Options();
            this.oldOpts.copyFrom(newOpts, dst);
            newOpts.copyFrom(src.getOptions(), dst);
        }

        @Override
        public String getName() {
            return Strings.S.get("revertDefaultsAction");
        }

        @Override
        public void undo(Project proj) {
            proj.getOptions().copyFrom(this.oldOpts, proj.getLogisimFile());
            for (RevertAttributeValue attrValue : this.attrValues) {
                attrValue.attrs.setValue(attrValue.attr, attrValue.value);
            }
            if (this.libraries != null) {
                for (Library lib : this.libraries) {
                    proj.getLogisimFile().removeLibrary(lib);
                }
            }
        }
    }

    private static class SetMainCircuit
    extends Action {
        private Circuit oldval;
        private final Circuit newval;

        SetMainCircuit(Circuit circuit) {
            this.newval = circuit;
        }

        @Override
        public void doIt(Project proj) {
            this.oldval = proj.getLogisimFile().getMainCircuit();
            proj.getLogisimFile().setMainCircuit(this.newval);
        }

        @Override
        public String getName() {
            return Strings.S.get("setMainCircuitAction");
        }

        @Override
        public void undo(Project proj) {
            proj.getLogisimFile().setMainCircuit(this.oldval);
        }
    }

    private static class UnloadLibraries
    extends Action {
        private final Library[] libs;

        UnloadLibraries(Library[] libs) {
            this.libs = libs;
        }

        @Override
        public void doIt(Project proj) {
            for (int i = this.libs.length - 1; i >= 0; --i) {
                proj.getLogisimFile().removeLibrary(this.libs[i]);
            }
        }

        @Override
        public String getName() {
            return this.libs.length == 1 ? Strings.S.get("unloadLibraryAction") : Strings.S.get("unloadLibrariesAction");
        }

        @Override
        public void undo(Project proj) {
            for (Library lib : this.libs) {
                proj.getLogisimFile().addLibrary(lib);
            }
        }
    }

    private static class RevertAttributeValue {
        private final AttributeSet attrs;
        private final Attribute<Object> attr;
        private final Object value;

        RevertAttributeValue(AttributeSet attrs, Attribute<Object> attr, Object value) {
            this.attrs = attrs;
            this.attr = attr;
            this.value = value;
        }
    }
}

