/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.Collections;
import java.util.List;
import org.reactfx.ProperObservable;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.QuasiListModificationImpl;
import org.reactfx.util.Lists;
import org.reactfx.util.NotificationAccumulator;

public interface ProperLiveList<E>
extends LiveList<E>,
ProperObservable<LiveList.Observer<? super E, ?>, QuasiListChange<? extends E>> {
    @Override
    default public NotificationAccumulator<LiveList.Observer<? super E, ?>, QuasiListChange<? extends E>, ?> defaultNotificationAccumulator() {
        return NotificationAccumulator.listNotifications();
    }

    default public void fireModification(QuasiListModification<? extends E> mod) {
        this.notifyObservers(mod.asListChange());
    }

    public static <E> QuasiListModification<E> elemReplacement(int index, E replaced) {
        return new QuasiListModificationImpl<E>(index, Collections.singletonList(replaced), 1);
    }

    default public void fireElemReplacement(int index, E replaced) {
        this.fireModification(ProperLiveList.elemReplacement(index, replaced));
    }

    default public QuasiListModification<E> contentReplacement(List<E> removed) {
        return new QuasiListModificationImpl<E>(0, removed, this.size());
    }

    default public void fireContentReplacement(List<E> removed) {
        this.fireModification(this.contentReplacement(removed));
    }

    public static <E> QuasiListModification<E> elemInsertion(int index) {
        return ProperLiveList.rangeInsertion(index, 1);
    }

    default public void fireElemInsertion(int index) {
        this.fireModification(ProperLiveList.elemInsertion(index));
    }

    public static <E> QuasiListModification<E> rangeInsertion(int index, int size) {
        return new QuasiListModificationImpl(index, Collections.emptyList(), size);
    }

    default public void fireRangeInsertion(int index, int size) {
        this.fireModification(ProperLiveList.rangeInsertion(index, size));
    }

    public static <E> QuasiListModification<E> elemRemoval(int index, E removed) {
        return new QuasiListModificationImpl<E>(index, Collections.singletonList(removed), 0);
    }

    default public void fireElemRemoval(int index, E removed) {
        this.fireModification(ProperLiveList.elemRemoval(index, removed));
    }

    public static <E> QuasiListModification<E> rangeRemoval(int index, List<E> removed) {
        return new QuasiListModificationImpl<E>(index, removed, 0);
    }

    default public void fireRemoveRange(int index, List<E> removed) {
        this.fireModification(ProperLiveList.rangeRemoval(index, removed));
    }

    @Override
    default public int defaultHashCode() {
        return Lists.hashCode(this);
    }

    @Override
    default public boolean defaultEquals(Object o) {
        return Lists.equals(this, o);
    }

    @Override
    default public String defaultToString() {
        return Lists.toString(this);
    }
}

