/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.util.regex.Pattern;

public class FrenchPunctuationSpacing {
    private static final Pattern SPACE_AFTER_LEFT_GUILLEMET = Pattern.compile("([\u00ab|\u2039])\\h*(?=\\H)");
    private static final Pattern SPACE_BEFORE_RIGHT_GUILLEMET = Pattern.compile("(?<=\\H)\\h*([\u00bb|\u203a])");
    private static final Pattern SPACES_AROUND_COLON = Pattern.compile("(?<=\\H)\\h*(:[\\s\u00a0])(?=\\H)");
    private static final Pattern SPACE_BEFORE_PUNCTUATION = Pattern.compile("(?<=[^\\h;?!])\\h*([;?!])");

    public static String apply(String str) {
        str = SPACE_AFTER_LEFT_GUILLEMET.matcher(str).replaceAll("$1\u202f");
        str = SPACE_BEFORE_RIGHT_GUILLEMET.matcher(str).replaceAll("\u202f$1");
        str = SPACES_AROUND_COLON.matcher(str).replaceAll("\u00a0$1");
        str = SPACE_BEFORE_PUNCTUATION.matcher(str).replaceAll("\u202f$1");
        return str;
    }
}

