/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SessionConfiguration;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnugglePackage;
import uk.ac.ed.ph.snuggletex.SnuggleSnapshot;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.XMLStringOutputOptions;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.MathCharacter;
import uk.ac.ed.ph.snuggletex.definitions.UserDefinedCommand;
import uk.ac.ed.ph.snuggletex.definitions.UserDefinedEnvironment;
import uk.ac.ed.ph.snuggletex.internal.DOMBuildingController;
import uk.ac.ed.ph.snuggletex.internal.LaTeXTokeniser;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleInputReader;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.StyleEvaluator;
import uk.ac.ed.ph.snuggletex.internal.StyleRebuilder;
import uk.ac.ed.ph.snuggletex.internal.TokenFixer;
import uk.ac.ed.ph.snuggletex.internal.WebPageBuilder;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.RootToken;
import uk.ac.ed.ph.snuggletex.utilities.SerializationOptions;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

public final class SnuggleSession
implements SessionContext {
    private final SnuggleEngine engine;
    private final SnugglePackage[] packages;
    private final LaTeXTokeniser tokeniser;
    private final StyleEvaluator styleEvaluator;
    private final TokenFixer tokenFixer;
    private final StyleRebuilder styleRebuilder;
    private final SessionConfiguration configuration;
    final DOMOutputOptions defaultDOMOutputOptions;
    final XMLStringOutputOptions defaultXMLStringOutputOptions;
    private final List<InputError> errors;
    private final Map<String, UserDefinedCommand> userCommandMap;
    private final Map<String, UserDefinedEnvironment> userEnvironmentMap;
    private final List<FlowToken> parsedTokens;

    SnuggleSession(SnuggleEngine engine, SessionConfiguration configuration) {
        this.engine = engine;
        this.packages = engine.getPackages().toArray(new SnugglePackage[engine.getPackages().size()]);
        this.configuration = (SessionConfiguration)configuration.clone();
        this.defaultDOMOutputOptions = (DOMOutputOptions)engine.getDefaultDOMOutputOptions().clone();
        this.defaultXMLStringOutputOptions = (XMLStringOutputOptions)engine.getDefaultXMLStringOutputOptions().clone();
        this.tokeniser = new LaTeXTokeniser(this);
        this.styleEvaluator = new StyleEvaluator(this);
        this.tokenFixer = new TokenFixer(this);
        this.styleRebuilder = new StyleRebuilder(this);
        this.errors = new ArrayList<InputError>();
        this.userCommandMap = new HashMap<String, UserDefinedCommand>();
        this.userEnvironmentMap = new HashMap<String, UserDefinedEnvironment>();
        this.parsedTokens = new ArrayList<FlowToken>();
    }

    SnuggleSession(SnuggleSnapshot snapshot) {
        this.engine = snapshot.engine;
        this.packages = snapshot.packages;
        this.configuration = snapshot.configuration;
        this.defaultDOMOutputOptions = snapshot.defaultDOMOutputOptions;
        this.defaultXMLStringOutputOptions = snapshot.defaultXMLStringOutputOptions;
        this.tokeniser = new LaTeXTokeniser(this);
        this.styleEvaluator = new StyleEvaluator(this);
        this.tokenFixer = new TokenFixer(this);
        this.styleRebuilder = new StyleRebuilder(this);
        this.errors = new ArrayList<InputError>(snapshot.errors);
        this.userCommandMap = new HashMap<String, UserDefinedCommand>(snapshot.userCommandMap);
        this.userEnvironmentMap = new HashMap<String, UserDefinedEnvironment>(snapshot.userEnvironmentMap);
        this.parsedTokens = new ArrayList<FlowToken>(snapshot.parsedTokens);
    }

    @Override
    public SessionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public List<InputError> getErrors() {
        return this.errors;
    }

    public List<FlowToken> getParsedTokens() {
        return this.parsedTokens;
    }

    public boolean parseInput(SnuggleInput snuggleInput) throws IOException {
        ConstraintUtilities.ensureNotNull(snuggleInput, "snuggleInput");
        try {
            SnuggleInputReader reader = new SnuggleInputReader(this, snuggleInput);
            RootToken rootToken = this.tokeniser.tokenise(reader);
            this.styleEvaluator.evaluateStyles(rootToken);
            this.tokenFixer.fixTokenTree(rootToken);
            this.styleRebuilder.rebuildStyles(rootToken);
            this.parsedTokens.addAll(rootToken.getContents());
        }
        catch (SnuggleParseException e) {
            return false;
        }
        return true;
    }

    public SnuggleSnapshot createSnapshot() {
        return new SnuggleSnapshot(this.engine, this.packages, (SessionConfiguration)this.configuration.clone(), (DOMOutputOptions)this.defaultDOMOutputOptions.clone(), (XMLStringOutputOptions)this.defaultXMLStringOutputOptions.clone(), new ArrayList<InputError>(this.errors), new HashMap<String, UserDefinedCommand>(this.userCommandMap), new HashMap<String, UserDefinedEnvironment>(this.userEnvironmentMap), new ArrayList<FlowToken>(this.parsedTokens));
    }

    public void reset() {
        this.errors.clear();
        this.userCommandMap.clear();
        this.userEnvironmentMap.clear();
        this.parsedTokens.clear();
        this.tokeniser.reset();
    }

    public boolean buildDOMSubtree(Element targetRoot, DOMOutputOptions options) {
        ConstraintUtilities.ensureNotNull(targetRoot, "targetRoot");
        ConstraintUtilities.ensureNotNull(options, "options");
        try {
            new DOMBuildingController(this, options).buildDOMSubtree(targetRoot, this.parsedTokens);
            return true;
        }
        catch (SnuggleParseException e) {
            return false;
        }
    }

    public boolean buildDOMSubtree(Element targetRoot) {
        return this.buildDOMSubtree(targetRoot, this.defaultDOMOutputOptions);
    }

    public NodeList buildDOMSubtree() {
        return this.buildDOMSubtree(this.defaultDOMOutputOptions);
    }

    public NodeList buildDOMSubtree(DOMOutputOptions options) {
        ConstraintUtilities.ensureNotNull(options, "DOMOutputOptions");
        Document document = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        Element temporaryRoot = document.createElementNS("http://www.ph.ed.ac.uk/snuggletex", "root");
        document.appendChild(temporaryRoot);
        if (!this.buildDOMSubtree(temporaryRoot, options)) {
            return null;
        }
        return temporaryRoot.getChildNodes();
    }

    public String buildXMLString() {
        return this.buildXMLString(this.defaultXMLStringOutputOptions);
    }

    public String buildXMLString(XMLStringOutputOptions options) {
        ConstraintUtilities.ensureNotNull(options, "XMLStringOutputOptions");
        DocumentBuilder documentBuilder = XMLUtilities.createNSAwareDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element temporaryRoot = document.createElement("root");
        document.appendChild(temporaryRoot);
        if (!this.buildDOMSubtree(temporaryRoot, options)) {
            return null;
        }
        return XMLUtilities.serializeNodeChildren(this.getStylesheetManager(), temporaryRoot, options);
    }

    @Deprecated
    public String buildXMLString(boolean indent) {
        return this.buildXMLString(this.defaultDOMOutputOptions, indent);
    }

    @Deprecated
    public String buildXMLString(DOMOutputOptions options) {
        return this.buildXMLString(options, false);
    }

    @Deprecated
    public String buildXMLString(DOMOutputOptions options, boolean indent) {
        DocumentBuilder documentBuilder = XMLUtilities.createNSAwareDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element temporaryRoot = document.createElement("root");
        document.appendChild(temporaryRoot);
        if (!this.buildDOMSubtree(temporaryRoot, options)) {
            return null;
        }
        SerializationOptions serializationOptions = new SerializationOptions();
        serializationOptions.setEncoding("UTF-8");
        serializationOptions.setIndenting(indent);
        return XMLUtilities.serializeNodeChildren(this.getStylesheetManager(), temporaryRoot, serializationOptions);
    }

    public Document buildWebPage(WebPageOutputOptions options) {
        ConstraintUtilities.ensureNotNull(options, "options");
        try {
            return new WebPageBuilder(this, options).buildWebPage(this.parsedTokens);
        }
        catch (SnuggleParseException e) {
            return null;
        }
    }

    @Deprecated
    public Document createWebPage(WebPageOutputOptions options) {
        return this.buildWebPage(options);
    }

    public String buildWebPageString(WebPageOutputOptions options) {
        ConstraintUtilities.ensureNotNull(options, "options");
        try {
            return new WebPageBuilder(this, options).buildWebPageString(this.parsedTokens);
        }
        catch (SnuggleParseException e) {
            return null;
        }
    }

    public boolean writeWebPage(WebPageOutputOptions options, OutputStream outputStream) throws IOException {
        return this.writeWebPage(options, null, outputStream, EndOutputAction.CLOSE);
    }

    public boolean writeWebPage(WebPageOutputOptions options, OutputStream outputStream, EndOutputAction endOutputAction) throws IOException {
        return this.writeWebPage(options, null, outputStream, endOutputAction);
    }

    public boolean writeWebPage(WebPageOutputOptions options, Object contentTypeSettable, OutputStream outputStream) throws IOException {
        return this.writeWebPage(options, contentTypeSettable, outputStream, EndOutputAction.CLOSE);
    }

    public boolean writeWebPage(WebPageOutputOptions options, Object contentTypeSettable, OutputStream outputStream, EndOutputAction endOutputAction) throws IOException {
        ConstraintUtilities.ensureNotNull(options, "options");
        ConstraintUtilities.ensureNotNull(outputStream, "outputStream");
        ConstraintUtilities.ensureNotNull((Object)endOutputAction, "endOutputAction");
        try {
            new WebPageBuilder(this, options).writeWebPage(this.parsedTokens, contentTypeSettable, outputStream, endOutputAction);
            return true;
        }
        catch (SnuggleParseException e) {
            return false;
        }
    }

    public void setWebPageContentType(WebPageOutputOptions options, Object contentTypeSettable) {
        ConstraintUtilities.ensureNotNull(options, "options");
        ConstraintUtilities.ensureNotNull(contentTypeSettable, "contentTypeSettable");
        new WebPageBuilder(this, options).setWebPageContentType(contentTypeSettable);
    }

    @Override
    public MathCharacter getMathCharacter(int codePoint) {
        SnugglePackage snugglePackage;
        MathCharacter result = null;
        SnugglePackage[] snugglePackageArray = this.packages;
        int n = snugglePackageArray.length;
        for (int i = 0; i < n && (result = (snugglePackage = snugglePackageArray[i]).getMathCharacter(codePoint)) == null; ++i) {
        }
        return result;
    }

    @Override
    public BuiltinCommand getBuiltinCommandByTeXName(String texName) {
        SnugglePackage snugglePackage;
        ConstraintUtilities.ensureNotNull(texName, "texName");
        BuiltinCommand result = null;
        SnugglePackage[] snugglePackageArray = this.packages;
        int n = snugglePackageArray.length;
        for (int i = 0; i < n && (result = (snugglePackage = snugglePackageArray[i]).getBuiltinCommandByTeXName(texName)) == null; ++i) {
        }
        return result;
    }

    @Override
    public BuiltinEnvironment getBuiltinEnvironmentByTeXName(String texName) {
        SnugglePackage snugglePackage;
        ConstraintUtilities.ensureNotNull(texName, "texName");
        BuiltinEnvironment result = null;
        SnugglePackage[] snugglePackageArray = this.packages;
        int n = snugglePackageArray.length;
        for (int i = 0; i < n && (result = (snugglePackage = snugglePackageArray[i]).getBuiltinEnvironmentByTeXName(texName)) == null; ++i) {
        }
        return result;
    }

    @Override
    public Map<String, UserDefinedCommand> getUserCommandMap() {
        return this.userCommandMap;
    }

    @Override
    public Map<String, UserDefinedEnvironment> getUserEnvironmentMap() {
        return this.userEnvironmentMap;
    }

    @Override
    public StylesheetManager getStylesheetManager() {
        return this.engine.getStylesheetManager();
    }

    @Override
    public void registerError(InputError inputError) throws SnuggleParseException {
        ConstraintUtilities.ensureNotNull(inputError, "InputError");
        this.errors.add(inputError);
        if (this.configuration.isFailingFast()) {
            throw new SnuggleParseException(inputError);
        }
    }

    public static enum EndOutputAction {
        CLOSE,
        FLUSH,
        DO_NOTHING;

    }
}

