/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.types.BiblatexAPAEntryTypeDefinitions;
import org.jabref.model.entry.types.BiblatexEntryTypeDefinitions;
import org.jabref.model.entry.types.BiblatexSoftwareEntryTypeDefinitions;
import org.jabref.model.entry.types.BibtexEntryTypeDefinitions;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.entry.types.IEEETranEntryTypeDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibEntryTypesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibEntryTypesManager.class);
    private final InternalEntryTypes BIBTEX_ENTRYTYPES = new InternalEntryTypes(Stream.concat(BibtexEntryTypeDefinitions.ALL.stream(), IEEETranEntryTypeDefinitions.ALL.stream()).collect(Collectors.toList()));
    private final InternalEntryTypes BIBLATEX_ENTRYTYPES = new InternalEntryTypes(Stream.concat(BiblatexEntryTypeDefinitions.ALL.stream(), Stream.concat(BiblatexSoftwareEntryTypeDefinitions.ALL.stream(), BiblatexAPAEntryTypeDefinitions.ALL.stream())).collect(Collectors.toList()));

    @VisibleForTesting
    InternalEntryTypes getEntryTypes(BibDatabaseMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case BibDatabaseMode.BIBTEX -> this.BIBTEX_ENTRYTYPES;
            case BibDatabaseMode.BIBLATEX -> this.BIBLATEX_ENTRYTYPES;
        };
    }

    public Collection<BibEntryType> getAllTypes(BibDatabaseMode mode) {
        return this.getEntryTypes(mode).getAllTypes();
    }

    public Collection<BibEntryType> getAllCustomizedTypes(BibDatabaseMode mode) {
        return this.getEntryTypes(mode).getAllCustomizedTypes();
    }

    public List<BibEntryType> getAllCustomTypes(BibDatabaseMode mode) {
        return this.getEntryTypes(mode).getAllCustomTypes();
    }

    public boolean isCustomOrModifiedType(BibEntryType type, BibDatabaseMode mode) {
        return this.getEntryTypes(mode).isCustomOrModifiedType(type);
    }

    public boolean isDifferentCustomOrModifiedType(BibEntryType type, BibDatabaseMode mode) {
        Optional<BibEntryType> currentlyStoredType = this.enrich(type.getType(), mode);
        if (currentlyStoredType.isEmpty()) {
            return true;
        }
        return !EntryTypeFactory.nameAndFieldsAreEqual(type, currentlyStoredType.get());
    }

    public void addCustomOrModifiedTypes(List<BibEntryType> customizedEntryTypes, BibDatabaseMode mode) {
        InternalEntryTypes entryTypes = this.getEntryTypes(mode);
        customizedEntryTypes.forEach(entryTypes::addCustomOrModifiedType);
    }

    public void addCustomOrModifiedType(BibEntryType entryType, BibDatabaseMode mode) {
        this.getEntryTypes(mode).addCustomOrModifiedType(entryType);
    }

    public void update(BibEntryType entryType, BibDatabaseMode mode) {
        Optional<BibEntryType> standardTypeOpt;
        InternalEntryTypes entryTypes = this.getEntryTypes(mode);
        if (entryTypes.standardTypes.contains(entryType)) {
            entryTypes.removeCustomOrModifiedEntryType(entryType);
            return;
        }
        if (!entryTypes.isStandardType(entryType)) {
            entryTypes.addCustomOrModifiedType(entryType);
        }
        if ((standardTypeOpt = entryTypes.standardTypes.stream().filter(InternalEntryTypes.typeEquals(entryType.getType())).findFirst()).isEmpty()) {
            LOGGER.debug("Standard type not found for {}", (Object)entryType.getType());
            entryTypes.addCustomOrModifiedType(entryType);
            return;
        }
        BibEntryType standardType = standardTypeOpt.get();
        Set standardRequiredFields = standardType.getRequiredFields().stream().map(OrFields::getFields).flatMap(Collection::stream).collect(Collectors.toSet());
        SequencedSet<BibField> standardOptionalFields = standardType.getOptionalFields();
        Set entryTypeRequiredFields = entryType.getRequiredFields().stream().map(OrFields::getFields).flatMap(Collection::stream).collect(Collectors.toSet());
        SequencedSet<BibField> entryTypeOptionalFields = entryType.getOptionalFields();
        if (standardRequiredFields.equals(entryTypeRequiredFields) && standardOptionalFields.equals(entryTypeOptionalFields)) {
            entryTypes.removeCustomOrModifiedEntryType(entryType);
            return;
        }
        LOGGER.debug("Different standard type fields for {} and standard {}", (Object)entryType, (Object)standardType);
        entryTypes.addCustomOrModifiedType(entryType);
    }

    public void removeCustomOrModifiedEntryType(BibEntryType entryType, BibDatabaseMode mode) {
        this.getEntryTypes(mode).removeCustomOrModifiedEntryType(entryType);
    }

    public void clearAllCustomEntryTypes(BibDatabaseMode mode) {
        this.getEntryTypes(mode).clearAllCustomEntryTypes();
    }

    public boolean isCustomType(EntryType type, BibDatabaseMode mode) {
        return !this.getEntryTypes(mode).isStandardType(type) && this.enrich(type, mode).isPresent();
    }

    public boolean isCustomType(BibEntryType type, BibDatabaseMode mode) {
        return !this.getEntryTypes(mode).isStandardType(type) && this.getEntryTypes(mode).isCustomOrModifiedType(type);
    }

    public Optional<BibEntryType> enrich(EntryType type, BibDatabaseMode mode) {
        return this.getEntryTypes(mode).enrich(type);
    }

    @VisibleForTesting
    static class InternalEntryTypes {
        @VisibleForTesting
        final Set<BibEntryType> standardTypes;
        private final SortedSet<BibEntryType> customOrModifiedType = new TreeSet<BibEntryType>();

        private InternalEntryTypes(List<BibEntryType> standardTypes) {
            this.standardTypes = new HashSet<BibEntryType>(standardTypes);
        }

        private List<BibEntryType> getAllCustomTypes() {
            SortedSet<BibEntryType> customizedTypes = this.getAllTypes();
            return customizedTypes.stream().filter(bibEntryType -> this.standardTypes.stream().noneMatch(item -> item.getType().equals(bibEntryType.getType()))).toList();
        }

        private Optional<BibEntryType> enrich(EntryType type) {
            Optional<BibEntryType> enrichedType = this.customOrModifiedType.stream().filter(InternalEntryTypes.typeEquals(type)).findFirst();
            if (enrichedType.isPresent()) {
                LOGGER.debug("Using customized entry type for {}", (Object)type.getName());
                return enrichedType;
            }
            return this.standardTypes.stream().filter(InternalEntryTypes.typeEquals(type)).findFirst();
        }

        static Predicate<BibEntryType> typeEquals(EntryType toCompare) {
            return item -> item.getType().equals(toCompare);
        }

        private void addCustomOrModifiedType(BibEntryType type) {
            this.customOrModifiedType.remove(type);
            this.customOrModifiedType.add(type);
        }

        private void removeCustomOrModifiedEntryType(BibEntryType type) {
            this.customOrModifiedType.remove(type);
        }

        private void clearAllCustomEntryTypes() {
            this.customOrModifiedType.clear();
        }

        private SortedSet<BibEntryType> getAllTypes() {
            TreeSet<BibEntryType> allTypes = new TreeSet<BibEntryType>(this.customOrModifiedType);
            allTypes.addAll(this.standardTypes);
            return allTypes;
        }

        private SortedSet<BibEntryType> getAllCustomizedTypes() {
            return new TreeSet<BibEntryType>(this.customOrModifiedType);
        }

        private boolean isCustomOrModifiedType(BibEntryType entryType) {
            boolean contains = this.customOrModifiedType.contains(entryType);
            if (!contains) {
                return false;
            }
            Optional<BibEntryType> standardType = this.getStandardType(entryType);
            if (standardType.isEmpty()) {
                return true;
            }
            return !EntryTypeFactory.nameAndFieldsAreEqual(standardType.get(), entryType);
        }

        private Optional<BibEntryType> getStandardType(BibEntryType entryType) {
            return this.standardTypes.stream().filter(item -> item.getType().equals(entryType.getType())).findAny();
        }

        private boolean isStandardType(BibEntryType entryType) {
            return this.getStandardType(entryType).isPresent();
        }

        private boolean isStandardType(EntryType entryType) {
            return this.standardTypes.stream().anyMatch(item -> item.getType().equals(entryType));
        }
    }
}

