/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.search;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.search.SearchMatcher;
import org.jabref.model.search.rules.ContainsBasedSearchRule;
import org.jabref.model.search.rules.GrammarBasedSearchRule;
import org.jabref.model.search.rules.SearchRule;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.search.rules.SentenceAnalyzer;

public class SearchQuery
implements SearchMatcher {
    private final String query;
    private EnumSet<SearchRules.SearchFlags> searchFlags;
    private final SearchRule rule;

    public SearchQuery(String query, EnumSet<SearchRules.SearchFlags> searchFlags) {
        this.query = Objects.requireNonNull(query);
        this.searchFlags = searchFlags;
        this.rule = SearchRules.getSearchRuleByQuery(query, searchFlags);
    }

    public String toString() {
        return "\"%s\" (%s, %s) %s".formatted(this.getQuery(), this.getCaseSensitiveDescription(), this.getRegularExpressionDescription(), this.searchFlags);
    }

    @Override
    public boolean isMatch(BibEntry entry) {
        return this.rule.applyRule(this.getQuery(), entry);
    }

    public boolean isValid() {
        return this.rule.validateSearchStrings(this.getQuery());
    }

    public boolean isContainsBasedSearch() {
        return this.rule instanceof ContainsBasedSearchRule;
    }

    private String getCaseSensitiveDescription() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
            return "case sensitive";
        }
        return "case insensitive";
    }

    private String getRegularExpressionDescription() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION)) {
            return "regular expression";
        }
        return "plain text";
    }

    public String localize() {
        return "\"%s\" (%s, %s)".formatted(this.getQuery(), this.getLocalizedCaseSensitiveDescription(), this.getLocalizedRegularExpressionDescription());
    }

    private String getLocalizedCaseSensitiveDescription() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
            return Localization.lang("case sensitive", new Object[0]);
        }
        return Localization.lang("case insensitive", new Object[0]);
    }

    private String getLocalizedRegularExpressionDescription() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION)) {
            return Localization.lang("regular expression", new Object[0]);
        }
        return Localization.lang("plain text", new Object[0]);
    }

    public boolean isGrammarBasedSearch() {
        return this.rule instanceof GrammarBasedSearchRule;
    }

    public String getQuery() {
        return this.query;
    }

    public EnumSet<SearchRules.SearchFlags> getSearchFlags() {
        return this.searchFlags;
    }

    public List<String> getSearchWords() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION)) {
            return Collections.singletonList(this.getQuery());
        }
        return new SentenceAnalyzer(this.getQuery()).getWords();
    }

    public Optional<Pattern> getPatternForWords() {
        return this.joinWordsToPattern(EscapeMode.JAVA);
    }

    public Optional<Pattern> getJavaScriptPatternForWords() {
        return this.joinWordsToPattern(EscapeMode.JAVASCRIPT);
    }

    private Optional<Pattern> joinWordsToPattern(EscapeMode escapeMode) {
        List<String> words = this.getSearchWords();
        if (words == null || words.isEmpty() || words.getFirst().isEmpty()) {
            return Optional.empty();
        }
        Stream<Object> joiner = words.stream();
        if (!this.searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION)) {
            joiner = joiner.map(escapeMode::format);
        }
        String searchPattern = joiner.collect(Collectors.joining(")|(", "(", ")"));
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
            return Optional.of(Pattern.compile(searchPattern));
        }
        return Optional.of(Pattern.compile(searchPattern, 2));
    }

    public SearchRule getRule() {
        return this.rule;
    }

    private static enum EscapeMode {
        JAVA{

            @Override
            String format(String regex) {
                return Pattern.quote(regex);
            }
        }
        ,
        JAVASCRIPT{

            @Override
            String format(String regex) {
                return JAVASCRIPT_ESCAPED_CHARS_PATTERN.matcher(regex).replaceAll("\\\\$0");
            }
        };

        private static final Pattern JAVASCRIPT_ESCAPED_CHARS_PATTERN;

        abstract String format(String var1);

        static {
            JAVASCRIPT_ESCAPED_CHARS_PATTERN = Pattern.compile("[.*+?^${}()|\\[\\]\\\\/]");
        }
    }
}

